/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.OperatingSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfilesIni {
    private Map<String, FirefoxProfile> profiles = new HashMap<String, FirefoxProfile>();

    public ProfilesIni() {
        File appData = this.locateAppDataDirectory(OperatingSystem.getCurrentPlatform());
        this.profiles = this.readProfiles(appData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, FirefoxProfile> readProfiles(File appData) {
        File profilesIni = new File(appData, "profiles.ini");
        if (!profilesIni.exists()) {
            throw new RuntimeException("Unable to locate the profiles.ini file, which contains information about where to locate the profiles");
        }
        HashMap<String, FirefoxProfile> toReturn = new HashMap<String, FirefoxProfile>();
        boolean isRelative = true;
        String name = null;
        String path = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(profilesIni));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("[Profile")) {
                    FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put(name, profile);
                    }
                    name = null;
                    path = null;
                } else if (line.startsWith("Name=")) {
                    name = line.substring("Name=".length());
                } else if (line.startsWith("IsRelative=")) {
                    isRelative = line.endsWith("1");
                } else if (line.startsWith("Path=")) {
                    path = line.substring("Path=".length());
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader == null) throw throwable;
                    FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
                    if (profile != null) {
                        toReturn.put(name, profile);
                    }
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (reader == null) return toReturn;
            FirefoxProfile profile = this.newProfile(name, appData, path, isRelative);
            if (profile != null) {
                toReturn.put(name, profile);
            }
            reader.close();
            return toReturn;
        }
        catch (IOException e) {
            return toReturn;
        }
    }

    protected FirefoxProfile newProfile(String name, File appData, String path, boolean isRelative) {
        if (name != null && path != null) {
            File profileDir = isRelative ? new File(appData, path) : new File(path);
            return new FirefoxProfile(profileDir);
        }
        return null;
    }

    public FirefoxProfile getProfile(String profileName) {
        return this.profiles.get(profileName);
    }

    public Collection<FirefoxProfile> getExistingProfiles() {
        return this.profiles.values();
    }

    protected File locateAppDataDirectory(OperatingSystem os) {
        File appData;
        switch (os) {
            case WINDOWS: {
                appData = new File(MessageFormat.format("{0}\\Mozilla\\Firefox", System.getenv("APPDATA")));
                break;
            }
            case MAC: {
                appData = new File(MessageFormat.format("{0}/Library/Application Support/Firefox", System.getenv("HOME")));
                break;
            }
            default: {
                appData = new File(MessageFormat.format("{0}/.mozilla/firefox", System.getenv("HOME")));
            }
        }
        if (!appData.exists()) {
            throw new RuntimeException("Unable to locate directory which should contain the information about Firefox profiles.\nTried looking in: " + appData.getAbsolutePath());
        }
        if (!appData.isDirectory()) {
            throw new RuntimeException("The discovered user firefox data directory (which normally contains the profiles) isn't a directory: " + appData.getAbsolutePath());
        }
        return appData;
    }
}

