/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.lang.reflect.Constructor;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.firefox.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response {
    private final JSONObject result;
    private final String methodName;
    private final Context context;
    private final String responseText;
    private boolean isError;

    public Response(String json) {
        try {
            this.result = new JSONObject(json.trim());
            this.methodName = (String)this.result.get("commandName");
            String contextAsString = (String)this.result.get("context");
            this.context = contextAsString != null ? new Context(contextAsString) : null;
            this.responseText = String.valueOf(this.result.get("response"));
            this.isError = (Boolean)this.result.get("isError");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCommand() {
        return this.methodName;
    }

    public Context getContext() {
        return this.context;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public boolean isError() {
        return this.isError;
    }

    public String toString() {
        return this.result.toString();
    }

    public Object getExtraResult(String fieldName) {
        try {
            return this.result.get(fieldName);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void ifNecessaryThrow(Class<? extends RuntimeException> exceptionClass) {
        RuntimeException toThrow;
        if (!this.isError) {
            return;
        }
        try {
            Constructor<? extends RuntimeException> constructor = exceptionClass.getConstructor(String.class);
            toThrow = constructor.newInstance(this.getResponseText());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(this.getResponseText());
        }
        throw toThrow;
    }
}

