/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.FirefoxBinary;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.firefox.internal.RunningInstanceConnection;

public class FirefoxLauncher {
    public static void main(String[] args) throws IOException {
        FirefoxLauncher launcher = new FirefoxLauncher();
        if (args.length == 0) {
            launcher.createBaseWebDriverProfile();
        } else if (args.length == 1) {
            launcher.createBaseWebDriverProfile(args[0]);
        } else {
            launcher.createBaseWebDriverProfile(args[0], Integer.parseInt(args[1]));
        }
    }

    public void createBaseWebDriverProfile() throws IOException {
        this.createBaseWebDriverProfile("WebDriver");
    }

    public void createBaseWebDriverProfile(String profileName) throws IOException {
        this.createBaseWebDriverProfile(profileName, 7055);
    }

    public void createBaseWebDriverProfile(String profileName, int port) throws IOException {
        this.connectAndKill(port);
        FirefoxBinary binary = new FirefoxBinary();
        System.out.println(String.format("Creating %s", profileName));
        try {
            binary.createProfile(profileName);
            System.out.println("Profile created");
            binary.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ProfilesIni allProfiles = new ProfilesIni();
        FirefoxProfile profile = allProfiles.getProfile(profileName);
        System.out.println("Attempting to install the WebDriver extension");
        profile.addWebDriverExtensionIfNeeded(true);
        System.out.println("Updating user preferences with common, useful settings");
        profile.setPort(port);
        profile.updateUserPrefs();
        System.out.println("Deleting existing extensions cache (if it already exists)");
        profile.deleteExtensionsCacheIfItExists();
        System.out.println("Firefox should now start and quit");
        binary.startProfile(profile, new String[0]);
        this.repeatedlyConnectUntilFirefoxAppearsStable(port);
    }

    private void repeatedlyConnectUntilFirefoxAppearsStable(int port) {
        long maxWaitTime = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < maxWaitTime) {
            try {
                RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 1000L);
                Thread.sleep(2000L);
                connection.quit();
                return;
            }
            catch (ConnectException e) {
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void connectAndKill(int port) {
        try {
            RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 5000L);
            connection.quit();
        }
        catch (ConnectException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FirefoxBinary startProfile(FirefoxProfile profile, int port) throws IOException {
        return this.startProfile(profile, null, port);
    }

    public FirefoxBinary startProfile(FirefoxProfile originalProfile, File firefoxBinary, int port) throws IOException {
        FirefoxBinary binary = new FirefoxBinary(firefoxBinary);
        FirefoxProfile profile = originalProfile.createCopy(port);
        binary.clean(profile);
        binary.startProfile(profile, new String[0]);
        return binary;
    }
}

