/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.htmlrunner.HTMLLauncher;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HTMLRunnerTest
extends TestCase
implements HTMLResultsListener {
    SeleniumServer server;
    HTMLLauncher launcher;
    HTMLTestResults results = null;
    protected String suiteName = "TestSuite.html";
    protected String browserURL;
    File output;

    public void setUp() throws Exception {
        this.output = new File(this.getName() + "-results.html");
        System.out.println("Will print results to " + this.output.getAbsolutePath());
        this.server = new SeleniumServer(4444);
        this.launcher = new HTMLLauncher(this.server);
        this.server.start();
        this.browserURL = "http://localhost:" + this.server.getPort();
    }

    public void runHTMLSuite(String browser) throws Exception {
        String testURL = this.browserURL + "/selenium-server/tests/" + this.suiteName;
        long timeout = 600000L;
        String result = this.launcher.runHTMLSuite(browser, this.browserURL, testURL, this.output, timeout);
        HTMLRunnerTest.assertTrue((String)("Results file doesn't exist: " + this.output.getAbsolutePath()), (boolean)this.output.exists());
        HTMLRunnerTest.assertEquals((String)"Tests didn't pass", (String)"PASSED", (String)result);
    }

    public void testFirefox() throws Exception {
        this.runHTMLSuite("*firefox");
    }

    public void testIExplore() throws Exception {
        this.runHTMLSuite("*iexplore");
    }

    public void testChrome() throws Exception {
        this.runHTMLSuite("*chrome");
    }

    public void testOpera() throws Exception {
        this.runHTMLSuite("*opera");
    }

    public void testHTA() throws Exception {
        try {
            this.runHTMLSuite("*iehta");
            HTMLRunnerTest.fail((String)"Didn't catch expected exception");
        }
        catch (UnsupportedOperationException e) {
            System.out.println("caught expected exception");
        }
    }

    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void processResults(HTMLTestResults r) {
        this.results = r;
    }
}

