/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.util.FileNameMapper;
import org.openqa.selenium.Xlator;

public class XlatorTask
extends Task {
    private Vector<FileSet> _filesets = new Vector();
    private HashMap<String, String> options = new HashMap();
    private Mapper mapperElement;
    private File destDir;
    private FormatterType formatter;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setFormatter(FormatterType formatter) {
        this.formatter = formatter;
    }

    public void addFileSet(FileSet fs) {
        this._filesets.addElement(fs);
    }

    public void addConfiguredOption(Property p) {
        this.options.put(p.getName(), p.getValue());
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    private void createDefaultMapper() {
        if (this.mapperElement != null) {
            return;
        }
        assert (this.formatter != null);
        String extension = this.formatter.getExtension();
        this.createMapper();
        assert (this.mapperElement != null);
        Mapper.MapperType t = new Mapper.MapperType();
        t.setValue("glob");
        this.mapperElement.setType(t);
        this.mapperElement.setFrom("*.html");
        this.mapperElement.setTo("*." + extension);
    }

    public void execute() throws BuildException {
        this.checkPreconditions();
        FileNameMapper mapper = this.mapperElement.getImplementation();
        for (int i = 0; i < this._filesets.size(); ++i) {
            FileSet fs = this._filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            File d = fs.getDir(this.getProject());
            if (files.length <= 0) continue;
            this.log("Handling " + files.length + " files from " + d.getAbsolutePath());
            for (int j = 0; j < files.length; ++j) {
                String fileName = files[j];
                this.translateFile(mapper, d, fileName);
            }
        }
    }

    private void checkPreconditions() throws BuildException {
        if (this._filesets.size() == 0) {
            throw new BuildException("You must specify at least one fileset!");
        }
        if (this.formatter == null) {
            throw new BuildException("You must specify a formatter!");
        }
        if (this.destDir == null) {
            throw new BuildException("You must specify a destDir!");
        }
        if (!this.destDir.exists()) {
            throw new BuildException("destDir doesn't exist: " + this.destDir.getAbsolutePath());
        }
        this.createDefaultMapper();
    }

    private void translateFile(FileNameMapper mapper, File srcDir, String fileName) {
        String output;
        File input = new File(srcDir, fileName);
        try {
            this.log("Reading " + input.getAbsolutePath(), 4);
            String htmlSource = Xlator.loadFile(input);
            this.log("Translating", 4);
            output = Xlator.xlateTestCase(Xlator.extractTestName(input), this.formatter.getValue(), htmlSource, this.options);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        String[] outputFileNames = mapper.mapFileName(fileName);
        for (int i = 0; i < outputFileNames.length; ++i) {
            File outputFile = new File(this.destDir, outputFileNames[i]);
            try {
                this.log("Writing " + outputFile.getAbsolutePath(), 4);
                XlatorTask.writeFile(outputFile, output);
                continue;
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    static void writeFile(File outputFile, String text) throws IOException {
        FileWriter out = new FileWriter(outputFile);
        out.write(text);
        out.close();
    }

    public static class FormatterType
    extends EnumeratedAttribute {
        private static Properties formatters = new Properties();
        private static String[] values;

        public String[] getValues() {
            return values;
        }

        public String getExtension() {
            return formatters.getProperty(this.getValue());
        }

        static {
            formatters.put("java-rc", "java");
            formatters.put("cs-rc", "cs");
            formatters.put("perl-rc", "pl");
            formatters.put("python-rc", "py");
            formatters.put("ruby-rc", "rb");
            Vector<String> keys = new Vector<String>();
            Iterator<Object> i = formatters.keySet().iterator();
            while (i.hasNext()) {
                keys.add((String)i.next());
            }
            values = keys.toArray(new String[0]);
        }
    }
}

