/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.File;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.openqa.selenium.Xlator;
import org.openqa.selenium.XlatorTask;

public class XlatorTaskTest
extends TestCase {
    private File inputDir;
    private File outputDir;

    protected void setUp() throws Exception {
        File globalTempDir = new File(System.getProperty("java.io.tmpdir"));
        this.inputDir = File.createTempFile("XlatorTaskTestInput", "", globalTempDir);
        this.inputDir.delete();
        this.inputDir.mkdir();
        this.outputDir = File.createTempFile("XlatorTaskTestOutput", "", globalTempDir);
        this.outputDir.delete();
        this.outputDir.mkdir();
    }

    protected void tearDown() throws Exception {
        this.inputDir.delete();
        this.outputDir.delete();
    }

    public void testNoFiles() throws Exception {
        this.executeTask("java-rc");
    }

    private void executeTask(String formatter) {
        XlatorTask task = new XlatorTask();
        task.setProject(new Project());
        FileSet fs = new FileSet();
        fs.setDir(this.inputDir);
        task.addFileSet(fs);
        task.setDestDir(this.outputDir);
        XlatorTask.FormatterType f = new XlatorTask.FormatterType();
        f.setValue(formatter);
        task.setFormatter(f);
        task.execute();
    }

    public void testOneFile() throws Exception {
        File click = new File(this.inputDir, "TestClick.html");
        String clickSrc = Xlator.loadResource((String)"/tests/TestClick.html");
        XlatorTask.writeFile((File)click, (String)clickSrc);
        this.executeTask("java-rc");
        File output = new File(this.outputDir, "TestClick.java");
        XlatorTaskTest.assertTrue((String)"Output is missing", (boolean)output.exists());
    }

    public void testNotEnoughInfo() {
        XlatorTask task = new XlatorTask();
        task.setProject(new Project());
        try {
            task.execute();
            XlatorTaskTest.fail((String)"Didn't catch expected exception");
        }
        catch (BuildException e) {
            // empty catch block
        }
        FileSet fs = new FileSet();
        fs.setDir(this.inputDir);
        task.addFileSet(fs);
        try {
            task.execute();
            XlatorTaskTest.fail((String)"Didn't catch expected exception");
        }
        catch (BuildException e) {
            // empty catch block
        }
        XlatorTask.FormatterType f = new XlatorTask.FormatterType();
        f.setValue("java-rc");
        task.setFormatter(f);
        try {
            task.execute();
            XlatorTaskTest.fail((String)"Didn't catch expected exception");
        }
        catch (BuildException e) {
            // empty catch block
        }
    }
}

