/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.corebased;

import com.thoughtworks.selenium.SeleneseTestCase;

public class TestDomainCookie
extends SeleneseTestCase {
    public void setUp() throws Exception {
        super.setUp("http://dfab.fabulich.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDomainCookie() throws Throwable {
        try {
            String host = this.selenium.getEval("parseUrl(canonicalize(absolutify(\"html\", selenium.browserbot.baseUrl))).host;");
            String base = "/selenium-server/tests/html";
            TestDomainCookie.assertEquals((String)"*.*.*", (String)host);
            String domain = host.replaceFirst("^[^\\.]*", "");
            this.selenium.open(base + "/path1/cookie1.html");
            this.selenium.deleteCookie(" testCookieWithSameName", "path=/");
            this.selenium.deleteCookie(" addedCookieForPath1", "path=" + base + "/path1/");
            this.selenium.deleteCookie("domainCookie", "domain=" + domain + "; path=/");
            TestDomainCookie.assertEquals((String)"", (String)this.selenium.getCookie());
            this.selenium.open(base + "/path1/cookie1.html");
            this.selenium.createCookie("domainCookie=domain value", "domain=" + domain + "; path=/");
            TestDomainCookie.assertEquals((String)"domain value", (String)this.selenium.getCookieByName("domainCookie"));
            this.selenium.deleteCookie("domainCookie", "domain=" + domain + "; path=/");
            TestDomainCookie.assertTrue((!this.selenium.isCookiePresent("domainCookie") ? 1 : 0) != 0);
            TestDomainCookie.assertEquals((String)"", (String)this.selenium.getCookie());
            this.checkForVerificationErrors();
        }
        finally {
            this.clearVerificationErrors();
        }
    }
}

