/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.corebased;

import com.thoughtworks.selenium.SeleneseTestCase;

public class TestCookie
extends SeleneseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCookie() throws Throwable {
        try {
            String base = "/selenium-server/tests/html";
            this.selenium.open(base + "/path1/cookie1.html");
            this.selenium.deleteCookie(" testCookieWithSameName", " /");
            this.selenium.deleteCookie(" addedCookieForPath1", base + "/path1/");
            TestCookie.assertEquals((String)"", (String)this.selenium.getCookie());
            this.selenium.open(base + "/path2/cookie2.html");
            this.selenium.deleteCookie(" testCookieWithSameName", " " + base + "/path2/");
            this.selenium.deleteCookie(" addedCookieForPath2", " " + base + "/path2/");
            TestCookie.assertEquals((String)"", (String)this.selenium.getCookie());
            this.selenium.open(base + "/path1/cookie1.html");
            this.selenium.createCookie("addedCookieForPath1=new value1", "");
            this.selenium.createCookie("addedCookieForPath2=new value2", "path=" + base + "/path2/, max_age=60");
            this.selenium.open(base + "/path1/cookie1.html");
            this.verifyEquals("regex:addedCookieForPath1=new value1", this.selenium.getCookie());
            this.verifyNotEquals("regex:testCookie", this.selenium.getCookie());
            this.verifyNotEquals("regex:addedCookieForPath2", this.selenium.getCookie());
            this.selenium.deleteCookie(" addedCookieForPath1", base + "/path1/");
            this.verifyEquals("", this.selenium.getCookie());
            this.selenium.open(base + "/path2/cookie2.html");
            this.verifyEquals("addedCookieForPath2=new value2", this.selenium.getCookie());
            this.verifyNotEquals("regex:addedCookieForPath1", this.selenium.getCookie());
            this.selenium.deleteCookie(" addedCookieForPath2", base + "/path2/");
            this.verifyEquals("", this.selenium.getCookie());
            this.selenium.createCookie("testCookieWithSameName=new value1", "path=/");
            this.selenium.createCookie("testCookieWithSameName=new value2", "path=" + base + "/path2/");
            this.selenium.open(base + "/path1/cookie1.html");
            this.verifyEquals("testCookieWithSameName=new value1", this.selenium.getCookie());
            this.selenium.open(base + "/path2/cookie2.html");
            this.verifyEquals("regex:testCookieWithSameName=new value1", this.selenium.getCookie());
            this.verifyEquals("regex:testCookieWithSameName=new value2", this.selenium.getCookie());
            this.selenium.deleteCookie(" testCookieWithSameName", base + "/path2/");
            this.selenium.open(base + "/path2/cookie2.html");
            this.verifyEquals("testCookieWithSameName=new value1", this.selenium.getCookie());
            this.verifyNotEquals("regex:testCookieWithSameName=new value2", this.selenium.getCookie());
            this.checkForVerificationErrors();
        }
        finally {
            this.clearVerificationErrors();
        }
    }
}

