/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumServer;

public class WindowNamesTest
extends TestCase {
    private Selenium selenium;

    public void setUp() throws Exception {
        String url = "http://www.google.com";
        this.selenium = new DefaultSelenium("localhost", SeleniumServer.getDefaultPort(), "*firefox", url);
        this.selenium.start();
    }

    protected void tearDown() throws Exception {
        this.selenium.stop();
    }

    public void testWindowNames() throws Throwable {
        this.selenium.open("http://www.google.com/webhp?hl=en");
        WindowNamesTest.assertEquals((String)"Google", (String)this.selenium.getTitle());
        String[] windowNames = this.selenium.getAllWindowNames();
        for (int i = 0; i < windowNames.length; ++i) {
            String windowName = windowNames[i];
            System.out.println("Window Name: " + windowName);
        }
        this.selenium.selectWindow(null);
        String[] windowIds = this.selenium.getAllWindowNames();
        for (int i = 0; i < windowIds.length; ++i) {
            String windowId = windowIds[i];
            System.out.println("Window Id: " + windowId);
        }
        String[] windowTitles = this.selenium.getAllWindowTitles();
        for (int i = 0; i < windowTitles.length; ++i) {
            String windowTitle = windowTitles[i];
            System.out.println("Window Title: " + windowTitle);
        }
        this.selenium.selectWindow("");
        this.selenium.selectWindow("Google");
        this.selenium.type("q", "Selenium OpenQA");
        WindowNamesTest.assertEquals((String)"Selenium OpenQA", (String)this.selenium.getValue("q"));
        this.selenium.click("btnG");
        this.selenium.waitForPageToLoad("5000");
        WindowNamesTest.assertEquals((String)"Selenium OpenQA - Google Search", (String)this.selenium.getTitle());
    }
}

