/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.Wait;
import junit.framework.TestCase;

public class WaitTest
extends TestCase {
    private long finished;
    private long now;
    private int tries = 0;

    public void setUp() {
        this.now = System.currentTimeMillis();
    }

    public void testUntil() {
        this.finished = this.now + 500L;
        new Wait(){

            public boolean until() {
                WaitTest.this.tries++;
                return System.currentTimeMillis() > WaitTest.this.finished;
            }
        }.wait("clock stopped");
        WaitTest.assertTrue((String)("didn't try enough times: " + this.tries), (this.tries > 1 ? 1 : 0) != 0);
    }

    public void testTimedOut() {
        this.finished = this.now + 5000L;
        try {
            new Wait(){

                public boolean until() {
                    WaitTest.this.tries++;
                    return System.currentTimeMillis() > WaitTest.this.finished;
                }
            }.wait("timed out as expected", 500L, 50L);
            WaitTest.fail((String)"expected timeout");
        }
        catch (Wait.WaitTimedOutException e) {
            long waited = System.currentTimeMillis() - this.now;
            WaitTest.assertTrue((String)("didn't wait long enough:" + waited), (waited >= 500L ? 1 : 0) != 0);
            WaitTest.assertTrue((String)("didn't try enough times: " + this.tries), (this.tries > 7 ? 1 : 0) != 0);
        }
    }
}

