/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleneseTestCase;
import java.net.URL;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class SSLOpenTest
extends SeleneseTestCase {
    protected String url = "https://127.0.0.2:4444/selenium-server/tests/html/test_open.html";
    protected String title = "Open Test";

    public SSLOpenTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        if (this.skipOpera()) {
            return;
        }
        String name = this.getName();
        String browser = "*" + name.toLowerCase().substring(4);
        int port = SeleniumServer.getDefaultPort();
        URL parsedUrl = new URL(this.url);
        String startUrl = parsedUrl.getProtocol() + "://" + parsedUrl.getAuthority();
        this.selenium = new DefaultSelenium("localhost", port, browser, startUrl);
        this.selenium.start();
    }

    public void tearDown() throws Exception {
        if (this.skipOpera()) {
            return;
        }
        super.tearDown();
    }

    public boolean skipOpera() {
        if ("testOpera".equals(this.getName()) && "1.6".equals(System.getProperty("java.specification.version"))) {
            System.err.println("SKIPPING " + SSLOpenTest.class.getName() + "." + this.getName() + ": SRC-262  In Java 6 (only) Opera gives you an 'accept' pop-up when browsing to SSL sites");
            return true;
        }
        return false;
    }

    public void doTest() {
        this.selenium.open(this.url);
        SSLOpenTest.assertEquals((String)this.title, (String)this.selenium.getTitle());
    }

    public void testFirefox() {
        this.doTest();
    }

    public void testIexplore() {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        this.doTest();
    }

    public void testOpera() {
        if (this.skipOpera()) {
            return;
        }
        this.doTest();
    }
}

