/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumServer;

public class RealDealIntegrationTest
extends TestCase {
    Selenium selenium;

    protected void setUp() throws Exception {
        super.setUp();
        this.selenium = new DefaultSelenium("localhost", SeleniumServer.getDefaultPort(), "*firefox", "http://localhost:" + SeleniumServer.getDefaultPort());
        this.selenium.start();
    }

    protected void tearDown() throws Exception {
        this.selenium.stop();
    }

    public void testWithJavaScript() {
        this.selenium.setContext("A real test, using the real Selenium on the browser side served by Jetty, driven from Java");
        this.selenium.setBrowserLogLevel("debug");
        this.selenium.open("/selenium-server/tests/html/test_click_page1.html");
        RealDealIntegrationTest.assertTrue((String)"link 'link' doesn't contain expected text", (this.selenium.getText("link").indexOf("Click here for next page") != -1 ? 1 : 0) != 0);
        String[] links = this.selenium.getAllLinks();
        RealDealIntegrationTest.assertTrue((links.length > 3 ? 1 : 0) != 0);
        RealDealIntegrationTest.assertEquals((String)"linkToAnchorOnThisPage", (String)links[3]);
        this.selenium.click("link");
        this.selenium.waitForPageToLoad("10000");
        RealDealIntegrationTest.assertTrue((boolean)this.selenium.getLocation().endsWith("/selenium-server/tests/html/test_click_page2.html"));
        this.selenium.click("previousPage");
        this.selenium.waitForPageToLoad("10000");
        RealDealIntegrationTest.assertTrue((boolean)this.selenium.getLocation().endsWith("/selenium-server/tests/html/test_click_page1.html"));
    }

    public void testAgain() {
        this.testWithJavaScript();
    }

    public void testFailure() {
        this.selenium.setContext("A real negative test, using the real Selenium on the browser side served by Jetty, driven from Java");
        this.selenium.setBrowserLogLevel("debug");
        this.selenium.open("/selenium-server/tests/html/test_click_page1.html");
        String badElementName = "This element doesn't exist, so Selenium should throw an exception";
        try {
            this.selenium.getText(badElementName);
            RealDealIntegrationTest.fail((String)"No exception was thrown!");
        }
        catch (SeleniumException se) {
            RealDealIntegrationTest.assertTrue((String)("Exception message isn't as expected: " + se.getMessage()), (se.getMessage().indexOf(badElementName + " not found") != -1 ? 1 : 0) != 0);
        }
        try {
            RealDealIntegrationTest.assertTrue((String)"Negative test", (boolean)this.selenium.isTextPresent("Negative test: verify non-existent text"));
            RealDealIntegrationTest.fail((String)"No exception was thrown!");
        }
        catch (AssertionFailedError se) {
            RealDealIntegrationTest.assertTrue((String)("Exception message isn't as expected: " + se.getMessage()), (se.getMessage().indexOf("Negative test") != -1 ? 1 : 0) != 0);
        }
    }

    public void testMinimal() {
        this.selenium.setContext("minimal 'test' -- to see how little I need to do to repro firefox hang");
        this.selenium.setBrowserLogLevel("debug");
    }
}

