/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import junit.framework.TestCase;

public class MockBrowserTest
extends TestCase {
    Selenium sel;

    public void setUp() {
        this.sel = new DefaultSelenium("localhost", 4444, "*mock", "http://x");
        this.sel.start();
    }

    public void tearDown() {
        this.sel.stop();
    }

    public void testMock() {
        this.sel.open("/");
        this.sel.click("foo");
        MockBrowserTest.assertEquals((String)"Incorrect title", (String)"x", (String)this.sel.getTitle());
        MockBrowserTest.assertTrue((String)"alert wasn't present", (boolean)this.sel.isAlertPresent());
        this.assertArrayEquals("getAllButtons should return one empty string", new String[]{""}, this.sel.getAllButtons());
        this.assertArrayEquals("getAllLinks was incorrect", new String[]{"1"}, this.sel.getAllLinks());
        this.assertArrayEquals("getAllFields was incorrect", new String[]{"1", "2", "3"}, this.sel.getAllFields());
    }

    private void assertArrayEquals(String message, String[] expected, String[] actual) {
        if (expected == null && actual == null) {
            return;
        }
        MockBrowserTest.assertEquals((String)message, (String)this.arrayToString(expected), (String)this.arrayToString(actual));
    }

    private String arrayToString(String[] array) {
        if (array == null) {
            return "null";
        }
        int lastIndex = array.length - 1;
        StringBuffer sb = new StringBuffer(91);
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i == lastIndex) continue;
            sb.append(';');
        }
        sb.append("] length=");
        sb.append(array.length);
        return sb.toString();
    }
}

