/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.ClientDriverSuite;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class ClientDriverPISuite
extends ClientDriverSuite {
    public static Test suite() {
        TestSuite supersuite = new TestSuite(ClientDriverPISuite.class.getName());
        TestSuite suite = ClientDriverSuite.generateSuite(true, ClientDriverPISuite.determineForcedBrowserMode());
        suite.setName(ClientDriverPISuite.class.getName());
        InitSystemPropertiesTestSetupForPImode setup = new InitSystemPropertiesTestSetupForPImode((Test)suite);
        supersuite.addTest((Test)setup);
        return supersuite;
    }

    protected static String determineForcedBrowserMode() {
        String forcedBrowserMode = System.getProperty("selenium.forcedBrowserMode");
        if (forcedBrowserMode == null) {
            forcedBrowserMode = WindowsUtils.thisIsWindows() ? "*piiexplore" : "*pifirefox";
        }
        return forcedBrowserMode;
    }

    public static class InitSystemPropertiesTestSetupForPImode
    extends ClientDriverSuite.InitSystemPropertiesTestSetup {
        public InitSystemPropertiesTestSetupForPImode(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            super.setUp();
            this.overrideProperty("selenium.forcedBrowserMode", ClientDriverPISuite.determineForcedBrowserMode());
            this.overrideProperty("selenium.proxyInjectionMode", "true");
        }
    }
}

