/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Wait;
import junit.framework.TestCase;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class ApacheMyFacesSuggestTest
extends TestCase {
    DefaultSelenium selenium;
    boolean isProxyInjectionMode;
    private static final String updateId = "ac4update";
    private static final String inputId = "ac4";

    protected void setUp() throws Exception {
        this.isProxyInjectionMode = System.getProperty("selenium.proxyInjectionMode") != null && System.getProperty("selenium.proxyInjectionMode").equals("true");
    }

    private boolean shouldSkip() {
        String browserName;
        String browserOverride = System.getProperty("selenium.forcedBrowserMode");
        if (browserOverride == null) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            throw new NullPointerException("Test name is null!");
        }
        if (name.endsWith("Firefox")) {
            browserName = "firefox";
        } else if (name.endsWith("IExplore")) {
            browserName = "iexplore";
        } else {
            throw new RuntimeException("Test name unexpected: " + this.getName());
        }
        browserName = this.isProxyInjectionMode ? "*pi" + browserName : "*" + browserName;
        if (!browserName.equals(browserOverride)) {
            System.err.println("WARNING!!! Skipping " + this.getName());
            return true;
        }
        return false;
    }

    public void testAJAXFirefox() throws Throwable {
        if (this.shouldSkip()) {
            return;
        }
        this.selenium = new DefaultSelenium("localhost", SeleniumServer.getDefaultPort(), "*firefox", "http://www.irian.at");
        this.selenium.start();
        this.selenium.open("http://www.irian.at/selenium-server/tests/html/ajax/ajax_autocompleter2_test.html");
        this.selenium.keyPress(inputId, "\\74");
        Thread.sleep(500L);
        this.selenium.keyPress(inputId, "\\97");
        this.selenium.keyPress(inputId, "\\110");
        new Wait(){

            public boolean until() {
                String text = ApacheMyFacesSuggestTest.this.selenium.getText(ApacheMyFacesSuggestTest.updateId);
                return "Jane Agnews".equals(text);
            }
        }.wait("Didn't find 'Jane Agnews' in updateId");
        this.selenium.keyPress(inputId, "\\9");
        new Wait(){

            public boolean until() {
                return "Jane Agnews".equals(ApacheMyFacesSuggestTest.this.selenium.getValue(ApacheMyFacesSuggestTest.inputId));
            }
        }.wait("Didn't find 'Jane Agnews' in inputId");
    }

    public void testAJAXIExplore() throws Throwable {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        if (this.shouldSkip()) {
            return;
        }
        this.selenium = new DefaultSelenium("localhost", SeleniumServer.getDefaultPort(), "*iexplore", "http://www.irian.at");
        this.selenium.start();
        this.selenium.open("http://www.irian.at/selenium-server/tests/html/ajax/ajax_autocompleter2_test.html");
        this.selenium.type(inputId, "J");
        this.selenium.keyDown(inputId, "\\74");
        Thread.sleep(500L);
        this.selenium.type(inputId, "Jan");
        this.selenium.keyDown(inputId, "\\110");
        new Wait(){

            public boolean until() {
                return "Jane Agnews".equals(ApacheMyFacesSuggestTest.this.selenium.getText(ApacheMyFacesSuggestTest.updateId));
            }
        }.wait("Didn't find 'Jane Agnews' in updateId");
        this.selenium.keyDown(inputId, "\\13");
        new Wait(){

            public boolean until() {
                return "Jane Agnews".equals(ApacheMyFacesSuggestTest.this.selenium.getValue(ApacheMyFacesSuggestTest.inputId));
            }
        }.wait("Didn't find 'Jane Agnews' in inputId");
    }

    public void tearDown() {
        if (this.selenium == null) {
            return;
        }
        this.selenium.stop();
    }
}

