package com.thoughtworks.selenium;

import java.net.URL;

import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;

public class SSLOpenTest extends SeleneseTestCase {
    // DGF We use 127.0.0.2 because IE will attempt to contact 127.0.0.1 directly if that's its proxy port
    // 127.0.0.2 works just as well as any other loopback address
    protected String url = "https://127.0.0.2:4444/selenium-server/tests/html/test_open.html";
    protected String title = "Open Test";
    
    public SSLOpenTest(String name) {
        super(name);
    }

    public void setUp() throws Exception{
        if (skipOpera()) return;
        // calculate browser based on test method name
        String name = getName();
        String browser = "*" + name.toLowerCase().substring(4);
        
        int port = SeleniumServer.getDefaultPort();
        
        // shorten url so we don't get a warning on the server side
        URL parsedUrl = new URL(url);
        String startUrl = parsedUrl.getProtocol() + "://" + parsedUrl.getAuthority();
        
        selenium = new DefaultSelenium("localhost", port, browser, startUrl);
        selenium.start();
    }
    
    public void tearDown() throws Exception {
        if (skipOpera()) return;
        super.tearDown();
    }
    
    public boolean skipOpera() {
        if ("testOpera".equals(getName())) {
            if ("1.6".equals(System.getProperty("java.specification.version"))) {
                System.err.println("SKIPPING " + SSLOpenTest.class.getName() + "." + getName() + ": SRC-262  In Java 6 (only) Opera gives you an 'accept' pop-up when browsing to SSL sites");
                return true;
            }
        }
        return false;
    }
    
    public void doTest() {
        selenium.open(url);
        assertEquals(title, selenium.getTitle());
    }
    
    public void testFirefox() {
        doTest();
    }
    
    public void testIexplore() {
        if (!WindowsUtils.thisIsWindows()) return;
        doTest();
    }
    
    public void testOpera() {
        if (skipOpera()) return;
        doTest();
    }
}
