/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.util.sa.impl.compressedrefs;

import java.lang.reflect.Method;
import org.openjdk.jol.util.sa.HS_SA_Processor;
import org.openjdk.jol.util.sa.impl.HS_SA_Util;
import org.openjdk.jol.util.sa.impl.compressedrefs.HS_SA_CompressedReferencesResult;

public class HS_SA_CompressedReferencesProcessor
implements HS_SA_Processor {
    @Override
    public HS_SA_CompressedReferencesResult process() {
        try {
            Class<?> universeClass = HS_SA_Util.getUniverseClass();
            Class<?> vmClass = HS_SA_Util.getVmClass();
            Object vm = HS_SA_Util.getVMInstance();
            Method getOopSizeMethod = vmClass.getMethod("getOopSize", new Class[0]);
            Method getObjectAlignmentInBytesMethod = vmClass.getMethod("getObjectAlignmentInBytes", new Class[0]);
            Method getHeapOopSizeMethod = vmClass.getMethod("getHeapOopSize", new Class[0]);
            Method isCompressedOopsEnabledMethod = vmClass.getMethod("isCompressedOopsEnabled", new Class[0]);
            Method getNarrowOopBaseMethod = universeClass.getMethod("getNarrowOopBase", new Class[0]);
            Method getNarrowOopShiftMethod = universeClass.getMethod("getNarrowOopShift", new Class[0]);
            Method getKlassOopSizeMethod = null;
            Method isCompressedKlassOopsEnabledMethod = null;
            Method getNarrowKlassBaseMethod = null;
            Method getNarrowKlassShiftMethod = null;
            try {
                getKlassOopSizeMethod = vmClass.getMethod("getKlassPtrSize", new Class[0]);
                isCompressedKlassOopsEnabledMethod = vmClass.getMethod("isCompressedKlassPointersEnabled", new Class[0]);
                getNarrowKlassBaseMethod = universeClass.getMethod("getNarrowKlassBase", new Class[0]);
                getNarrowKlassShiftMethod = universeClass.getMethod("getNarrowKlassShift", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            int addressSize = ((Long)getOopSizeMethod.invoke(vm, new Object[0])).intValue();
            int objectAlignment = (Integer)getObjectAlignmentInBytesMethod.invoke(vm, new Object[0]);
            int oopSize = (Integer)getHeapOopSizeMethod.invoke(vm, new Object[0]);
            boolean compressedOopsEnabled = (Boolean)isCompressedOopsEnabledMethod.invoke(vm, new Object[0]);
            long narrowOopBase = (Long)getNarrowOopBaseMethod.invoke(null, new Object[0]);
            int narrowOopShift = (Integer)getNarrowOopShiftMethod.invoke(null, new Object[0]);
            int klassOopSize = getKlassOopSizeMethod != null ? (Integer)getKlassOopSizeMethod.invoke(vm, new Object[0]) : oopSize;
            boolean compressedKlassOopsEnabled = isCompressedKlassOopsEnabledMethod != null ? (Boolean)isCompressedKlassOopsEnabledMethod.invoke(vm, new Object[0]) : compressedOopsEnabled;
            long narrowKlassBase = getNarrowKlassBaseMethod != null ? (Long)getNarrowKlassBaseMethod.invoke(null, new Object[0]) : narrowOopBase;
            int narrowKlassShift = getNarrowKlassShiftMethod != null ? (Integer)getNarrowKlassShiftMethod.invoke(null, new Object[0]) : narrowOopShift;
            return new HS_SA_CompressedReferencesResult(addressSize, objectAlignment, oopSize, compressedOopsEnabled, narrowOopBase, narrowOopShift, klassOopSize, compressedKlassOopsEnabled, narrowKlassBase, narrowKlassShift);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

