/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class InstrumentationSupport {
    private static Instrumentation INSTRUMENTATION;
    private static boolean TRY_DYNAMIC_ATTACH;

    public static void premain(String agentArgs, Instrumentation inst) {
        INSTRUMENTATION = inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Instrumentation instance() {
        if (INSTRUMENTATION != null || !TRY_DYNAMIC_ATTACH) return INSTRUMENTATION;
        Class<InstrumentationSupport> clazz = InstrumentationSupport.class;
        synchronized (InstrumentationSupport.class) {
            if (!TRY_DYNAMIC_ATTACH) return INSTRUMENTATION;
            TRY_DYNAMIC_ATTACH = false;
            try {
                InstrumentationSupport.tryDynamicAttach();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return INSTRUMENTATION;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryDynamicAttach() throws Exception {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(System.getProperty("java.home").replace('\\', '/') + "/../lib/tools.jar").toURI().toURL()}, null);
        Class<?> vmClass = classLoader.loadClass("com.sun.tools.attach.VirtualMachine");
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        Object vm = vmClass.getDeclaredMethod("attach", String.class).invoke(null, runtimeName.substring(0, runtimeName.indexOf(64)));
        try {
            File agentFile = File.createTempFile("jolAgent", ".jar");
            try {
                InstrumentationSupport.saveAgentJar(agentFile);
                vmClass.getDeclaredMethod("loadAgent", String.class, String.class).invoke(vm, agentFile.getAbsolutePath(), "");
                Field field = ClassLoader.getSystemClassLoader().loadClass(Installer.class.getName()).getDeclaredField("INSTRUMENTATION");
                INSTRUMENTATION = (Instrumentation)field.get(null);
            }
            finally {
                agentFile.delete();
            }
        }
        finally {
            vmClass.getDeclaredMethod("detach", new Class[0]).invoke(vm, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAgentJar(File agentFile) throws Exception {
        InputStream is = Installer.class.getResourceAsStream('/' + Installer.class.getName().replace('.', '/') + ".class");
        if (is == null) {
            return;
        }
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
            manifest.getMainAttributes().put(new Attributes.Name("Agent-Class"), Installer.class.getName());
            JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(agentFile), manifest);
            try {
                int index;
                jos.putNextEntry(new JarEntry('/' + Installer.class.getName().replace('.', '/') + ".class"));
                byte[] buffer = new byte[1024];
                while ((index = is.read(buffer)) != -1) {
                    jos.write(buffer, 0, index);
                }
                jos.closeEntry();
            }
            finally {
                jos.close();
            }
        }
        finally {
            is.close();
        }
    }

    static {
        TRY_DYNAMIC_ATTACH = !Boolean.getBoolean("jol.skipDynamicAttach");
    }

    private static class Installer {
        public static volatile Instrumentation INSTRUMENTATION;

        private Installer() {
        }

        public static void agentmain(String agentArgs, Instrumentation inst) {
            INSTRUMENTATION = inst;
        }
    }
}

