/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.openjdk.jol.util.sa.HS_SA_Processor;
import org.openjdk.jol.util.sa.HS_SA_Result;
import org.openjdk.jol.util.sa.impl.HS_SA_Util;
import org.openjdk.jol.util.sa.impl.compressedrefs.HS_SA_CompressedReferencesProcessor;
import org.openjdk.jol.util.sa.impl.compressedrefs.HS_SA_CompressedReferencesResult;
import sun.management.VMManagement;

public class HS_SA_Support {
    private static final String SKIP_HOTSPOT_SA_INIT_FLAG = "jol.skipHotspotSAInit";
    private static final String SKIP_HOTSPOT_SA_ATTACH_FLAG = "jol.skipHotspotSAAttach";
    private static final String TRY_WITH_SUDO_FLAG = "jol.tryWithSudo";
    private static final int DEFAULT_TIMEOUT_IN_MSECS = 5000;
    private static final int VM_CHECK_PERIOD_SENSITIVITY_IN_MSECS = 1000;
    private static final int PROCESS_ATTACH_FAILED_EXIT_CODE = 128;
    private static final boolean enable;
    private static final int processId;
    private static final String classpathForAgent;
    private static final boolean sudoRequired;
    private static final String errorMessage;

    private HS_SA_Support() {
    }

    private static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    private static void checkEnable() {
        if (!enable) {
            throw new IllegalStateException(errorMessage);
        }
    }

    private static boolean isSudoValidOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return true;
        }
        return osName.contains("mac");
    }

    private static void safelyClose(OutputStream out) {
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safelyClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safelyClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static HS_SA_Result executeOnHotspotSAInternal(HS_SA_Processor processor, int timeoutInMsecs) {
        HS_SA_Support.checkEnable();
        return HS_SA_Support.executeOnHotspotSAInternal(processId, classpathForAgent, sudoRequired, processor, timeoutInMsecs);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HS_SA_Result executeOnHotspotSAInternal(int procId, String classpath, boolean sudoRequired, HS_SA_Processor processor, int timeoutInMsecs) {
        HS_SA_Result hS_SA_Result;
        Process agentProcess;
        BufferedReader err;
        ObjectOutputStream out;
        ObjectInputStream in;
        block15: {
            ArrayList<String> args = new ArrayList<String>();
            if (sudoRequired) {
                args.add("sudo");
            }
            args.add(HS_SA_Support.normalizePath(System.getProperty("java.home")) + "/" + "bin" + "/" + "java");
            args.add("-Djol.skipHotspotSAInit=true");
            args.add("-cp");
            args.add(classpath);
            args.add(HS_SA_Support.class.getName());
            in = null;
            out = null;
            err = null;
            agentProcess = null;
            agentProcess = new ProcessBuilder(args).start();
            HS_SA_Request request = new HS_SA_Request(procId, processor, timeoutInMsecs);
            InputStream is = agentProcess.getInputStream();
            OutputStream os = agentProcess.getOutputStream();
            InputStream es = agentProcess.getErrorStream();
            out = new ObjectOutputStream(os);
            out.writeObject(request);
            out.flush();
            int exitCode = agentProcess.waitFor();
            agentProcess = null;
            if (exitCode == 128) {
                throw new ProcessAttachFailedException("Attaching as HotSpot SA to current process (id=" + procId + ") from external process failed");
            }
            err = new BufferedReader(new InputStreamReader(es));
            StringBuilder errBuilder = null;
            String line = err.readLine();
            while (line != null) {
                if (errBuilder == null) {
                    errBuilder = new StringBuilder();
                }
                errBuilder.append(line).append("\n");
                line = err.readLine();
            }
            if (errBuilder != null) {
                throw new RuntimeException(errBuilder.toString());
            }
            in = new ObjectInputStream(is);
            HS_SA_Response response = (HS_SA_Response)in.readObject();
            if (response == null) break block15;
            if (response.getError() != null) {
                Throwable error = response.getError();
                throw new RuntimeException(error.getMessage(), error);
            }
            HS_SA_Result hS_SA_Result2 = response.getResult();
            HS_SA_Support.safelyClose(out);
            HS_SA_Support.safelyClose(in);
            HS_SA_Support.safelyClose(err);
            if (agentProcess != null) {
                agentProcess.destroy();
            }
            return hS_SA_Result2;
        }
        try {
            hS_SA_Result = null;
        }
        catch (ProcessAttachFailedException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new RuntimeException(t.getMessage(), t);
                }
            }
            catch (Throwable throwable) {
                HS_SA_Support.safelyClose(out);
                HS_SA_Support.safelyClose(in);
                HS_SA_Support.safelyClose(err);
                if (agentProcess != null) {
                    agentProcess.destroy();
                }
                throw throwable;
            }
        }
        HS_SA_Support.safelyClose(out);
        HS_SA_Support.safelyClose(in);
        HS_SA_Support.safelyClose(err);
        if (agentProcess != null) {
            agentProcess.destroy();
        }
        return hS_SA_Result;
    }

    private static HS_SA_Processor createInstance(Class<? extends HS_SA_Processor> processorClass) {
        try {
            return processorClass.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Could not create instance of " + processorClass.getName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block35: {
            Method detachMethod;
            Object hotspotAgent;
            ObjectOutputStream out;
            ByteArrayOutputStream bos;
            HS_SA_Response response;
            block32: {
                response = null;
                bos = new ByteArrayOutputStream();
                ObjectInputStream in = null;
                out = null;
                hotspotAgent = null;
                detachMethod = null;
                in = new ObjectInputStream(System.in);
                out = new ObjectOutputStream(bos);
                System.setProperty("sun.jvm.hotspot.debugger.useProcDebugger", "true");
                System.setProperty("sun.jvm.hotspot.debugger.useWindbgDebugger", "true");
                final HS_SA_Request request = (HS_SA_Request)in.readObject();
                Class<?> hotspotAgentClass = HS_SA_Util.getHotspotAgentClass();
                hotspotAgent = HS_SA_Util.createHotspotAgentInstance();
                final Method attachMethod = hotspotAgentClass.getMethod("attach", Integer.TYPE);
                detachMethod = hotspotAgentClass.getMethod("detach", new Class[0]);
                Object vm = null;
                final Object agent = hotspotAgent;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        try {
                            attachMethod.invoke(agent, request.getProcessId());
                        }
                        catch (Throwable t) {
                            System.exit(128);
                        }
                    }
                };
                t.start();
                for (int i = 0; i < request.getTimeout(); i += 1000) {
                    Thread.sleep(1000L);
                    try {
                        vm = HS_SA_Util.getVMInstance();
                        if (vm == null) continue;
                        break;
                    }
                    catch (Throwable err) {
                        // empty catch block
                    }
                }
                if (vm != null) {
                    HS_SA_Processor processor = request.getProcessor();
                    if (processor != null) {
                        HS_SA_Result result = processor.process();
                        response = new HS_SA_Response(result);
                    }
                } else {
                    throw new IllegalStateException("VM couldn't be initialized !");
                }
                if (out == null) break block32;
                try {
                    out.writeObject(response);
                    out.flush();
                    System.out.write(bos.toByteArray());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (hotspotAgent != null && detachMethod != null) {
                try {
                    detachMethod.invoke(hotspotAgent, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {}
            }
            break block35;
            catch (Throwable t) {
                block33: {
                    try {
                        response = new HS_SA_Response(t);
                        if (out == null) break block33;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            try {
                                out.writeObject(response);
                                out.flush();
                                System.out.write(bos.toByteArray());
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if (hotspotAgent != null && detachMethod != null) {
                            try {
                                detachMethod.invoke(hotspotAgent, new Object[0]);
                            }
                            catch (IllegalArgumentException e) {
                            }
                            catch (IllegalAccessException e) {
                            }
                            catch (InvocationTargetException e) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        out.writeObject(response);
                        out.flush();
                        System.out.write(bos.toByteArray());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (hotspotAgent != null && detachMethod != null) {
                    try {
                        detachMethod.invoke(hotspotAgent, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InvocationTargetException e) {}
                }
            }
        }
    }

    public static boolean isEnable() {
        return enable;
    }

    public static HS_SA_Result executeOnHotspotSA(Class<? extends HS_SA_Processor> processorClass) {
        return HS_SA_Support.executeOnHotspotSA(HS_SA_Support.createInstance(processorClass), 5000);
    }

    public static HS_SA_Result executeOnHotspotSA(HS_SA_Processor processor) {
        return HS_SA_Support.executeOnHotspotSAInternal(processor, 5000);
    }

    public static HS_SA_Result executeOnHotspotSA(Class<? extends HS_SA_Processor> processorClass, int timeoutInMsecs) {
        return HS_SA_Support.executeOnHotspotSA(HS_SA_Support.createInstance(processorClass), timeoutInMsecs);
    }

    public static HS_SA_Result executeOnHotspotSA(HS_SA_Processor processor, int timeoutInMsecs) {
        return HS_SA_Support.executeOnHotspotSAInternal(processor, timeoutInMsecs);
    }

    public static HS_SA_CompressedReferencesResult getCompressedReferences() {
        return (HS_SA_CompressedReferencesResult)HS_SA_Support.executeOnHotspotSA(HS_SA_CompressedReferencesProcessor.class);
    }

    public static String details() {
        HS_SA_Support.checkEnable();
        return "HotspotServiceabilityAgentSupport [enable=" + enable + ", " + "processId=" + processId + ", " + "classpathForAgent=" + classpathForAgent + ", " + "errorMessage=" + errorMessage + "]";
    }

    static {
        boolean active = true;
        int currentProcId = -1;
        String classpathForAgentProc = null;
        String errorMsg = null;
        boolean sudoNeeded = false;
        if (!Boolean.getBoolean(SKIP_HOTSPOT_SA_INIT_FLAG)) {
            if (Boolean.getBoolean(SKIP_HOTSPOT_SA_ATTACH_FLAG)) {
                active = false;
                errorMsg = "HotSpot Serviceability Agent attach skipped due to jol.skipHotspotSAAttach flag.";
            } else {
                String jvmName = System.getProperty("java.vm.name").toLowerCase();
                if (!jvmName.contains("hotspot") && !jvmName.contains("openjdk")) {
                    active = false;
                    errorMsg = "HotSpot Serviceability Agent is only supported on HotSpot JVM.";
                } else {
                    try {
                        RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
                        Field jvmField = mxbean.getClass().getDeclaredField("jvm");
                        jvmField.setAccessible(true);
                        VMManagement management = (VMManagement)jvmField.get(mxbean);
                        Method method = management.getClass().getDeclaredMethod("getProcessId", new Class[0]);
                        method.setAccessible(true);
                        currentProcId = (Integer)method.invoke((Object)management, new Object[0]);
                    }
                    catch (Throwable t) {
                        active = false;
                        errorMsg = "Couldn't find PID of current JVM process.";
                    }
                }
                String currentClasspath = HS_SA_Support.normalizePath(ManagementFactory.getRuntimeMXBean().getClassPath());
                try {
                    Class.forName("sun.jvm.hotspot.HotSpotAgent");
                    classpathForAgentProc = currentClasspath;
                }
                catch (ClassNotFoundException e1) {
                    try {
                        File hotspotAgentLib = new File(HS_SA_Support.normalizePath(System.getProperty("java.home")) + "/../lib/sa-jdi.jar");
                        if (hotspotAgentLib.exists()) {
                            classpathForAgentProc = currentClasspath + File.pathSeparator + HS_SA_Support.normalizePath(hotspotAgentLib.getAbsolutePath());
                        } else {
                            active = false;
                            errorMsg = "Couldn't find HotSpot Serviceability Agent library (sa-jdi.jar).";
                        }
                    }
                    catch (Throwable t2) {
                        active = false;
                        errorMsg = "Couldn't find HotSpot Serviceability Agent library (sa-jdi.jar).";
                    }
                }
            }
            if (active) {
                try {
                    HS_SA_Support.executeOnHotspotSAInternal(currentProcId, classpathForAgentProc, false, null, 5000);
                }
                catch (ProcessAttachFailedException e1) {
                    if (HS_SA_Support.isSudoValidOS() && Boolean.getBoolean(TRY_WITH_SUDO_FLAG)) {
                        try {
                            HS_SA_Support.executeOnHotspotSAInternal(currentProcId, classpathForAgentProc, true, null, 5000);
                            sudoNeeded = true;
                        }
                        catch (Throwable t2) {
                            active = false;
                            errorMsg = "Unable to attach Serviceability Agent even with super-user privileges: " + t2.getMessage();
                        }
                    } else {
                        active = false;
                        errorMsg = "Unable to attach Serviceability Agent. You can try again with super-user privileges. Use -Djol.tryWithSudo=true to try with sudo.";
                    }
                }
                catch (Throwable t1) {
                    active = false;
                    errorMsg = "Unable to attach Serviceability Agent: " + t1.getMessage();
                }
            }
        }
        enable = active;
        processId = currentProcId;
        classpathForAgent = classpathForAgentProc;
        errorMessage = "WARNING: " + errorMsg;
        sudoRequired = sudoNeeded;
    }

    private static class HS_SA_Response
    implements Serializable {
        private final HS_SA_Result result;
        private final Throwable error;

        private HS_SA_Response(HS_SA_Result result) {
            this.result = result;
            this.error = null;
        }

        private HS_SA_Response(Throwable error) {
            this.result = null;
            this.error = error;
        }

        public HS_SA_Result getResult() {
            return this.result;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    private static class HS_SA_Request
    implements Serializable {
        private final int processId;
        private final HS_SA_Processor processor;
        private final int timeout;

        private HS_SA_Request(int processId, HS_SA_Processor processor) {
            this.processId = processId;
            this.processor = processor;
            this.timeout = 5000;
        }

        private HS_SA_Request(int processId, HS_SA_Processor processor, int timeout) {
            this.processId = processId;
            this.processor = processor;
            this.timeout = timeout;
        }

        public int getProcessId() {
            return this.processId;
        }

        public HS_SA_Processor getProcessor() {
            return this.processor;
        }

        public int getTimeout() {
            return this.timeout;
        }
    }

    private static class ProcessAttachFailedException
    extends RuntimeException {
        private ProcessAttachFailedException(String message) {
            super(message);
        }
    }
}

