package org.openjdk.jcstress.samples;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.WorkerSync;
import org.openjdk.jcstress.util.Counter;
import org.openjdk.jcstress.vm.WhiteBoxSupport;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Callable;
import java.util.Collections;
import java.util.List;
import org.openjdk.jcstress.os.AffinitySupport;
import org.openjdk.jcstress.samples.JMMSample_04_PartialOrder.LockGuard;
import org.openjdk.jcstress.infra.results.II_Result;

public final class JMMSample_04_PartialOrder_LockGuard_jcstress extends Runner<II_Result> {

    volatile WorkerSync workerSync;
    LockGuard[] gs;
    II_Result[] gr;

    public JMMSample_04_PartialOrder_LockGuard_jcstress(TestConfig config, TestResultCollector collector, ExecutorService pool) {
        super(config, collector, pool, "org.openjdk.jcstress.samples.JMMSample_04_PartialOrder.LockGuard");
    }

    @Override
    public Counter<II_Result> sanityCheck() throws Throwable {
        Counter<II_Result> counter = new Counter<>();
        sanityCheck_API(counter);
        sanityCheck_Footprints(counter);
        return counter;
    }

    private void sanityCheck_API(Counter<II_Result> counter) throws Throwable {
        final LockGuard s = new LockGuard();
        final II_Result r = new II_Result();
        Collection<Future<?>> res = new ArrayList<>();
        res.add(pool.submit(() -> s.actor1()));
        res.add(pool.submit(() -> s.actor2(r)));
        for (Future<?> f : res) {
            try {
                f.get();
            } catch (ExecutionException e) {
                throw e.getCause();
            }
        }
        counter.record(r);
    }

    private void sanityCheck_Footprints(Counter<II_Result> counter) throws Throwable {
        config.adjustStrides(size -> {
            LockGuard[] ls = new LockGuard[size];
            II_Result[] lr = new II_Result[size];
            workerSync = new WorkerSync(false, 2, config.spinLoopStyle);
            for (int c = 0; c < size; c++) {
                LockGuard s = new LockGuard();
                II_Result r = new II_Result();
                lr[c] = r;
                ls[c] = s;
                s.actor1();
                s.actor2(r);
                counter.record(r);
            }
        });
    }

    @Override
    public Counter<II_Result> internalRun() {
        gs = new LockGuard[config.minStride];
        gr = new II_Result[config.minStride];
        for (int c = 0; c < config.minStride; c++) {
            gs[c] = new LockGuard();
            gr[c] = new II_Result();
        }
        workerSync = new WorkerSync(false, 2, config.spinLoopStyle);

        control.isStopped = false;

        List<Callable<Counter<II_Result>>> tasks = new ArrayList<>();
        tasks.add(this::task_actor1);
        tasks.add(this::task_actor2);
        Collections.shuffle(tasks);

        Collection<Future<Counter<II_Result>>> results = new ArrayList<>();
        for (Callable<Counter<II_Result>> task : tasks) {
            results.add(pool.submit(task));
        }

        if (config.time > 0) {
            try {
                TimeUnit.MILLISECONDS.sleep(config.time);
            } catch (InterruptedException e) {
            }
        }

        control.isStopped = true;

        waitFor(results);

        Counter<II_Result> counter = new Counter<>();
        for (Future<Counter<II_Result>> f : results) {
            try {
                counter.merge(f.get());
            } catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
        return counter;
    }

    private void jcstress_consume(Counter<II_Result> cnt, int a) {
        LockGuard[] ls = gs;
        II_Result[] lr = gr;
        int len = ls.length;
        int left = a * len / 2;
        int right = (a + 1) * len / 2;
        for (int c = left; c < right; c++) {
            II_Result r = lr[c];
            LockGuard s = ls[c];
            s.x = 0;
            s.y = 0;
            cnt.record(r);
            r.r1 = 0;
            r.r2 = 0;
        }
    }

    private void jcstress_update(WorkerSync sync) {
        LockGuard[] ls = gs;
        II_Result[] lr = gr;
        int len = ls.length;

        int newLen = sync.updateStride ? Math.max(config.minStride, Math.min(len * 2, config.maxStride)) : len;

        if (newLen > len) {
            ls = Arrays.copyOf(ls, newLen);
            lr = Arrays.copyOf(lr, newLen);
            for (int c = len; c < newLen; c++) {
                ls[c] = new LockGuard();
                lr[c] = new II_Result();
            }
            gs = ls;
            gr = lr;
         }

        workerSync = new WorkerSync(control.isStopped, 2, config.spinLoopStyle);
   }
    private void jcstress_sink(int v) {};
    private void jcstress_sink(short v) {};
    private void jcstress_sink(byte v) {};
    private void jcstress_sink(char v) {};
    private void jcstress_sink(long v) {};
    private void jcstress_sink(float v) {};
    private void jcstress_sink(double v) {};
    private void jcstress_sink(Object v) {};

    private Counter<II_Result> task_actor1() {
        Counter<II_Result> counter = new Counter<>();
        AffinitySupport.bind(config.cpuMap.actorMap()[0]);
        while (true) {
            WorkerSync sync = workerSync;
            if (sync.stopped) {
                return counter;
            }
            sync.preRun();
            run_actor1(gs, gr);
            sync.postRun();
            jcstress_consume(counter, 0);
            if (sync.tryStartUpdate()) {
                jcstress_update(sync);
            }
            sync.postUpdate();
        }
    }

    private void run_actor1(LockGuard[] gs, II_Result[] gr) {
        LockGuard[] ls = gs;
        II_Result[] lr = gr;
        int size = ls.length;
        for (int c = 0; c < size; c++) {
            LockGuard s = ls[c];
            s.actor1();
        }
    }

    private Counter<II_Result> task_actor2() {
        Counter<II_Result> counter = new Counter<>();
        AffinitySupport.bind(config.cpuMap.actorMap()[1]);
        while (true) {
            WorkerSync sync = workerSync;
            if (sync.stopped) {
                return counter;
            }
            sync.preRun();
            run_actor2(gs, gr);
            sync.postRun();
            jcstress_consume(counter, 1);
            if (sync.tryStartUpdate()) {
                jcstress_update(sync);
            }
            sync.postUpdate();
        }
    }

    private void run_actor2(LockGuard[] gs, II_Result[] gr) {
        LockGuard[] ls = gs;
        II_Result[] lr = gr;
        int size = ls.length;
        for (int c = 0; c < size; c++) {
            LockGuard s = ls[c];
            II_Result r = lr[c];
            jcstress_sink(r.jcstress_trap);
            s.actor2(r);
        }
    }

}
