package org.openjdk.jcstress.samples;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openjdk.jcstress.infra.runners.TestConfig;
import org.openjdk.jcstress.infra.collectors.TestResultCollector;
import org.openjdk.jcstress.infra.runners.Runner;
import org.openjdk.jcstress.infra.runners.WorkerSync;
import org.openjdk.jcstress.util.Counter;
import org.openjdk.jcstress.vm.WhiteBoxSupport;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Callable;
import java.util.Collections;
import java.util.List;
import org.openjdk.jcstress.os.AffinitySupport;
import org.openjdk.jcstress.samples.APISample_03_Termination;

public class APISample_03_Termination_jcstress extends Runner<APISample_03_Termination_jcstress.Outcome> {

    public APISample_03_Termination_jcstress(TestConfig config, TestResultCollector collector, ExecutorService pool) {
        super(config, collector, pool, "org.openjdk.jcstress.samples.APISample_03_Termination");
    }

    @Override
    public void run() {
        Counter<Outcome> results = new Counter<>();

        try {
            WhiteBoxSupport.tryDeopt(config.deoptMode);
        } catch (NoClassDefFoundError err) {
            // gracefully "handle"
        }

        for (int c = 0; c < config.iters; c++) {
            run(results);

            if (results.count(Outcome.STALE) > 0) {
                messages.add("Have stale threads, forcing VM to exit for proper cleanup.");
                dump(results);
                System.exit(0);
            }
        }
        dump(results);
    }

    @Override
    public Counter<Outcome> sanityCheck() throws Throwable {
        throw new UnsupportedOperationException();
    }

    @Override
    public Counter<Outcome> internalRun() {
        throw new UnsupportedOperationException();
    }

    private void run(Counter<Outcome> results) {
        long target = System.currentTimeMillis() + config.time;
        while (System.currentTimeMillis() < target) {

            final APISample_03_Termination state = new APISample_03_Termination();
            final Holder holder = new Holder();

            Thread t1 = new Thread(new Runnable() {
                public void run() {
                    try {
                        holder.started = true;
                        state.actor1();
                    } catch (Exception e) {
                        holder.error = true;
                    }
                    holder.terminated = true;
                }
            });
            t1.setDaemon(true);
            t1.start();

            while (!holder.started) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1);
                } catch (InterruptedException e) {
                    // do nothing
                }
            }

            try {
                state.signal();
            } catch (Exception e) {
                holder.error = true;
            }

            try {
                t1.join(Math.max(2*config.time, Runner.MIN_TIMEOUT_MS));
            } catch (InterruptedException e) {
                // do nothing
            }

            if (holder.terminated) {
                if (holder.error) {
                    results.record(Outcome.ERROR);
                } else {
                    results.record(Outcome.TERMINATED);
                }
            } else {
                results.record(Outcome.STALE);
                return;
            }
        }
    }

    private static class Holder {
        volatile boolean started;
        volatile boolean terminated;
        volatile boolean error;
    }

    public enum Outcome {
        TERMINATED,
        STALE,
        ERROR,
    }
}
