/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.export.Rfc6020ModuleWriter;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;

@Beta
@NotThreadSafe
final class SchemaToStatementWriterAdaptor
implements Rfc6020ModuleWriter {
    private final StatementTextWriter writer;

    private SchemaToStatementWriterAdaptor(StatementTextWriter writer) {
        this.writer = (StatementTextWriter)Preconditions.checkNotNull((Object)writer);
    }

    public static Rfc6020ModuleWriter from(StatementTextWriter writer) {
        return new SchemaToStatementWriterAdaptor(writer);
    }

    @Override
    public void endNode() {
        this.writer.endStatement();
    }

    @Override
    public void startModuleNode(String identifier) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.MODULE);
        this.writer.writeArgument(identifier);
    }

    @Override
    public void startOrganizationNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ORGANIZATION);
        this.writer.writeArgument(input);
    }

    @Override
    public void startContactNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.CONTACT);
        this.writer.writeArgument(input);
    }

    @Override
    public void startDescriptionNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.DESCRIPTION);
        this.writer.writeArgument(input);
    }

    @Override
    public void startReferenceNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.REFERENCE);
        this.writer.writeArgument(input);
    }

    @Override
    public void startUnitsNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.UNITS);
        this.writer.writeArgument(input);
    }

    @Override
    public void startYangVersionNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.YANG_VERSION);
        this.writer.writeArgument(input);
    }

    @Override
    public void startNamespaceNode(URI uri) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.NAMESPACE);
        this.writer.writeArgument(uri.toString());
    }

    @Override
    public void startKeyNode(List<QName> keyList) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.KEY);
        StringBuilder keyStr = new StringBuilder();
        Iterator<QName> iter = keyList.iterator();
        while (iter.hasNext()) {
            keyStr.append(iter.next().getLocalName());
            if (!iter.hasNext()) continue;
            keyStr.append(' ');
        }
        this.writer.writeArgument(keyStr.toString());
    }

    @Override
    public void startPrefixNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.PREFIX);
        this.writer.writeArgument(input);
    }

    @Override
    public void startFeatureNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.FEATURE);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startExtensionNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.EXTENSION);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startArgumentNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ARGUMENT);
        this.writer.writeArgument(input);
    }

    @Override
    public void startStatusNode(Status status) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.STATUS);
        this.writer.writeArgument(status.toString().toLowerCase());
    }

    @Override
    public void startTypeNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.TYPE);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startLeafNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.LEAF);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startContainerNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.CONTAINER);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startGroupingNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.GROUPING);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startRpcNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.RPC);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startInputNode() {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.INPUT);
    }

    @Override
    public void startOutputNode() {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.OUTPUT);
    }

    @Override
    public void startLeafListNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.LEAF_LIST);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startListNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.LIST);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startChoiceNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.CHOICE);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startCaseNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.CASE);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startNotificationNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.NOTIFICATION);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startIdentityNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.IDENTITY);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startBaseNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.BASE);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startTypedefNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.TYPEDEF);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startRevisionNode(Date date) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.REVISION);
        this.writer.writeArgument(SimpleDateFormatUtil.getRevisionFormat().format(date));
    }

    @Override
    public void startDefaultNode(String string) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.DEFAULT);
        this.writer.writeArgument(string);
    }

    @Override
    public void startMustNode(RevisionAwareXPath xpath) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.MUST);
        this.writer.writeArgument(xpath);
    }

    @Override
    public void startErrorMessageNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ERROR_MESSAGE);
        this.writer.writeArgument(input);
    }

    @Override
    public void startErrorAppTagNode(String input) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ERROR_APP_TAG);
        this.writer.writeArgument(input);
    }

    @Override
    public void startPatternNode(String regularExpression) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.PATTERN);
        this.writer.writeArgument(regularExpression);
    }

    @Override
    public void startValueNode(Integer integer) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.VALUE);
        this.writer.writeArgument(integer.toString());
    }

    @Override
    public void startEnumNode(String name) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ENUM);
        this.writer.writeArgument(name);
    }

    @Override
    public void startRequireInstanceNode(boolean require) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.REQUIRE_INSTANCE);
        this.writer.writeArgument(Boolean.toString(require));
    }

    @Override
    public void startPathNode(RevisionAwareXPath revisionAwareXPath) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.PATH);
        this.writer.writeArgument(revisionAwareXPath);
    }

    @Override
    public void startBitNode(String name) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.BIT);
        this.writer.writeArgument(name);
    }

    @Override
    public void startPositionNode(UnsignedInteger position) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.POSITION);
        this.writer.writeArgument(position.toString());
    }

    @Override
    public void startImportNode(String moduleName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.IMPORT);
        this.writer.writeArgument(moduleName);
    }

    @Override
    public void startRevisionDateNode(Date date) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.REVISION_DATE);
        this.writer.writeArgument(SimpleDateFormatUtil.getRevisionFormat().format(date));
    }

    @Override
    public void startUsesNode(QName groupingName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.USES);
        this.writer.writeArgument(groupingName);
    }

    @Override
    public void startAugmentNode(SchemaPath targetPath) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.AUGMENT);
        this.writer.writeArgument(targetPath);
    }

    @Override
    public void startConfigNode(boolean config) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.CONFIG);
        this.writer.writeArgument(Boolean.toString(config));
    }

    @Override
    public void startLengthNode(String lengthString) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.LENGTH);
        this.writer.writeArgument(lengthString);
    }

    @Override
    public void startMaxElementsNode(Integer max) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.MAX_ELEMENTS);
        this.writer.writeArgument(max.toString());
    }

    @Override
    public void startMinElementsNode(Integer min) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.MIN_ELEMENTS);
        this.writer.writeArgument(min.toString());
    }

    @Override
    public void startPresenceNode(boolean presence) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.PRESENCE);
        this.writer.writeArgument(Boolean.toString(presence));
    }

    @Override
    public void startOrderedByNode(String ordering) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ORDERED_BY);
        this.writer.writeArgument(ordering);
    }

    @Override
    public void startRangeNode(String rangeString) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.RANGE);
        this.writer.writeArgument(rangeString);
    }

    @Override
    public void startFractionDigitsNode(Integer fractionDigits) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.FRACTION_DIGITS);
        this.writer.writeArgument(fractionDigits.toString());
    }

    @Override
    public void startRefineNode(SchemaPath path) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.REFINE);
        this.writer.writeArgument(path);
    }

    @Override
    public void startMandatoryNode(boolean mandatory) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.MANDATORY);
        this.writer.writeArgument(Boolean.toString(mandatory));
    }

    @Override
    public void startAnyxmlNode(QName qName) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.ANYXML);
        this.writer.writeArgument(qName);
    }

    @Override
    public void startUnknownNode(StatementDefinition def) {
        this.writer.startStatement(def);
    }

    @Override
    public void startUnknownNode(StatementDefinition def, String nodeParameter) {
        this.writer.startStatement(def);
        this.writer.writeArgument(nodeParameter);
    }

    @Override
    public void startYinElementNode(boolean yinElement) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.YIN_ELEMENT);
        this.writer.writeArgument(Boolean.toString(yinElement));
    }

    @Override
    public void startWhenNode(RevisionAwareXPath revisionAwareXPath) {
        this.writer.startStatement((StatementDefinition)Rfc6020Mapping.WHEN);
        this.writer.writeArgument(revisionAwareXPath);
    }
}

