/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedInteger;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.MustDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.export.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.export.Rfc6020ModuleWriter;
import org.opendaylight.yangtools.yang.model.export.SchemaToStatementWriterAdaptor;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;
import org.opendaylight.yangtools.yang.model.util.DerivedType;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;

@Beta
@NotThreadSafe
class SchemaContextEmitter {
    private final Rfc6020ModuleWriter writer;
    private final boolean emitInstantiated;
    private final boolean emitUses;
    private final Map<QName, StatementDefinition> extensions;

    SchemaContextEmitter(Rfc6020ModuleWriter writer, Map<QName, StatementDefinition> extensions) {
        this(writer, extensions, false, true);
    }

    SchemaContextEmitter(Rfc6020ModuleWriter writer, Map<QName, StatementDefinition> extensions, boolean emitInstantiated, boolean emitUses) {
        this.writer = (Rfc6020ModuleWriter)Preconditions.checkNotNull((Object)writer);
        this.emitInstantiated = emitInstantiated;
        this.emitUses = emitUses;
        this.extensions = (Map)Preconditions.checkNotNull(extensions);
    }

    static void writeToStatementWriter(Module module, SchemaContext ctx, StatementTextWriter statementWriter) {
        Rfc6020ModuleWriter yangSchemaWriter = SchemaToStatementWriterAdaptor.from(statementWriter);
        Map<QName, StatementDefinition> extensions = ExtensionStatement.mapFrom(ctx.getExtensions());
        new SchemaContextEmitter(yangSchemaWriter, extensions).emitModule(module);
    }

    void emitModule(Module input) {
        this.writer.startModuleNode(input.getName());
        this.emitModuleHeader(input);
        this.emitLinkageNodes(input);
        this.emitMetaNodes(input);
        this.emitRevisionNodes(input);
        this.emitBodyNodes(input);
        this.writer.endNode();
    }

    private void emitModuleHeader(Module input) {
        this.emitYangVersionNode(input.getYangVersion());
        this.emitNamespace(input.getNamespace());
        this.emitPrefixNode(input.getPrefix());
    }

    private void emitSubmodule(String input) {
    }

    private void emitSubmoduleHeaderNodes(Module input) {
    }

    private void emitMetaNodes(Module input) {
        this.emitOrganizationNode(input.getOrganization());
        this.emitContact(input.getContact());
        this.emitDescriptionNode(input.getDescription());
        this.emitReferenceNode(input.getReference());
    }

    private void emitLinkageNodes(Module input) {
        for (ModuleImport importNode : input.getImports()) {
            this.emitImport(importNode);
        }
    }

    private void emitRevisionNodes(Module input) {
        this.emitRevision(input.getRevision());
    }

    private void emitBodyNodes(Module input) {
        for (ExtensionDefinition extension : input.getExtensionSchemaNodes()) {
            this.emitExtension(extension);
        }
        for (FeatureDefinition definition : input.getFeatures()) {
            this.emitFeature(definition);
        }
        for (IdentitySchemaNode identity : input.getIdentities()) {
            this.emitIdentity(identity);
        }
        this.emitDataNodeContainer((DataNodeContainer)input);
        for (AugmentationSchema augmentation : input.getAugmentations()) {
            this.emitAugment(augmentation);
        }
        for (RpcDefinition rpc : input.getRpcs()) {
            this.emitRpc(rpc);
        }
        for (NotificationDefinition notification : input.getNotifications()) {
            this.emitNotificationNode(notification);
        }
        for (Deviation deviation : input.getDeviations()) {
            this.emitDeviation(deviation);
        }
    }

    private void emitDataNodeContainer(DataNodeContainer input) {
        for (TypeDefinition typedef : input.getTypeDefinitions()) {
            this.emitTypedefNode(typedef);
        }
        for (GroupingDefinition grouping : input.getGroupings()) {
            this.emitGrouping(grouping);
        }
        for (DataSchemaNode child : input.getChildNodes()) {
            this.emitDataSchemaNode(child);
        }
        for (UsesNode usesNode : input.getUses()) {
            this.emitUsesNode(usesNode);
        }
    }

    private void emitDataSchemaNode(DataSchemaNode child) {
        if (!this.emitInstantiated && (child.isAddedByUses() || child.isAugmenting())) {
            return;
        }
        if (child instanceof ContainerSchemaNode) {
            this.emitContainer((ContainerSchemaNode)child);
        } else if (child instanceof LeafSchemaNode) {
            this.emitLeaf((LeafSchemaNode)child);
        } else if (child instanceof LeafListSchemaNode) {
            this.emitLeafList((LeafListSchemaNode)child);
        } else if (child instanceof ListSchemaNode) {
            this.emitList((ListSchemaNode)child);
        } else if (child instanceof ChoiceSchemaNode) {
            this.emitChoice((ChoiceSchemaNode)child);
        } else if (child instanceof AnyXmlSchemaNode) {
            this.emitAnyxml((AnyXmlSchemaNode)child);
        } else {
            throw new UnsupportedOperationException("Not supported DataSchemaNode type " + child.getClass());
        }
    }

    private void emitYangVersionNode(String input) {
        this.writer.startYangVersionNode(input);
        this.writer.endNode();
    }

    private void emitImport(ModuleImport importNode) {
        this.writer.startImportNode(importNode.getModuleName());
        this.emitPrefixNode(importNode.getPrefix());
        this.emitRevisionDateNode(importNode.getRevision());
        this.writer.endNode();
    }

    private void emitInclude(String input) {
    }

    private void emitNamespace(URI uri) {
        this.writer.startNamespaceNode(uri);
        this.writer.endNode();
    }

    private void emitPrefixNode(String input) {
        this.writer.startPrefixNode(input);
        this.writer.endNode();
    }

    private void emitBelongsTo(String input) {
    }

    private void emitOrganizationNode(String input) {
        this.writer.startOrganizationNode(input);
        this.writer.endNode();
    }

    private void emitContact(String input) {
        this.writer.startContactNode(input);
        this.writer.endNode();
    }

    private void emitDescriptionNode(@Nullable String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            this.writer.startDescriptionNode(input);
            this.writer.endNode();
        }
    }

    private void emitReferenceNode(@Nullable String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            this.writer.startReferenceNode(input);
            this.writer.endNode();
        }
    }

    private void emitUnitsNode(@Nullable String input) {
        if (!Strings.isNullOrEmpty((String)input)) {
            this.writer.startUnitsNode(input);
            this.writer.endNode();
        }
    }

    private void emitRevision(Date date) {
        this.writer.startRevisionNode(date);
        this.writer.endNode();
    }

    private void emitRevisionDateNode(@Nullable Date date) {
        if (date != null) {
            this.writer.startRevisionDateNode(date);
            this.writer.endNode();
        }
    }

    private void emitExtension(ExtensionDefinition extension) {
        this.writer.startExtensionNode(extension.getQName());
        this.emitArgument(extension.getArgument(), extension.isYinElement());
        this.emitStatusNode(extension.getStatus());
        this.emitDescriptionNode(extension.getDescription());
        this.emitReferenceNode(extension.getReference());
        this.emitUnknownStatementNodes(extension.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitArgument(@Nullable String input, boolean yinElement) {
        if (input != null) {
            this.writer.startArgumentNode(input);
            this.emitYinElement(yinElement);
            this.writer.endNode();
        }
    }

    private void emitYinElement(boolean yinElement) {
        this.writer.startYinElementNode(yinElement);
        this.writer.endNode();
    }

    private void emitIdentity(IdentitySchemaNode identity) {
        this.writer.startIdentityNode(identity.getQName());
        if (identity.getBaseIdentity() != null) {
            this.emitBase(identity.getBaseIdentity().getQName());
        }
        this.emitStatusNode(identity.getStatus());
        this.emitDescriptionNode(identity.getDescription());
        this.emitReferenceNode(identity.getReference());
        this.writer.endNode();
    }

    private void emitBase(QName qName) {
        this.writer.startBaseNode(qName);
        this.writer.endNode();
    }

    private void emitFeature(FeatureDefinition definition) {
        this.writer.startFeatureNode(definition.getQName());
        this.emitStatusNode(definition.getStatus());
        this.emitDescriptionNode(definition.getDescription());
        this.emitReferenceNode(definition.getReference());
        this.writer.endNode();
    }

    private void emitIfFeature(String input) {
    }

    private void emitTypedefNode(TypeDefinition<?> typedef) {
        this.writer.startTypedefNode(typedef.getQName());
        this.emitTypeNodeDerived(typedef);
        this.emitUnitsNode(typedef.getUnits());
        this.emitDefaultNode(typedef.getDefaultValue());
        this.emitStatusNode(typedef.getStatus());
        this.emitDescriptionNode(typedef.getDescription());
        this.emitReferenceNode(typedef.getReference());
        this.emitUnknownStatementNodes(typedef.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitTypeNode(SchemaPath parentPath, TypeDefinition<?> subtype) {
        SchemaPath path = subtype.getPath();
        if (SchemaContextEmitter.isPrefix(parentPath.getPathFromRoot(), path.getPathFromRoot())) {
            this.emitTypeNodeDerived(subtype);
        } else {
            this.emitTypeNodeReferenced(subtype);
        }
    }

    private void emitTypeNodeReferenced(TypeDefinition<?> typeDefinition) {
        this.writer.startTypeNode(typeDefinition.getQName());
        this.writer.endNode();
    }

    private void emitTypeNodeDerived(TypeDefinition<?> typeDefinition) {
        TypeDefinition baseType = typeDefinition.getBaseType() != null ? typeDefinition.getBaseType() : typeDefinition;
        this.writer.startTypeNode(baseType.getQName());
        this.emitTypeBodyNodes(typeDefinition);
        this.writer.endNode();
    }

    private void emitTypeBodyNodes(TypeDefinition<?> typeDef) {
        if (typeDef instanceof ExtendedType) {
            this.emitTypeBodyNodes(DerivedType.from((ExtendedType)((ExtendedType)typeDef)));
        } else if (typeDef instanceof UnsignedIntegerTypeDefinition) {
            this.emitUnsignedIntegerSpecification((UnsignedIntegerTypeDefinition)typeDef);
        } else if (typeDef instanceof IntegerTypeDefinition) {
            this.emitIntegerSpefication((IntegerTypeDefinition)typeDef);
        } else if (typeDef instanceof DecimalTypeDefinition) {
            this.emitDecimal64Specification((DecimalTypeDefinition)typeDef);
        } else if (typeDef instanceof StringTypeDefinition) {
            this.emitStringRestrictions((StringTypeDefinition)typeDef);
        } else if (typeDef instanceof EnumTypeDefinition) {
            this.emitEnumSpecification((EnumTypeDefinition)typeDef);
        } else if (typeDef instanceof LeafrefTypeDefinition) {
            this.emitLeafrefSpecification((LeafrefTypeDefinition)typeDef);
        } else if (typeDef instanceof IdentityrefTypeDefinition) {
            this.emitIdentityrefSpecification((IdentityrefTypeDefinition)typeDef);
        } else if (typeDef instanceof InstanceIdentifierTypeDefinition) {
            this.emitInstanceIdentifierSpecification((InstanceIdentifierTypeDefinition)typeDef);
        } else if (typeDef instanceof BitsTypeDefinition) {
            this.emitBitsSpecification((BitsTypeDefinition)typeDef);
        } else if (typeDef instanceof UnionTypeDefinition) {
            this.emitUnionSpecification((UnionTypeDefinition)typeDef);
        } else if (!(typeDef instanceof BinaryTypeDefinition || typeDef instanceof BooleanTypeDefinition || typeDef instanceof EmptyTypeDefinition)) {
            throw new IllegalArgumentException("Not supported type " + typeDef.getClass());
        }
    }

    private void emitIntegerSpefication(IntegerTypeDefinition typeDef) {
        this.emitRangeNodeOptional(typeDef.getRangeConstraints());
    }

    private void emitUnsignedIntegerSpecification(UnsignedIntegerTypeDefinition typeDef) {
        this.emitRangeNodeOptional(typeDef.getRangeConstraints());
    }

    private void emitRangeNodeOptional(List<RangeConstraint> list) {
        if (!list.isEmpty()) {
            this.writer.startRangeNode(SchemaContextEmitter.toRangeString(list));
            RangeConstraint first = list.iterator().next();
            this.emitErrorMessageNode(first.getErrorMessage());
            this.emitErrorAppTagNode(first.getErrorAppTag());
            this.emitDescriptionNode(first.getDescription());
            this.emitReferenceNode(first.getReference());
            this.writer.endNode();
        }
    }

    private void emitDecimal64Specification(DecimalTypeDefinition typeDefinition) {
        this.emitFranctionDigitsNode(typeDefinition.getFractionDigits());
        this.emitRangeNodeOptional(typeDefinition.getRangeConstraints());
    }

    private void emitFranctionDigitsNode(Integer fractionDigits) {
        this.writer.startFractionDigitsNode(fractionDigits);
        this.writer.endNode();
    }

    private void emitStringRestrictions(StringTypeDefinition typeDef) {
        this.emitLength(typeDef.getLengthConstraints());
        for (PatternConstraint pattern : typeDef.getPatternConstraints()) {
            this.emitPatternNode(pattern);
        }
    }

    private void emitLength(List<LengthConstraint> list) {
        if (!list.isEmpty()) {
            this.writer.startLengthNode(SchemaContextEmitter.toLengthString(list));
            LengthConstraint first = list.iterator().next();
            this.emitErrorMessageNode(first.getErrorMessage());
            this.emitErrorAppTagNode(first.getErrorAppTag());
            this.emitDescriptionNode(first.getDescription());
            this.emitReferenceNode(first.getReference());
            this.writer.endNode();
        }
    }

    private static String toLengthString(List<LengthConstraint> list) {
        StringBuilder lengthStr = new StringBuilder();
        Iterator<LengthConstraint> constIt = list.iterator();
        while (constIt.hasNext()) {
            LengthConstraint current = constIt.next();
            if (current.getMin() == current.getMax()) {
                lengthStr.append(current.getMin());
            } else {
                lengthStr.append(current.getMin());
                lengthStr.append("..");
                lengthStr.append(current.getMax());
            }
            if (!constIt.hasNext()) continue;
            lengthStr.append("|");
        }
        return lengthStr.toString();
    }

    private static String toRangeString(List<RangeConstraint> list) {
        StringBuilder lengthStr = new StringBuilder();
        Iterator<RangeConstraint> constIt = list.iterator();
        while (constIt.hasNext()) {
            RangeConstraint current = constIt.next();
            if (current.getMin() == current.getMax()) {
                lengthStr.append(current.getMin());
            } else {
                lengthStr.append(current.getMin());
                lengthStr.append("..");
                lengthStr.append(current.getMax());
            }
            if (!constIt.hasNext()) continue;
            lengthStr.append("|");
        }
        return lengthStr.toString();
    }

    private void emitPatternNode(PatternConstraint pattern) {
        this.writer.startPatternNode(pattern.getRegularExpression());
        this.emitErrorMessageNode(pattern.getErrorMessage());
        this.emitErrorAppTagNode(pattern.getErrorAppTag());
        this.emitDescriptionNode(pattern.getDescription());
        this.emitReferenceNode(pattern.getReference());
        this.writer.endNode();
    }

    private void emitDefaultNode(@Nullable Object object) {
        if (object != null) {
            this.writer.startDefaultNode(object.toString());
            this.writer.endNode();
        }
    }

    private void emitEnumSpecification(EnumTypeDefinition typeDefinition) {
        for (EnumTypeDefinition.EnumPair enumValue : typeDefinition.getValues()) {
            this.emitEnumNode(enumValue);
        }
    }

    private void emitEnumNode(EnumTypeDefinition.EnumPair enumValue) {
        this.writer.startEnumNode(enumValue.getName());
        this.emitValueNode(enumValue.getValue());
        this.emitStatusNode(enumValue.getStatus());
        this.emitDescriptionNode(enumValue.getDescription());
        this.emitReferenceNode(enumValue.getReference());
        this.writer.endNode();
    }

    private void emitLeafrefSpecification(LeafrefTypeDefinition typeDefinition) {
        this.emitPathNode(typeDefinition.getPathStatement());
    }

    private void emitPathNode(RevisionAwareXPath revisionAwareXPath) {
        this.writer.startPathNode(revisionAwareXPath);
        this.writer.endNode();
    }

    private void emitRequireInstanceNode(boolean require) {
        this.writer.startRequireInstanceNode(require);
        this.writer.endNode();
    }

    private void emitInstanceIdentifierSpecification(InstanceIdentifierTypeDefinition typeDefinition) {
        this.emitRequireInstanceNode(typeDefinition.requireInstance());
    }

    private void emitIdentityrefSpecification(IdentityrefTypeDefinition typeDefinition) {
        this.emitBase(typeDefinition.getQName());
    }

    private void emitUnionSpecification(UnionTypeDefinition typeDefinition) {
        for (TypeDefinition subtype : typeDefinition.getTypes()) {
            this.emitTypeNode(typeDefinition.getPath(), subtype);
        }
    }

    private void emitBitsSpecification(BitsTypeDefinition typeDefinition) {
        for (BitsTypeDefinition.Bit bit : typeDefinition.getBits()) {
            this.emitBit(bit);
        }
    }

    private void emitBit(BitsTypeDefinition.Bit bit) {
        this.writer.startBitNode(bit.getName());
        this.emitPositionNode(bit.getPosition());
        this.emitStatusNode(bit.getStatus());
        this.emitDescriptionNode(bit.getDescription());
        this.emitReferenceNode(bit.getReference());
        this.writer.endNode();
    }

    private void emitPositionNode(@Nullable Long position) {
        if (position != null) {
            this.writer.startPositionNode(UnsignedInteger.valueOf((long)position));
            this.writer.endNode();
        }
    }

    private void emitStatusNode(@Nullable Status status) {
        if (status != null) {
            this.writer.startStatusNode(status);
            this.writer.endNode();
        }
    }

    private void emitConfigNode(boolean config) {
        this.writer.startConfigNode(config);
        this.writer.endNode();
    }

    private void emitMandatoryNode(boolean mandatory) {
        this.writer.startMandatoryNode(mandatory);
        this.writer.endNode();
    }

    private void emitPresenceNode(boolean presence) {
        this.writer.startPresenceNode(presence);
        this.writer.endNode();
    }

    private void emitOrderedBy(boolean userOrdered) {
        if (userOrdered) {
            this.writer.startOrderedByNode("user");
        } else {
            this.writer.startOrderedByNode("system");
        }
        this.writer.endNode();
    }

    private void emitMust(@Nullable MustDefinition mustCondition) {
        if (mustCondition != null && mustCondition.getXpath() != null) {
            this.writer.startMustNode(mustCondition.getXpath());
            this.emitErrorMessageNode(mustCondition.getErrorMessage());
            this.emitErrorAppTagNode(mustCondition.getErrorAppTag());
            this.emitDescriptionNode(mustCondition.getDescription());
            this.emitReferenceNode(mustCondition.getReference());
            this.writer.endNode();
        }
    }

    private void emitErrorMessageNode(@Nullable String input) {
        if (input != null && !input.isEmpty()) {
            this.writer.startErrorMessageNode(input);
            this.writer.endNode();
        }
    }

    private void emitErrorAppTagNode(String input) {
        if (input != null && !input.isEmpty()) {
            this.writer.startErrorAppTagNode(input);
            this.writer.endNode();
        }
    }

    private void emitMinElementsNode(Integer min) {
        if (min != null) {
            this.writer.startMinElementsNode(min);
            this.writer.endNode();
        }
    }

    private void emitMaxElementsNode(Integer max) {
        if (max != null) {
            this.writer.startMaxElementsNode(max);
            this.writer.endNode();
        }
    }

    private void emitValueNode(@Nullable Integer value) {
        if (value != null) {
            this.writer.startValueNode(value);
            this.writer.endNode();
        }
    }

    private void emitDocumentedNode(DocumentedNode input) {
        this.emitStatusNode(input.getStatus());
        this.emitDescriptionNode(input.getDescription());
        this.emitReferenceNode(input.getReference());
    }

    private void emitGrouping(GroupingDefinition grouping) {
        this.writer.startGroupingNode(grouping.getQName());
        this.emitDocumentedNode((DocumentedNode)grouping);
        this.emitDataNodeContainer((DataNodeContainer)grouping);
        this.emitUnknownStatementNodes(grouping.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitContainer(ContainerSchemaNode child) {
        this.writer.startContainerNode(child.getQName());
        this.emitConstraints(child.getConstraints());
        this.emitMustNodes(child.getConstraints().getMustConstraints());
        this.emitPresenceNode(child.isPresenceContainer());
        this.emitConfigNode(child.isConfiguration());
        this.emitDocumentedNode((DocumentedNode)child);
        this.emitDataNodeContainer((DataNodeContainer)child);
        this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitConstraints(ConstraintDefinition constraints) {
        this.emitWhen(constraints.getWhenCondition());
        for (MustDefinition mustCondition : constraints.getMustConstraints()) {
            this.emitMust(mustCondition);
        }
    }

    private void emitLeaf(LeafSchemaNode child) {
        this.writer.startLeafNode(child.getQName());
        this.emitWhen(child.getConstraints().getWhenCondition());
        this.emitTypeNode(child.getPath(), child.getType());
        this.emitUnitsNode(child.getUnits());
        this.emitMustNodes(child.getConstraints().getMustConstraints());
        this.emitDefaultNode(child.getDefault());
        this.emitConfigNode(child.isConfiguration());
        this.emitMandatoryNode(child.getConstraints().isMandatory());
        this.emitDocumentedNode((DocumentedNode)child);
        this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitLeafList(LeafListSchemaNode child) {
        this.writer.startLeafListNode(child.getQName());
        this.emitWhen(child.getConstraints().getWhenCondition());
        this.emitTypeNode(child.getPath(), child.getType());
        this.emitMustNodes(child.getConstraints().getMustConstraints());
        this.emitConfigNode(child.isConfiguration());
        this.emitMinElementsNode(child.getConstraints().getMinElements());
        this.emitMaxElementsNode(child.getConstraints().getMaxElements());
        this.emitOrderedBy(child.isUserOrdered());
        this.emitDocumentedNode((DocumentedNode)child);
        this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitList(ListSchemaNode child) {
        this.writer.startListNode(child.getQName());
        this.emitWhen(child.getConstraints().getWhenCondition());
        this.emitMustNodes(child.getConstraints().getMustConstraints());
        this.emitKey(child.getKeyDefinition());
        this.emitConfigNode(child.isConfiguration());
        this.emitMinElementsNode(child.getConstraints().getMinElements());
        this.emitMaxElementsNode(child.getConstraints().getMaxElements());
        this.emitOrderedBy(child.isUserOrdered());
        this.emitDocumentedNode((DocumentedNode)child);
        this.emitDataNodeContainer((DataNodeContainer)child);
        this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitMustNodes(Set<MustDefinition> mustConstraints) {
        for (MustDefinition must : mustConstraints) {
            this.emitMust(must);
        }
    }

    private void emitKey(List<QName> keyList) {
        if (keyList != null && !keyList.isEmpty()) {
            this.writer.startKeyNode(keyList);
            this.writer.endNode();
        }
    }

    private void emitUnique(String input) {
    }

    private void emitChoice(ChoiceSchemaNode choice) {
        this.writer.startChoiceNode(choice.getQName());
        this.emitWhen(choice.getConstraints().getWhenCondition());
        this.emitConfigNode(choice.isConfiguration());
        this.emitMandatoryNode(choice.getConstraints().isMandatory());
        this.emitDocumentedNode((DocumentedNode)choice);
        for (ChoiceCaseNode caze : choice.getCases()) {
            this.emitCaseNode(caze);
        }
        this.emitUnknownStatementNodes(choice.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitCaseNode(ChoiceCaseNode caze) {
        if (!this.emitInstantiated && caze.isAugmenting()) {
            return;
        }
        this.writer.startCaseNode(caze.getQName());
        this.emitWhen(caze.getConstraints().getWhenCondition());
        this.emitDocumentedNode((DocumentedNode)caze);
        this.emitDataNodeContainer((DataNodeContainer)caze);
        this.emitUnknownStatementNodes(caze.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitAnyxml(AnyXmlSchemaNode child) {
        this.writer.startAnyxmlNode(child.getQName());
        this.emitWhen(child.getConstraints().getWhenCondition());
        this.emitMustNodes(child.getConstraints().getMustConstraints());
        this.emitConfigNode(child.isConfiguration());
        this.emitMandatoryNode(child.getConstraints().isMandatory());
        this.emitDocumentedNode((DocumentedNode)child);
        this.emitUnknownStatementNodes(child.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitUsesNode(UsesNode usesNode) {
        if (this.emitUses && !usesNode.isAddedByUses() && !usesNode.isAugmenting()) {
            this.writer.startUsesNode(usesNode.getGroupingPath().getLastComponent());
            for (Map.Entry<SchemaPath, SchemaNode> entry : usesNode.getRefines().entrySet()) {
                this.emitRefine(entry);
            }
            for (AugmentationSchema augmentationSchema : usesNode.getAugmentations()) {
                this.emitUsesAugmentNode(augmentationSchema);
            }
            this.writer.endNode();
        }
    }

    private void emitRefine(Map.Entry<SchemaPath, SchemaNode> refine) {
        SchemaPath path = refine.getKey();
        SchemaNode value = refine.getValue();
        this.writer.startRefineNode(path);
        if (value instanceof LeafSchemaNode) {
            this.emitRefineLeafNodes((LeafSchemaNode)value);
        } else if (value instanceof LeafListSchemaNode) {
            this.emitRefineLeafListNodes((LeafListSchemaNode)value);
        } else if (value instanceof ListSchemaNode) {
            this.emitRefineListNodes((ListSchemaNode)value);
        } else if (value instanceof ChoiceSchemaNode) {
            this.emitRefineChoiceNodes((ChoiceSchemaNode)value);
        } else if (value instanceof ChoiceCaseNode) {
            this.emitRefineCaseNodes((ChoiceCaseNode)value);
        } else if (value instanceof ContainerSchemaNode) {
            this.emitRefineContainerNodes((ContainerSchemaNode)value);
        } else if (value instanceof AnyXmlSchemaNode) {
            this.emitRefineAnyxmlNodes((AnyXmlSchemaNode)value);
        }
        this.writer.endNode();
    }

    private static <T extends SchemaNode> T getOriginalChecked(T value) {
        Optional original = SchemaNodeUtils.getOriginalIfPossible(value);
        Preconditions.checkArgument((boolean)original.isPresent(), (Object)"Original unmodified version of node is not present.");
        SchemaNode ret = (SchemaNode)original.get();
        return (T)ret;
    }

    private void emitDocumentedNodeRefine(DocumentedNode original, DocumentedNode value) {
        if (Objects.deepEquals(original.getDescription(), value.getDescription())) {
            this.emitDescriptionNode(value.getDescription());
        }
        if (Objects.deepEquals(original.getReference(), value.getReference())) {
            this.emitReferenceNode(value.getReference());
        }
    }

    private void emitRefineContainerNodes(ContainerSchemaNode value) {
        ContainerSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.isPresenceContainer(), value.isPresenceContainer())) {
            this.emitPresenceNode(value.isPresenceContainer());
        }
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitRefineLeafNodes(LeafSchemaNode value) {
        LeafSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.getDefault(), value.getDefault())) {
            this.emitDefaultNode(value.getDefault());
        }
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
        if (Objects.deepEquals(original.getConstraints().isMandatory(), value.getConstraints().isMandatory())) {
            this.emitMandatoryNode(value.getConstraints().isMandatory());
        }
    }

    private void emitRefineLeafListNodes(LeafListSchemaNode value) {
        LeafListSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        if (Objects.deepEquals(original.getConstraints().getMinElements(), value.getConstraints().getMinElements())) {
            this.emitMinElementsNode(value.getConstraints().getMinElements());
        }
        if (Objects.deepEquals(original.getConstraints().getMaxElements(), value.getConstraints().getMaxElements())) {
            this.emitMaxElementsNode(value.getConstraints().getMaxElements());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitRefineListNodes(ListSchemaNode value) {
        ListSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        if (Objects.deepEquals(original.getConstraints().getMinElements(), value.getConstraints().getMinElements())) {
            this.emitMinElementsNode(value.getConstraints().getMinElements());
        }
        if (Objects.deepEquals(original.getConstraints().getMaxElements(), value.getConstraints().getMaxElements())) {
            this.emitMaxElementsNode(value.getConstraints().getMaxElements());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitRefineChoiceNodes(ChoiceSchemaNode value) {
        ChoiceSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        if (Objects.deepEquals(original.getConstraints().isMandatory(), value.getConstraints().isMandatory())) {
            this.emitMandatoryNode(value.getConstraints().isMandatory());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitRefineCaseNodes(ChoiceCaseNode value) {
        ChoiceCaseNode original = SchemaContextEmitter.getOriginalChecked(value);
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitRefineAnyxmlNodes(AnyXmlSchemaNode value) {
        AnyXmlSchemaNode original = SchemaContextEmitter.getOriginalChecked(value);
        if (Objects.deepEquals(original.isConfiguration(), value.isConfiguration())) {
            this.emitConfigNode(value.isConfiguration());
        }
        if (Objects.deepEquals(original.getConstraints().isMandatory(), value.getConstraints().isMandatory())) {
            this.emitMandatoryNode(value.getConstraints().isMandatory());
        }
        this.emitDocumentedNodeRefine((DocumentedNode)original, (DocumentedNode)value);
    }

    private void emitUsesAugmentNode(AugmentationSchema aug) {
        this.emitAugment(aug);
    }

    private void emitAugment(AugmentationSchema augmentation) {
        this.writer.startAugmentNode(augmentation.getTargetPath());
        this.emitStatusNode(augmentation.getStatus());
        this.emitDescriptionNode(augmentation.getDescription());
        this.emitReferenceNode(augmentation.getReference());
        for (UsesNode uses : augmentation.getUses()) {
            this.emitUsesNode(uses);
        }
        for (DataSchemaNode childNode : augmentation.getChildNodes()) {
            if (childNode instanceof ChoiceCaseNode) {
                this.emitCaseNode((ChoiceCaseNode)childNode);
                continue;
            }
            this.emitDataSchemaNode(childNode);
        }
        this.emitUnknownStatementNodes(augmentation.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitUnknownStatementNodes(List<UnknownSchemaNode> unknownNodes) {
        for (UnknownSchemaNode unknonwnNode : unknownNodes) {
            if (unknonwnNode.isAddedByAugmentation() || unknonwnNode.isAddedByUses()) continue;
            this.emitUnknownStatementNode(unknonwnNode);
        }
    }

    private void emitUnknownStatementNode(UnknownSchemaNode node) {
        StatementDefinition def = this.getStatementChecked(node.getNodeType());
        if (def.getArgumentName() == null) {
            this.writer.startUnknownNode(def);
        } else {
            this.writer.startUnknownNode(def, node.getNodeParameter());
        }
        this.emitUnknownStatementNodes(node.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private StatementDefinition getStatementChecked(QName nodeType) {
        StatementDefinition ret = this.extensions.get(nodeType);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"Unknown extension %s used during export.", (Object[])new Object[]{nodeType});
        return ret;
    }

    private void emitWhen(RevisionAwareXPath revisionAwareXPath) {
        if (revisionAwareXPath != null) {
            this.writer.startWhenNode(revisionAwareXPath);
            this.writer.endNode();
        }
    }

    private void emitRpc(RpcDefinition rpc) {
        this.writer.startRpcNode(rpc.getQName());
        this.emitStatusNode(rpc.getStatus());
        this.emitDescriptionNode(rpc.getDescription());
        this.emitReferenceNode(rpc.getReference());
        for (TypeDefinition typedef : rpc.getTypeDefinitions()) {
            this.emitTypedefNode(typedef);
        }
        for (GroupingDefinition grouping : rpc.getGroupings()) {
            this.emitGrouping(grouping);
        }
        this.emitInput(rpc.getInput());
        this.emitOutput(rpc.getOutput());
        this.emitUnknownStatementNodes(rpc.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private void emitInput(@Nullable ContainerSchemaNode input) {
        if (input != null) {
            this.writer.startInputNode();
            this.emitDataNodeContainer((DataNodeContainer)input);
            this.emitUnknownStatementNodes(input.getUnknownSchemaNodes());
            this.writer.endNode();
        }
    }

    private void emitOutput(@Nullable ContainerSchemaNode input) {
        if (input != null) {
            this.writer.startOutputNode();
            this.emitDataNodeContainer((DataNodeContainer)input);
            this.emitUnknownStatementNodes(input.getUnknownSchemaNodes());
            this.writer.endNode();
        }
    }

    private void emitNotificationNode(NotificationDefinition notification) {
        this.writer.startNotificationNode(notification.getQName());
        this.emitDocumentedNode((DocumentedNode)notification);
        this.emitDataNodeContainer((DataNodeContainer)notification);
        this.emitUnknownStatementNodes(notification.getUnknownSchemaNodes());
        this.writer.endNode();
    }

    private static <T> boolean isPrefix(Iterable<T> prefix, Iterable<T> other) {
        Iterator<T> prefixIt = prefix.iterator();
        Iterator<T> otherIt = other.iterator();
        while (prefixIt.hasNext()) {
            if (!otherIt.hasNext()) {
                return false;
            }
            if (Objects.deepEquals(prefixIt.next(), otherIt.next())) continue;
            return false;
        }
        return true;
    }

    private void emitDeviation(Deviation deviation) {
    }
}

