/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.Rfc6020Mapping;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.export.ExtensionStatement;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;

@Beta
@NotThreadSafe
class SingleModuleYinStatementWriter
implements StatementTextWriter {
    private final XMLStreamWriter writer;
    private final URI currentModuleNs;
    private final BiMap<String, URI> prefixToNamespace;
    private StatementDefinition currentStatement;

    private SingleModuleYinStatementWriter(XMLStreamWriter writer, URI moduleNamespace, Map<String, URI> prefixToNs) {
        this.writer = writer;
        this.currentModuleNs = moduleNamespace;
        this.prefixToNamespace = HashBiMap.create(prefixToNs);
        this.initializeYinNamespaceInXml();
    }

    private void initializeYinNamespaceInXml() {
        try {
            String defaultNs = this.writer.getNamespaceContext().getNamespaceURI("");
            if (defaultNs == null) {
                this.writer.setDefaultNamespace(YangConstants.RFC6020_YIN_NAMESPACE.toString());
            } else if (!YangConstants.RFC6020_YIN_NAMESPACE.toString().equals(defaultNs)) {
                throw new UnsupportedOperationException("Not implemented support for nesting YIN in different XML element.");
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    static StatementTextWriter create(XMLStreamWriter writer, URI moduleNs, Map<String, URI> prefixToNs) {
        return new SingleModuleYinStatementWriter(writer, moduleNs, prefixToNs);
    }

    @Override
    public void startStatement(StatementDefinition statement) {
        this.currentStatement = (StatementDefinition)Preconditions.checkNotNull((Object)statement);
        try {
            this.writeStartXmlElement(statement.getStatementName());
            if (Rfc6020Mapping.MODULE.equals((Object)statement) || Rfc6020Mapping.SUBMODULE.equals((Object)statement)) {
                this.declareXmlNamespaces((Map<String, URI>)this.prefixToNamespace);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void endStatement() {
        this.currentStatement = null;
        try {
            this.writeXmlEndElement();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeArgument(String strRep) {
        this.checkArgumentApplicable();
        this.writeArgument0(strRep);
    }

    @Override
    public void writeArgument(QName value) {
        this.checkArgumentApplicable();
        String valueStr = this.toPrefixedString(value);
        this.writeArgument0(valueStr);
    }

    @Override
    public void writeArgument(SchemaPath targetPath) {
        this.checkArgumentApplicable();
        StringBuilder valueStr = new StringBuilder();
        if (targetPath.isAbsolute()) {
            valueStr.append("/");
        }
        Iterator argIt = targetPath.getPathFromRoot().iterator();
        while (argIt.hasNext()) {
            valueStr.append(this.toPrefixedString((QName)argIt.next()));
            if (!argIt.hasNext()) continue;
            valueStr.append("/");
        }
        this.writeArgument0(valueStr.toString());
    }

    @Override
    public void writeArgument(RevisionAwareXPath xpath) {
        this.checkArgumentApplicable();
        this.writeArgument0(xpath.toString());
    }

    private void writeArgument0(String strRep) {
        try {
            if (SingleModuleYinStatementWriter.isArgumentYinElement(this.currentStatement)) {
                this.writeStartXmlElement(this.currentStatement.getArgumentName());
                this.writeXmlText(strRep);
                this.writeXmlEndElement();
            } else {
                this.writeXmlArgument(this.currentStatement.getArgumentName(), strRep);
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isArgumentYinElement(StatementDefinition currentStatement) {
        if (currentStatement instanceof Rfc6020Mapping) {
            return ((Rfc6020Mapping)currentStatement).isArgumentYinElement();
        }
        if (currentStatement instanceof ExtensionStatement) {
            return ((ExtensionStatement)currentStatement).isArgumentYinElement();
        }
        return false;
    }

    private void checkArgumentApplicable() {
        Preconditions.checkState((this.currentStatement != null ? 1 : 0) != 0, (Object)"No statement is opened.");
        Preconditions.checkState((this.currentStatement.getArgumentName() != null ? 1 : 0) != 0, (String)"Statement %s does not take argument.", (Object[])new Object[]{this.currentStatement.getArgumentName()});
    }

    private static String toPrefixedString(@Nullable String prefix, String localName) {
        if (prefix == null || prefix.isEmpty()) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    private String toPrefixedString(QName value) {
        URI valueNs = value.getNamespace();
        String valueLocal = value.getLocalName();
        if (this.currentModuleNs.equals(valueNs)) {
            return valueLocal;
        }
        String prefix = this.ensureAndGetXmlNamespacePrefix(valueNs);
        return SingleModuleYinStatementWriter.toPrefixedString(prefix, valueLocal);
    }

    @Nullable
    private String ensureAndGetXmlNamespacePrefix(URI namespace) {
        if (YangConstants.RFC6020_YANG_NAMESPACE.equals(namespace)) {
            return null;
        }
        String prefix = this.writer.getNamespaceContext().getPrefix(namespace.toString());
        if (prefix == null) {
            prefix = (String)this.prefixToNamespace.inverse().get((Object)namespace);
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Namespace " + namespace + " is not bound to imported prefixes.");
        }
        return prefix;
    }

    private void writeXmlText(String strRep) throws XMLStreamException {
        this.writer.writeCharacters(strRep);
    }

    private void declareXmlNamespaces(Map<String, URI> prefixToNamespace) {
        try {
            this.writer.writeDefaultNamespace(YangConstants.RFC6020_YIN_NAMESPACE.toString());
            for (Map.Entry<String, URI> nsDeclaration : prefixToNamespace.entrySet()) {
                this.writer.writeNamespace(nsDeclaration.getKey(), nsDeclaration.getValue().toString());
            }
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeXmlEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    private void writeXmlArgument(QName qName, String value) throws XMLStreamException {
        this.writer.writeAttribute(qName.getNamespace().toString(), qName.getLocalName(), value);
    }

    private void writeStartXmlElement(QName name) throws XMLStreamException {
        this.writer.writeStartElement(name.getNamespace().toString(), name.getLocalName());
    }
}

