/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.opendaylight.yangtools.yang.common.SimpleDateFormatUtil;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.export.SchemaContextEmitter;
import org.opendaylight.yangtools.yang.model.export.SingleModuleYinStatementWriter;
import org.opendaylight.yangtools.yang.model.export.StatementTextWriter;

public final class YinExportUtils {
    private YinExportUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String wellFormedYinName(String name, Date revision) {
        return YinExportUtils.wellFormedYinName(name, SimpleDateFormatUtil.getRevisionFormat().format(revision));
    }

    public static String wellFormedYinName(String name, String revision) {
        return String.format("%s@%s.yin", Preconditions.checkNotNull((Object)name), Preconditions.checkNotNull((Object)revision));
    }

    public static void writeModuleToOutputStream(SchemaContext ctx, Module module, OutputStream str) throws XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        XMLStreamWriter xmlStreamWriter = factory.createXMLStreamWriter(str);
        YinExportUtils.writeModuleToOutputStream(ctx, module, xmlStreamWriter);
    }

    private static void writeModuleToOutputStream(SchemaContext ctx, Module module, XMLStreamWriter xmlStreamWriter) {
        URI moduleNs = module.getNamespace();
        Map<String, URI> prefixToNs = YinExportUtils.prefixToNamespace(ctx, module);
        StatementTextWriter yinWriter = SingleModuleYinStatementWriter.create(xmlStreamWriter, moduleNs, prefixToNs);
        SchemaContextEmitter.writeToStatementWriter(module, ctx, yinWriter);
    }

    private static Map<String, URI> prefixToNamespace(SchemaContext ctx, Module module) {
        HashBiMap prefixMap = HashBiMap.create((int)(module.getImports().size() + 1));
        prefixMap.put((Object)module.getPrefix(), (Object)module.getNamespace());
        for (ModuleImport imp : module.getImports()) {
            String prefix = imp.getPrefix();
            URI namespace = YinExportUtils.getModuleNamespace(ctx, imp.getModuleName());
            prefixMap.put((Object)prefix, (Object)namespace);
        }
        return prefixMap;
    }

    private static URI getModuleNamespace(SchemaContext ctx, String moduleName) {
        for (Module module : ctx.getModules()) {
            if (!moduleName.equals(module.getName())) continue;
            return module.getNamespace();
        }
        throw new IllegalArgumentException("Module " + moduleName + "does not exists in provided schema context");
    }
}

