/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.export;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

final class ExtensionStatement
implements StatementDefinition {
    private QName argumentName;
    private QName statementName;
    private boolean yinElement;

    private ExtensionStatement(ExtensionDefinition def) {
        this.statementName = def.getQName();
        this.argumentName = def.getArgument() != null ? QName.create((QName)this.statementName, (String)def.getArgument()) : null;
        this.yinElement = def.isYinElement();
    }

    static StatementDefinition from(ExtensionDefinition def) {
        return new ExtensionStatement(def);
    }

    static Map<QName, StatementDefinition> mapFrom(Collection<ExtensionDefinition> definitions) {
        HashMap<QName, StatementDefinition> ret = new HashMap<QName, StatementDefinition>(definitions.size());
        for (ExtensionDefinition def : definitions) {
            StatementDefinition value = ExtensionStatement.from(def);
            ret.put(value.getStatementName(), value);
        }
        return ret;
    }

    public QName getArgumentName() {
        return this.argumentName;
    }

    public QName getStatementName() {
        return this.statementName;
    }

    public boolean isArgumentYinElement() {
        return this.yinElement;
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        throw new UnsupportedOperationException("Not defined");
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        throw new UnsupportedOperationException("Not defined");
    }
}

