/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Deque;
import java.util.LinkedList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.AttributesContainer;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OperationStack {
    private static final Logger logger = LoggerFactory.getLogger(OperationStack.class);
    private static final QName OPERATION_NAME = new QName(URI.create("urn:ietf:params:xml:ns:netconf:base:1.0"), "operation");
    private final Deque<ModifyAction> operations = new LinkedList<ModifyAction>();

    public OperationStack(ModifyAction operation) {
        this.operations.add(operation);
    }

    public void enteringNode(Optional<? extends NormalizedNode<?, ?>> modificationNode) {
        if (!modificationNode.isPresent()) {
            return;
        }
        NormalizedNode modification = (NormalizedNode)modificationNode.get();
        this.enteringNode(modification);
    }

    public void enteringNode(NormalizedNode<?, ?> modificationNode) {
        ModifyAction operation = this.getOperation(modificationNode);
        if (operation == null) {
            return;
        }
        this.addOperation(operation);
    }

    private ModifyAction getOperation(NormalizedNode<?, ?> modificationNode) {
        if (!(modificationNode instanceof AttributesContainer)) {
            return null;
        }
        String operationString = (String)((AttributesContainer)modificationNode).getAttributes().get(OPERATION_NAME);
        return operationString == null ? null : ModifyAction.fromXmlValue((String)operationString);
    }

    private void addOperation(ModifyAction operation) {
        this.operations.add(operation);
        logger.trace("Operation added {}, {}", (Object)operation, (Object)this);
    }

    public ModifyAction getCurrentOperation() {
        return this.operations.getLast();
    }

    public void exitingNode(Optional<? extends NormalizedNode<?, ?>> modificationNode) {
        if (!modificationNode.isPresent()) {
            return;
        }
        NormalizedNode modification = (NormalizedNode)modificationNode.get();
        this.exitingNode(modification);
    }

    public void exitingNode(NormalizedNode<?, ?> modification) {
        ModifyAction operation = this.getOperation(modification);
        if (operation == null) {
            return;
        }
        Preconditions.checkState((this.operations.size() > 1 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.operations.peekLast().equals((Object)operation), (String)"Operations mismatch %s, %s", (Object[])new Object[]{this.operations.peekLast(), operation});
        ModifyAction removed = this.operations.removeLast();
        logger.trace("Operation removed {}, {}", (Object)removed, (Object)this);
    }

    public String toString() {
        return this.operations.toString();
    }
}

