/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.ListNodeBuilder;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.Modification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;

final class LeafSetNodeModification
implements Modification<LeafListSchemaNode, LeafSetNode<?>> {
    LeafSetNodeModification() {
    }

    @Override
    public Optional<LeafSetNode<?>> modify(LeafListSchemaNode schema, Optional<LeafSetNode<?>> actual, Optional<LeafSetNode<?>> modification, OperationStack operationStack) throws DataModificationException {
        ArrayList resultNodes = Lists.newArrayList();
        if (actual.isPresent()) {
            Iterables.addAll((Collection)resultNodes, (Iterable)((LeafSetNode)actual.get()).getValue());
        }
        for (LeafSetEntryNode leafListModification : ((LeafSetNode)modification.get()).getValue()) {
            operationStack.enteringNode((NormalizedNode<?, ?>)leafListModification);
            switch (operationStack.getCurrentOperation()) {
                case MERGE: 
                case CREATE: {
                    DataModificationException.DataExistsException.check(schema.getQName(), actual, leafListModification);
                }
                case REPLACE: {
                    if (LeafSetNodeModification.contains(actual, leafListModification)) break;
                    resultNodes.add(leafListModification);
                    break;
                }
                case DELETE: {
                    DataModificationException.DataMissingException.check(schema.getQName(), actual, leafListModification);
                }
                case REMOVE: {
                    if (!resultNodes.contains(leafListModification)) break;
                    resultNodes.remove(leafListModification);
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unable to perform operation: %s on: %s, unknown", operationStack.getCurrentOperation(), schema));
                }
            }
            operationStack.exitingNode((NormalizedNode<?, ?>)leafListModification);
        }
        return this.build(schema, resultNodes);
    }

    private Optional<LeafSetNode<?>> build(LeafListSchemaNode schemaNode, List<LeafSetEntryNode<?>> resultNodes) {
        if (resultNodes.isEmpty()) {
            return Optional.absent();
        }
        ListNodeBuilder b = Builders.leafSetBuilder((LeafListSchemaNode)schemaNode);
        Iterator<LeafSetEntryNode<?>> i$ = resultNodes.iterator();
        while (i$.hasNext()) {
            LeafSetEntryNode<?> resultNode;
            LeafSetEntryNode<?> child = resultNode = i$.next();
            b.withChild(child);
        }
        return Optional.of((Object)b.build());
    }

    private static boolean contains(Optional<LeafSetNode<?>> actual, LeafSetEntryNode<?> leafListModification) {
        boolean contains = actual.isPresent();
        return contains &= ((LeafSetNode)actual.get()).getChild((YangInstanceIdentifier.PathArgument)leafListModification.getIdentifier()).isPresent();
    }
}

