/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class DataModificationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final QName node;

    public DataModificationException(String message, QName node) {
        super(message);
        this.node = node;
    }

    public QName getNodeQName() {
        return this.node;
    }

    public static final class IllegalChoiceValuesException
    extends DataModificationException {
        private static final long serialVersionUID = 1L;

        public IllegalChoiceValuesException(String message, QName node) {
            super(message, node);
        }

        public static void throwMultipleCasesReferenced(QName choiceQName, ChoiceNode modification, QName case1QName, QName case2QName) throws IllegalChoiceValuesException {
            throw new IllegalChoiceValuesException(String.format("Child nodes from multiple cases present in modification: %s, choice: %s, case1: %s, case2: %s", modification, choiceQName, case1QName, case2QName), choiceQName);
        }

        public static void throwUnknownChild(QName choiceQName, QName nodeQName) throws IllegalChoiceValuesException {
            throw new IllegalChoiceValuesException(String.format("Unknown child node detected, choice: %s, child node: %s", choiceQName, nodeQName), choiceQName);
        }
    }

    public static final class DataExistsException
    extends DataModificationException {
        private static final long serialVersionUID = 1L;

        public DataExistsException(QName nodeType, NormalizedNode<?, ?> actualNode, NormalizedNode<?, ?> modificationNode) {
            super(String.format("Data already exists for node: %s, current value: %s. modification value: %s", nodeType, actualNode, modificationNode), nodeType);
        }

        static void check(QName nodeQName, Optional<? extends NormalizedNode<?, ?>> actualNode, NormalizedNode<?, ?> modificationNode) throws DataExistsException {
            if (actualNode.isPresent()) {
                throw new DataExistsException(nodeQName, (NormalizedNode)actualNode.get(), modificationNode);
            }
        }

        static void check(QName nodeQName, Optional<LeafSetNode<?>> actualNodes, LeafSetEntryNode<?> modificationNode) throws DataExistsException {
            if (actualNodes.isPresent() && ((LeafSetNode)actualNodes.get()).getChild((YangInstanceIdentifier.PathArgument)modificationNode.getIdentifier()).isPresent()) {
                throw new DataExistsException(nodeQName, (NormalizedNode<?, ?>)((NormalizedNode)actualNodes.get()), (NormalizedNode<?, ?>)modificationNode);
            }
        }

        public static void check(QName qName, Optional<MapNode> actualNodes, MapEntryNode listModification) throws DataModificationException {
            if (actualNodes.isPresent() && ((MapNode)actualNodes.get()).getChild((YangInstanceIdentifier.PathArgument)listModification.getIdentifier()).isPresent()) {
                throw new DataExistsException(qName, (NormalizedNode<?, ?>)((NormalizedNode)actualNodes.get()), (NormalizedNode<?, ?>)listModification);
            }
        }
    }

    public static final class DataMissingException
    extends DataModificationException {
        private static final long serialVersionUID = 1L;

        public DataMissingException(QName nodeType) {
            super(String.format("Data missing for node: %s", nodeType), nodeType);
        }

        public DataMissingException(QName nodeType, Node<?> modificationNode) {
            super(String.format("Data missing for node: %s, %s", nodeType, modificationNode), nodeType);
        }

        public DataMissingException(QName nodeType, NormalizedNode<?, ?> modificationNode) {
            super(String.format("Data missing for node: %s, %s", nodeType, modificationNode), nodeType);
        }

        static void check(QName nodeQName, Optional<? extends NormalizedNode<?, ?>> actualNode) throws DataMissingException {
            if (!actualNode.isPresent()) {
                throw new DataMissingException(nodeQName);
            }
        }

        static void check(QName nodeQName, Optional<LeafSetNode<?>> actualNodes, LeafSetEntryNode<?> modificationNode) throws DataMissingException {
            if (!actualNodes.isPresent() || !((LeafSetNode)actualNodes.get()).getChild((YangInstanceIdentifier.PathArgument)modificationNode.getIdentifier()).isPresent()) {
                throw new DataMissingException(nodeQName, (NormalizedNode<?, ?>)modificationNode);
            }
        }

        static void check(QName nodeQName, Optional<MapNode> actualNodes, MapEntryNode modificationNode) throws DataModificationException {
            if (!actualNodes.isPresent() || !((MapNode)actualNodes.get()).getChild((YangInstanceIdentifier.PathArgument)modificationNode.getIdentifier()).isPresent()) {
                throw new DataMissingException(nodeQName, (NormalizedNode<?, ?>)modificationNode);
            }
        }
    }
}

