/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.operations.AugmentationNodeModification;
import org.opendaylight.yangtools.yang.data.operations.ChoiceNodeModification;
import org.opendaylight.yangtools.yang.data.operations.ContainerNodeModification;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.LeafNodeModification;
import org.opendaylight.yangtools.yang.data.operations.LeafSetNodeModification;
import org.opendaylight.yangtools.yang.data.operations.MapNodeModification;
import org.opendaylight.yangtools.yang.data.operations.Modification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.data.operations.UnkeyedListNodeModification;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

abstract class AbstractContainerNodeModification<S, N extends DataContainerNode<?>>
implements Modification<S, N> {
    AbstractContainerNodeModification() {
    }

    @Override
    public final Optional<N> modify(S schema, Optional<N> actual, Optional<N> modification, OperationStack operationStack) throws DataModificationException {
        Optional<N> result;
        operationStack.enteringNode(modification);
        QName nodeQName = this.getQName(schema);
        switch (operationStack.getCurrentOperation()) {
            case DELETE: {
                DataModificationException.DataMissingException.check(nodeQName, actual);
            }
            case REMOVE: {
                result = Optional.absent();
                break;
            }
            case CREATE: {
                DataModificationException.DataExistsException.check(nodeQName, actual, null);
            }
            case REPLACE: {
                result = modification;
                break;
            }
            case NONE: {
                DataModificationException.DataMissingException.check(nodeQName, actual);
            }
            case MERGE: {
                result = this.modifyContainer(schema, actual, modification, operationStack);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to perform operation: %s on: %s, unknown", operationStack.getCurrentOperation(), schema));
            }
        }
        operationStack.exitingNode(modification);
        return result;
    }

    protected abstract QName getQName(S var1);

    private Optional<N> modifyContainer(S schema, Optional<N> actual, Optional<N> modification, OperationStack operationStack) throws DataModificationException {
        if (!actual.isPresent()) {
            return modification;
        }
        if (!modification.isPresent()) {
            return actual;
        }
        Set<YangInstanceIdentifier.PathArgument> toProcess = this.getChildrenToProcess(schema, actual, modification);
        List<DataContainerChild<?, ?>> merged = this.modifyContainerChildNodes(schema, operationStack, (DataContainerNode)actual.get(), (DataContainerNode)modification.get(), toProcess);
        return this.build(schema, merged);
    }

    private List<? extends DataContainerChild<?, ?>> modifyContainerChildNodes(S schema, OperationStack operationStack, N actual, N modification, Set<YangInstanceIdentifier.PathArgument> toProcess) throws DataModificationException {
        ArrayList result = Lists.newArrayList();
        for (YangInstanceIdentifier.PathArgument childToProcessId : toProcess) {
            Object schemaOfChildToProcess;
            Optional<DataContainerChild<?, ?>> modifiedValues = this.modifyContainerNode(operationStack, actual, modification, childToProcessId, schemaOfChildToProcess = this.findSchema(schema, childToProcessId));
            if (!modifiedValues.isPresent()) continue;
            result.add(modifiedValues.get());
        }
        return result;
    }

    private Optional<? extends DataContainerChild<?, ?>> modifyContainerNode(OperationStack operationStack, N actual, N modification, YangInstanceIdentifier.PathArgument childToProcess, Object schemaChild) throws DataModificationException {
        Optional storedChildren = actual.getChild(childToProcess);
        Optional modifiedChildren = modification.getChild(childToProcess);
        return NodeDispatcher.dispatchChildModification(schemaChild, storedChildren, modifiedChildren, operationStack);
    }

    private Object findSchema(S schema, YangInstanceIdentifier.PathArgument childToProcessId) {
        if (childToProcessId instanceof YangInstanceIdentifier.AugmentationIdentifier) {
            return this.findSchemaForAugment(schema, (YangInstanceIdentifier.AugmentationIdentifier)childToProcessId);
        }
        return this.findSchemaForChild(schema, childToProcessId.getNodeType());
    }

    protected abstract Object findSchemaForChild(S var1, QName var2);

    protected abstract Object findSchemaForAugment(S var1, YangInstanceIdentifier.AugmentationIdentifier var2);

    private Optional<N> build(S schema, List<? extends DataContainerChild<?, ?>> result) {
        DataContainerNodeBuilder<?, N> b = this.getBuilder(schema);
        for (DataContainerChild<?, ?> dataContainerChild : result) {
            b.withChild(dataContainerChild);
        }
        return Optional.of((Object)b.build());
    }

    protected abstract DataContainerNodeBuilder<?, N> getBuilder(S var1);

    protected Set<YangInstanceIdentifier.PathArgument> getChildrenToProcess(S schema, Optional<N> actual, Optional<N> modification) throws DataModificationException {
        LinkedHashSet qNames = Sets.newLinkedHashSet();
        qNames.addAll(this.getChildQNames(actual));
        qNames.addAll(this.getChildQNames(modification));
        return qNames;
    }

    private Set<? extends YangInstanceIdentifier.PathArgument> getChildQNames(Optional<N> actual) {
        LinkedHashSet qNames = Sets.newLinkedHashSet();
        for (DataContainerChild child : ((DataContainerNode)actual.get()).getValue()) {
            qNames.add(child.getIdentifier());
        }
        return qNames;
    }

    private static final class NodeDispatcher {
        private static final LeafNodeModification LEAF_NODE_MODIFICATION = new LeafNodeModification();
        private static final LeafSetNodeModification LEAF_SET_NODE_MODIFICATION = new LeafSetNodeModification();
        private static final AugmentationNodeModification AUGMENTATION_NODE_MODIFICATION = new AugmentationNodeModification();
        private static final MapNodeModification MAP_NODE_MODIFICATION = new MapNodeModification();
        private static final UnkeyedListNodeModification UNKEYED_LIST_NODE_MODIFICATION = new UnkeyedListNodeModification();
        private static final ContainerNodeModification CONTAINER_NODE_MODIFICATION = new ContainerNodeModification();
        private static final ChoiceNodeModification CHOICE_NODE_MODIFICATION = new ChoiceNodeModification();

        private NodeDispatcher() {
        }

        static Optional<? extends DataContainerChild<?, ?>> dispatchChildModification(Object schemaChild, Optional<DataContainerChild<?, ?>> actual, Optional<DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            if (schemaChild instanceof LeafSchemaNode) {
                return NodeDispatcher.onLeafNode((LeafSchemaNode)schemaChild, actual, modification, operations);
            }
            if (schemaChild instanceof ContainerSchemaNode) {
                return NodeDispatcher.onContainerNode((ContainerSchemaNode)schemaChild, actual, modification, operations);
            }
            if (schemaChild instanceof LeafListSchemaNode) {
                return NodeDispatcher.onLeafSetNode((LeafListSchemaNode)schemaChild, actual, modification, operations);
            }
            if (schemaChild instanceof AugmentationSchema) {
                return NodeDispatcher.onAugmentationNode((AugmentationSchema)schemaChild, actual, modification, operations);
            }
            if (schemaChild instanceof ListSchemaNode) {
                if (((ListSchemaNode)schemaChild).getKeyDefinition().isEmpty()) {
                    return NodeDispatcher.onUnkeyedNode((ListSchemaNode)schemaChild, actual, modification, operations);
                }
                return NodeDispatcher.onMapNode((ListSchemaNode)schemaChild, actual, modification, operations);
            }
            if (schemaChild instanceof ChoiceNode) {
                return NodeDispatcher.onChoiceNode((ChoiceNode)schemaChild, actual, modification, operations);
            }
            throw new IllegalArgumentException("Unknown schema node type " + schemaChild);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onChoiceNode(ChoiceNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode.class);
            NodeDispatcher.checkType(modification, org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode.class);
            return CHOICE_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onMapNode(ListSchemaNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, MapNode.class);
            NodeDispatcher.checkType(modification, MapNode.class);
            return MAP_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onUnkeyedNode(ListSchemaNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, UnkeyedListNode.class);
            NodeDispatcher.checkType(modification, UnkeyedListNode.class);
            return UNKEYED_LIST_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onAugmentationNode(AugmentationSchema schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, AugmentationNode.class);
            NodeDispatcher.checkType(modification, AugmentationNode.class);
            return AUGMENTATION_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onLeafSetNode(LeafListSchemaNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, LeafSetNode.class);
            NodeDispatcher.checkType(modification, LeafSetNode.class);
            return LEAF_SET_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onContainerNode(ContainerSchemaNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, ContainerNode.class);
            NodeDispatcher.checkType(modification, ContainerNode.class);
            return CONTAINER_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static Optional<? extends DataContainerChild<?, ?>> onLeafNode(LeafSchemaNode schemaChild, Optional<? extends DataContainerChild<?, ?>> actual, Optional<? extends DataContainerChild<?, ?>> modification, OperationStack operations) throws DataModificationException {
            NodeDispatcher.checkType(actual, LeafNode.class);
            NodeDispatcher.checkType(modification, LeafNode.class);
            return LEAF_NODE_MODIFICATION.modify(schemaChild, actual, modification, operations);
        }

        private static void checkType(Optional<? extends DataContainerChild<?, ?>> actual, Class<?> leafNodeClass) {
            if (actual.isPresent()) {
                Preconditions.checkArgument((boolean)leafNodeClass.isAssignableFrom(((DataContainerChild)actual.get()).getClass()), (String)"Unexpected node type, should be: %s, but was: %s, for: %s", (Object[])new Object[]{leafNodeClass, actual.getClass(), actual});
            }
        }
    }
}

