/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.MapEntryNodeModification;
import org.opendaylight.yangtools.yang.data.operations.Modification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class UnkeyedListNodeModification
implements Modification<ListSchemaNode, UnkeyedListNode> {
    public static final MapEntryNodeModification MAP_ENTRY_NODE_MODIFICATION = new MapEntryNodeModification();

    @Override
    public Optional<UnkeyedListNode> modify(ListSchemaNode schema, Optional<UnkeyedListNode> actual, Optional<UnkeyedListNode> modification, OperationStack operationStack) throws DataModificationException {
        if (!modification.isPresent()) {
            return actual;
        }
        List<Object> resultNodes = Lists.newArrayList();
        if (actual.isPresent()) {
            resultNodes = this.unkeyedListEntries((UnkeyedListNode)actual.get());
        }
        for (UnkeyedListEntryNode unkeyedListEntryModification : (Iterable)((UnkeyedListNode)modification.get()).getValue()) {
            operationStack.enteringNode((NormalizedNode<?, ?>)unkeyedListEntryModification);
            YangInstanceIdentifier.NodeIdentifier entryKey = (YangInstanceIdentifier.NodeIdentifier)unkeyedListEntryModification.getIdentifier();
            switch (operationStack.getCurrentOperation()) {
                case NONE: {
                    break;
                }
                case MERGE: 
                case CREATE: {
                    DataModificationException.DataExistsException.check(schema.getQName(), actual, unkeyedListEntryModification);
                    resultNodes.add(unkeyedListEntryModification);
                }
                case REPLACE: {
                    break;
                }
                case DELETE: {
                    break;
                }
                case REMOVE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unable to perform operation: %s on: %s, unknown", operationStack.getCurrentOperation(), schema));
                }
            }
            operationStack.exitingNode((NormalizedNode<?, ?>)unkeyedListEntryModification);
        }
        return this.build(schema, (List<UnkeyedListEntryNode>)resultNodes);
    }

    private Optional<UnkeyedListNode> build(ListSchemaNode schema, List<UnkeyedListEntryNode> resultNodes) {
        if (resultNodes.isEmpty()) {
            return Optional.absent();
        }
        CollectionNodeBuilder b = Builders.unkeyedListBuilder();
        b.withNodeIdentifier(new YangInstanceIdentifier.NodeIdentifier(schema.getQName()));
        for (UnkeyedListEntryNode child : resultNodes) {
            b.withChild((NormalizedNode)child);
        }
        return Optional.of((Object)b.build());
    }

    private List<UnkeyedListEntryNode> unkeyedListEntries(UnkeyedListNode unkeyedListNode) {
        ArrayList unkeyedListEntries = Lists.newArrayList();
        for (UnkeyedListEntryNode unkeyedListEntryNode : (Iterable)unkeyedListNode.getValue()) {
            unkeyedListEntries.add(unkeyedListEntryNode);
        }
        return unkeyedListEntries;
    }
}

