/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.Modification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;

final class LeafNodeModification
implements Modification<LeafSchemaNode, LeafNode<?>> {
    LeafNodeModification() {
    }

    @Override
    public Optional<LeafNode<?>> modify(LeafSchemaNode schema, Optional<LeafNode<?>> actualNode, Optional<LeafNode<?>> modificationNode, OperationStack operationStack) throws DataModificationException {
        Optional<LeafNode<?>> result;
        operationStack.enteringNode(modificationNode);
        switch (operationStack.getCurrentOperation()) {
            case MERGE: {
                result = modificationNode.isPresent() ? modificationNode : actualNode;
                break;
            }
            case CREATE: {
                DataModificationException.DataExistsException.check(schema.getQName(), actualNode, null);
            }
            case REPLACE: {
                result = modificationNode;
                break;
            }
            case DELETE: {
                DataModificationException.DataMissingException.check(schema.getQName(), actualNode);
            }
            case REMOVE: {
                result = Optional.absent();
                break;
            }
            case NONE: {
                result = actualNode;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to perform operation: %s on: %s, unknown", operationStack.getCurrentOperation(), schema));
            }
        }
        operationStack.exitingNode(modificationNode);
        return result;
    }
}

