/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import org.opendaylight.yangtools.yang.data.api.ModifyAction;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.operations.ContainerNodeModification;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.MapNodeModification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class DataOperations {
    private DataOperations() {
    }

    public static Optional<ContainerNode> modify(ContainerSchemaNode schema, ContainerNode stored, ContainerNode modified) throws DataModificationException {
        return DataOperations.modify(schema, stored, modified, ModifyAction.MERGE);
    }

    public static Optional<MapNode> modify(ListSchemaNode schema, MapNode stored, MapNode modified) throws DataModificationException {
        return DataOperations.modify(schema, stored, modified, ModifyAction.MERGE);
    }

    public static Optional<ContainerNode> modify(ContainerSchemaNode schema, ContainerNode stored, ContainerNode modified, ModifyAction defaultOperation) throws DataModificationException {
        OperationStack operations = new OperationStack(defaultOperation);
        return new ContainerNodeModification().modify(schema, Optional.fromNullable((Object)stored), Optional.fromNullable((Object)modified), operations);
    }

    public static Optional<MapNode> modify(ListSchemaNode schema, MapNode stored, MapNode modified, ModifyAction defaultOperation) throws DataModificationException {
        OperationStack operations = new OperationStack(defaultOperation);
        return new MapNodeModification().modify(schema, (Optional<MapNode>)Optional.fromNullable((Object)stored), (Optional<MapNode>)Optional.fromNullable((Object)modified), operations);
    }
}

