/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.SchemaUtils;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.operations.AbstractContainerNodeModification;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;

final class ChoiceNodeModification
extends AbstractContainerNodeModification<ChoiceNode, org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode> {
    ChoiceNodeModification() {
    }

    @Override
    protected QName getQName(ChoiceNode schema) {
        return schema.getQName();
    }

    @Override
    protected Object findSchemaForChild(ChoiceNode schema, QName nodeType) {
        return SchemaUtils.findSchemaForChild((ChoiceNode)schema, (QName)nodeType);
    }

    @Override
    protected Set<YangInstanceIdentifier.PathArgument> getChildrenToProcess(ChoiceNode schema, Optional<org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode> actual, Optional<org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode> modification) throws DataModificationException {
        Set<YangInstanceIdentifier.PathArgument> childrenToProcess = super.getChildrenToProcess(schema, actual, modification);
        if (!modification.isPresent()) {
            return childrenToProcess;
        }
        Object detectedCase = null;
        for (DataContainerChild child : ((org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode)modification.get()).getValue()) {
            Optional detectedCaseForChild = SchemaUtils.detectCase((ChoiceNode)schema, (DataContainerChild)child);
            if (!detectedCaseForChild.isPresent()) {
                DataModificationException.IllegalChoiceValuesException.throwUnknownChild(schema.getQName(), child.getNodeType());
            }
            if (detectedCase != null && !detectedCase.equals(detectedCaseForChild.get())) {
                DataModificationException.IllegalChoiceValuesException.throwMultipleCasesReferenced(schema.getQName(), (org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode)modification.get(), detectedCase.getQName(), ((ChoiceCaseNode)detectedCaseForChild.get()).getQName());
            }
            detectedCase = (ChoiceCaseNode)detectedCaseForChild.get();
        }
        if (detectedCase == null) {
            return childrenToProcess;
        }
        LinkedHashSet childrenToProcessFiltered = Sets.newLinkedHashSet();
        for (YangInstanceIdentifier.PathArgument childToProcess : childrenToProcess) {
            if (childToProcess instanceof YangInstanceIdentifier.AugmentationIdentifier && !SchemaUtils.belongsToCaseAugment((ChoiceCaseNode)detectedCase, (YangInstanceIdentifier.AugmentationIdentifier)((YangInstanceIdentifier.AugmentationIdentifier)childToProcess)) || !this.belongsToCase((ChoiceCaseNode)detectedCase, childToProcess)) continue;
            childrenToProcessFiltered.add(childToProcess);
        }
        return childrenToProcessFiltered;
    }

    private boolean belongsToCase(ChoiceCaseNode detectedCase, YangInstanceIdentifier.PathArgument childToProcess) {
        return detectedCase.getDataChildByName(childToProcess.getNodeType()) != null;
    }

    @Override
    protected Object findSchemaForAugment(ChoiceNode schema, YangInstanceIdentifier.AugmentationIdentifier childToProcessId) {
        return SchemaUtils.findSchemaForAugment((ChoiceNode)schema, (Set)childToProcessId.getPossibleChildNames());
    }

    @Override
    protected DataContainerNodeBuilder<?, org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode> getBuilder(ChoiceNode schema) {
        return Builders.choiceBuilder((ChoiceNode)schema);
    }
}

