/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.operations;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.operations.DataModificationException;
import org.opendaylight.yangtools.yang.data.operations.MapEntryNodeModification;
import org.opendaylight.yangtools.yang.data.operations.Modification;
import org.opendaylight.yangtools.yang.data.operations.OperationStack;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class MapNodeModification
implements Modification<ListSchemaNode, MapNode> {
    public static final MapEntryNodeModification MAP_ENTRY_NODE_MODIFICATION = new MapEntryNodeModification();

    @Override
    public Optional<MapNode> modify(ListSchemaNode schema, Optional<MapNode> actual, Optional<MapNode> modification, OperationStack operationStack) throws DataModificationException {
        if (!modification.isPresent()) {
            return actual;
        }
        LinkedHashMap resultNodes = Maps.newLinkedHashMap();
        if (actual.isPresent()) {
            resultNodes.putAll(this.mapEntries((MapNode)actual.get()));
        }
        for (MapEntryNode mapEntryModification : ((MapNode)modification.get()).getValue()) {
            operationStack.enteringNode((NormalizedNode<?, ?>)mapEntryModification);
            YangInstanceIdentifier.NodeIdentifierWithPredicates entryKey = mapEntryModification.getIdentifier();
            switch (operationStack.getCurrentOperation()) {
                case NONE: {
                    DataModificationException.DataMissingException.check(schema.getQName(), actual, mapEntryModification);
                }
                case MERGE: {
                    MapEntryNode mergedListNode;
                    if (resultNodes.containsKey(entryKey)) {
                        MapEntryNode actualEntry = (MapEntryNode)resultNodes.get(entryKey);
                        mergedListNode = (MapEntryNode)MAP_ENTRY_NODE_MODIFICATION.modify(schema, Optional.of((Object)actualEntry), Optional.of((Object)mapEntryModification), operationStack).get();
                    } else {
                        mergedListNode = mapEntryModification;
                    }
                    resultNodes.put(mergedListNode.getIdentifier(), mergedListNode);
                    break;
                }
                case CREATE: {
                    DataModificationException.DataExistsException.check(schema.getQName(), actual, mapEntryModification);
                }
                case REPLACE: {
                    resultNodes.put(entryKey, mapEntryModification);
                    break;
                }
                case DELETE: {
                    DataModificationException.DataMissingException.check(schema.getQName(), actual, mapEntryModification);
                }
                case REMOVE: {
                    if (!resultNodes.containsKey(entryKey)) break;
                    resultNodes.remove(entryKey);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unable to perform operation: %s on: %s, unknown", operationStack.getCurrentOperation(), schema));
                }
            }
            operationStack.exitingNode((NormalizedNode<?, ?>)mapEntryModification);
        }
        return this.build(schema, resultNodes);
    }

    private Optional<MapNode> build(ListSchemaNode schema, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> resultNodes) {
        if (resultNodes.isEmpty()) {
            return Optional.absent();
        }
        CollectionNodeBuilder b = Builders.mapBuilder((ListSchemaNode)schema);
        for (MapEntryNode child : resultNodes.values()) {
            b.withChild((NormalizedNode)child);
        }
        return Optional.of((Object)b.build());
    }

    private Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> mapEntries(MapNode mapNode) {
        LinkedHashMap mapped = Maps.newLinkedHashMap();
        for (MapEntryNode mapEntryNode : mapNode.getValue()) {
            mapped.put(mapEntryNode.getIdentifier(), mapEntryNode);
        }
        return mapped;
    }
}

