/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.client.filter.HTTPDigestAuthFilter;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.yangtools.restconf.client.ConfigurationDataStoreImpl;
import org.opendaylight.yangtools.restconf.client.OperationalDataStoreImpl;
import org.opendaylight.yangtools.restconf.client.RestListenableEventStreamContext;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.auth.AuthenticationHolder;
import org.opendaylight.yangtools.restconf.client.api.data.ConfigurationDatastore;
import org.opendaylight.yangtools.restconf.client.api.data.OperationalDatastore;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamInfo;
import org.opendaylight.yangtools.restconf.client.api.event.ListenableEventStreamContext;
import org.opendaylight.yangtools.restconf.client.api.rpc.RpcServiceContext;
import org.opendaylight.yangtools.restconf.client.to.RestRpcServiceContext;
import org.opendaylight.yangtools.restconf.common.ResourceUri;
import org.opendaylight.yangtools.restconf.utils.RestconfUtils;
import org.opendaylight.yangtools.restconf.utils.XmlTools;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextHolder;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestconfClientImpl
implements RestconfClientContext,
SchemaContextListener {
    private final URI defaultUri;
    private final Client restClient;
    private final ListeningExecutorService pool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
    private final Logger logger = LoggerFactory.getLogger((String)RestconfClientImpl.class.toString());
    private final SchemaContextHolder schemaContextHolder;
    private final BindingIndependentMappingService mappingService;
    private OperationalDataStoreImpl operationalDatastoreAccessor;
    private ConfigurationDataStoreImpl configurationDatastoreAccessor;

    public RestconfClientImpl(URL url, BindingIndependentMappingService mappingService, SchemaContextHolder schemaContextHolder) {
        Preconditions.checkArgument((url != null ? 1 : 0) != 0, (Object)"Restconf endpoint URL must be supplied.");
        Preconditions.checkArgument((mappingService != null ? 1 : 0) != 0, (Object)"Mapping service must not be null.");
        Preconditions.checkNotNull((Object)schemaContextHolder, (Object)"Schema Context Holder must not be null.");
        DefaultClientConfig config = new DefaultClientConfig();
        this.restClient = Client.create((ClientConfig)config);
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            this.logger.trace("Error in URI syntax {}", (Object)e.getMessage(), (Object)e);
        }
        this.defaultUri = uri;
        this.mappingService = mappingService;
        this.schemaContextHolder = schemaContextHolder;
    }

    protected URI getDefaultUri() {
        return this.defaultUri;
    }

    protected ListeningExecutorService getPool() {
        return this.pool;
    }

    protected SchemaContextHolder getSchemaContextHolder() {
        return this.schemaContextHolder;
    }

    protected BindingIndependentMappingService getMappingService() {
        return this.mappingService;
    }

    public ListenableFuture<Set<Class<? extends RpcService>>> getRpcServices() {
        return this.get(ResourceUri.MODULES.getPath(), "application/xml", new Function<ClientResponse, Set<Class<? extends RpcService>>>(){

            public Set<Class<? extends RpcService>> apply(ClientResponse clientResponse) {
                if (clientResponse.getStatus() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
                }
                return RestconfUtils.rpcServicesFromInputStream((InputStream)clientResponse.getEntityInputStream(), (BindingIndependentMappingService)RestconfClientImpl.this.mappingService, (SchemaContext)RestconfClientImpl.this.schemaContextHolder.getSchemaContext());
            }
        });
    }

    public <T extends RpcService> RpcServiceContext<T> getRpcServiceContext(Class<T> rpcService) {
        return new RestRpcServiceContext<T>(rpcService, this.mappingService, this, this.schemaContextHolder.getSchemaContext());
    }

    public ListenableFuture<Set<EventStreamInfo>> getAvailableEventStreams() {
        return this.get(ResourceUri.STREAM.getPath(), "application/xml", new Function<ClientResponse, Set<EventStreamInfo>>(){

            public Set<EventStreamInfo> apply(ClientResponse clientResponse) {
                if (clientResponse.getStatus() != 200) {
                    throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
                }
                try {
                    return XmlTools.evenStreamsFromInputStream((InputStream)clientResponse.getEntityInputStream());
                }
                catch (Exception e) {
                    RestconfClientImpl.this.logger.trace("Stream discovery failed due to {}", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public ListenableEventStreamContext getEventStreamContext(EventStreamInfo info) {
        return new RestListenableEventStreamContext(info, this);
    }

    public ConfigurationDatastore getConfigurationDatastore() {
        if (this.configurationDatastoreAccessor == null) {
            this.configurationDatastoreAccessor = new ConfigurationDataStoreImpl(this);
        }
        return this.configurationDatastoreAccessor;
    }

    public OperationalDatastore getOperationalDatastore() {
        if (this.operationalDatastoreAccessor == null) {
            this.operationalDatastoreAccessor = new OperationalDataStoreImpl(this);
        }
        return this.operationalDatastoreAccessor;
    }

    public void setAuthenticationHolder(AuthenticationHolder authenticationHolder) {
        if (authenticationHolder.authenticationRequired()) {
            switch (authenticationHolder.getAuthType()) {
                case DIGEST: {
                    this.restClient.addFilter((ClientFilter)new HTTPDigestAuthFilter(authenticationHolder.getUserName(), authenticationHolder.getPassword()));
                    break;
                }
                default: {
                    this.restClient.addFilter((ClientFilter)new HTTPBasicAuthFilter(authenticationHolder.getUserName(), authenticationHolder.getPassword()));
                }
            }
        }
    }

    public void close() {
        this.pool.shutdown();
    }

    public void onGlobalContextUpdated(SchemaContext context) {
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContextHolder.getSchemaContext();
    }

    protected <T> ListenableFuture<T> get(String path, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), RestOperation.GET, processingFunction));
    }

    protected <T> ListenableFuture<T> get(String path, String mediaType, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), mediaType, RestOperation.GET, processingFunction));
    }

    protected <T> ListenableFuture<T> post(String path, String payload, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), payload, RestOperation.POST, processingFunction));
    }

    protected <T> ListenableFuture<T> post(String path, String payload, String mediaType, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), payload, RestOperation.POST, mediaType, processingFunction));
    }

    protected <T> ListenableFuture<T> put(String path, String payload, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), RestOperation.PUT, payload, processingFunction));
    }

    protected <T> ListenableFuture<T> put(String path, String payload, String mediaType, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), payload, RestOperation.PUT, mediaType, processingFunction));
    }

    protected <T> ListenableFuture<T> delete(String path, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), RestOperation.DELETE, processingFunction));
    }

    protected <T> ListenableFuture<T> delete(String path, String mediaType, Function<ClientResponse, T> processingFunction) {
        return this.pool.submit(new ExecuteOperationAndTransformTask<T>(this.constructPath(path), RestOperation.DELETE, mediaType, processingFunction));
    }

    protected String constructPath(String path) {
        return this.getDefaultUri().toString() + path;
    }

    private class ExecuteOperationAndTransformTask<T>
    implements Callable<T> {
        private final Function<ClientResponse, T> transformation;
        private final String path;
        private final String acceptType;
        private final String payload;
        private final RestOperation restOperation;

        public ExecuteOperationAndTransformTask(String path, String payload, RestOperation operation, Function<ClientResponse, T> processingFunction) {
            this.path = path;
            this.transformation = processingFunction;
            this.acceptType = "application/xml";
            this.payload = payload;
            this.restOperation = operation;
        }

        public ExecuteOperationAndTransformTask(String path, String payload, RestOperation operation, String mediaType, Function<ClientResponse, T> processingFunction) {
            this.path = path;
            this.transformation = processingFunction;
            this.acceptType = mediaType;
            this.payload = payload;
            this.restOperation = operation;
        }

        public ExecuteOperationAndTransformTask(String path, RestOperation operation, String mediaType, Function<ClientResponse, T> processingFunction) {
            this.path = path;
            this.transformation = processingFunction;
            this.acceptType = mediaType;
            this.payload = null;
            this.restOperation = operation;
        }

        public ExecuteOperationAndTransformTask(String path, RestOperation operation, Function<ClientResponse, T> processingFunction) {
            this.path = path;
            this.transformation = processingFunction;
            this.acceptType = "application/xml";
            this.payload = null;
            this.restOperation = operation;
        }

        @Override
        public T call() {
            ClientResponse response = null;
            try {
                WebResource resource = RestconfClientImpl.this.restClient.resource(this.path);
                switch (this.restOperation) {
                    case PUT: {
                        response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{this.acceptType})).put(ClientResponse.class, (Object)this.payload);
                        break;
                    }
                    case POST: {
                        response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{this.acceptType})).post(ClientResponse.class, (Object)this.payload);
                        break;
                    }
                    case GET: {
                        response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{this.acceptType})).get(ClientResponse.class);
                        break;
                    }
                    case DELETE: {
                        response = (ClientResponse)((WebResource.Builder)resource.type("application/xml").accept(new String[]{this.acceptType})).delete(ClientResponse.class);
                    }
                }
            }
            catch (Exception e) {
                RestconfClientImpl.this.logger.trace("Exception occured while posting data to client {}", (Throwable)e);
            }
            return (T)this.transformation.apply(response);
        }
    }

    private static enum RestOperation {
        PUT,
        POST,
        GET,
        DELETE;

    }
}

