/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import java.net.URL;
import org.opendaylight.yangtools.restconf.client.RestconfClientImpl;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContext;
import org.opendaylight.yangtools.restconf.client.api.RestconfClientContextFactory;
import org.opendaylight.yangtools.restconf.client.api.UnsupportedProtocolException;
import org.opendaylight.yangtools.restconf.client.api.auth.AuthenticationHolder;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.model.api.SchemaContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestconfClientFactory
implements RestconfClientContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(RestconfClientFactory.class);
    private AuthenticationHolder authenticationHolder;

    public RestconfClientContext getRestconfClientContext(URL baseUrl, BindingIndependentMappingService mappingService, SchemaContextHolder schemaContextHolder) throws UnsupportedProtocolException {
        if (!baseUrl.getProtocol().equals("http")) {
            throw new UnsupportedProtocolException("Unsupported protocol " + baseUrl.getProtocol());
        }
        RestconfClientImpl restconfClient = new RestconfClientImpl(baseUrl, mappingService, schemaContextHolder);
        if (null != this.authenticationHolder) {
            restconfClient.setAuthenticationHolder(this.authenticationHolder);
        }
        return restconfClient;
    }

    public void setAuthentication(AuthenticationHolder authenticationHolder) {
        this.authenticationHolder = authenticationHolder;
    }
}

