/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sun.jersey.api.client.ClientResponse;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.restconf.client.RestconfClientImpl;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamInfo;
import org.opendaylight.yangtools.restconf.client.api.event.EventStreamReplay;
import org.opendaylight.yangtools.restconf.client.api.event.ListenableEventStreamContext;
import org.opendaylight.yangtools.restconf.client.to.RestRpcResult;
import org.opendaylight.yangtools.restconf.common.ResourceUri;
import org.opendaylight.yangtools.websocket.client.WebSocketIClient;
import org.opendaylight.yangtools.websocket.client.callback.ClientMessageCallback;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestListenableEventStreamContext<L extends NotificationListener>
implements ListenableEventStreamContext,
ClientMessageCallback {
    private static final Logger logger = LoggerFactory.getLogger((String)RestListenableEventStreamContext.class.toString());
    private final ListeningExecutorService pool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
    private WebSocketIClient wsClient;
    private Method listenerCallbackMethod;
    private final RestconfClientImpl restconfClient;
    private final EventStreamInfo streamInfo;

    public RestListenableEventStreamContext(EventStreamInfo streamInfo, RestconfClientImpl restconfClient) {
        this.restconfClient = restconfClient;
        this.streamInfo = streamInfo;
    }

    public <T extends NotificationListener> ListenerRegistration<T> registerNotificationListener(T listener) {
        for (Method m : listener.getClass().getDeclaredMethods()) {
            if (!BindingReflections.isNotificationCallback((Method)m)) continue;
            this.listenerCallbackMethod = m;
            break;
        }
        return new AbstractListenerRegistration<T>(listener){

            protected void removeRegistration() {
                RestListenableEventStreamContext.this.stopListening();
            }
        };
    }

    public ListenableFuture<RpcResult<Void>> startListening() {
        ClientResponse response = null;
        try {
            response = this.extractWebSocketUriFromRpc(this.streamInfo.getIdentifier());
        }
        catch (ExecutionException e) {
            logger.trace("Execution exception while extracting stream name {}", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            logger.trace("InterruptedException while extracting stream name {}", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            logger.trace("UnsupportedEncodingException while extracting stream name {}", (Throwable)e);
            throw new IllegalStateException(e);
        }
        boolean success = true;
        if (response.getStatus() != 200) {
            success = false;
        }
        final RestRpcResult rpcResult = new RestRpcResult(success, response.getLocation());
        this.createWebsocketClient(response.getLocation());
        ListenableFuture future = this.pool.submit((Callable)new Callable<RpcResult<Void>>(){

            @Override
            public RpcResult<Void> call() {
                return rpcResult;
            }
        });
        return future;
    }

    public ListenableFuture<RpcResult<Void>> startListeningWithReplay(Optional<Date> startTime, Optional<Date> endTime) {
        return null;
    }

    public void stopListening() {
        this.wsClient.writeAndFlush((Object)new CloseWebSocketFrame(42, this.streamInfo.getIdentifier()));
    }

    public ListenableFuture<Optional<EventStreamReplay>> getReplay(Optional<Date> startTime, Optional<Date> endTime) {
        return null;
    }

    public void close() {
        this.stopListening();
    }

    private ClientResponse extractWebSocketUriFromRpc(String methodName) throws ExecutionException, InterruptedException, UnsupportedEncodingException {
        ListenableFuture<ClientResponse> clientFuture = this.restconfClient.get(ResourceUri.STREAM.getPath() + "/" + this.encodeUri(this.streamInfo.getIdentifier()), "application/xml", new Function<ClientResponse, ClientResponse>(){

            public ClientResponse apply(ClientResponse clientResponse) {
                return clientResponse;
            }
        });
        return (ClientResponse)clientFuture.get();
    }

    private void createWebsocketClient(URI websocketServerUri) {
        this.wsClient = new WebSocketIClient(websocketServerUri, (ClientMessageCallback)this);
    }

    private String encodeUri(String encodedPart) throws UnsupportedEncodingException {
        return URI.create(URLEncoder.encode(encodedPart, Charsets.US_ASCII.name()).toString()).toASCIIString();
    }

    public void onMessageReceived(Object message) {
        if (null == this.listenerCallbackMethod) {
            throw new IllegalStateException("No listener method to invoke.");
        }
        try {
            this.listenerCallbackMethod.invoke(message, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke callback", e);
        }
    }
}

