/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.opendaylight.yangtools.restconf.client.AbstractDataStore;
import org.opendaylight.yangtools.restconf.client.RestconfClientImpl;
import org.opendaylight.yangtools.restconf.client.api.data.ConfigurationDatastore;
import org.opendaylight.yangtools.restconf.client.to.RestRpcError;
import org.opendaylight.yangtools.restconf.client.to.RestRpcResult;
import org.opendaylight.yangtools.restconf.common.ResourceUri;
import org.opendaylight.yangtools.restconf.utils.RestconfUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public class ConfigurationDataStoreImpl
extends AbstractDataStore
implements ConfigurationDatastore {
    private final ListeningExecutorService pool = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));

    @Override
    protected String getStorePrefix() {
        return ResourceUri.CONFIG.getPath();
    }

    public ConfigurationDataStoreImpl(RestconfClientImpl client) {
        super(client);
    }

    public ListenableFuture<RpcResult<Boolean>> deleteData(final InstanceIdentifier<?> path) {
        final SchemaContext schemaContext = this.getClient().getSchemaContext();
        final BindingIndependentMappingService mappingService = this.getClient().getMappingService();
        Map.Entry pathWithSchema = RestconfUtils.toRestconfIdentifier(path, (BindingIndependentMappingService)mappingService, (SchemaContext)schemaContext);
        String restconfPath = this.getStorePrefix() + (String)pathWithSchema.getKey();
        return this.getClient().delete(restconfPath, "application/xml", new Function<ClientResponse, RpcResult<Boolean>>(){

            public RpcResult<Boolean> apply(ClientResponse clientResponse) {
                Map.Entry restconfEntry = RestconfUtils.toRestconfIdentifier((YangInstanceIdentifier)mappingService.toDataDom(path), (SchemaContext)schemaContext);
                if (clientResponse.getStatus() != 200) {
                    RestRpcError rpcError = new RestRpcError(RpcError.ErrorSeverity.ERROR, RpcError.ErrorType.RPC, null, null, "HTTP status " + clientResponse.getStatus(), null, null);
                    ArrayList<RpcError> errors = new ArrayList<RpcError>();
                    errors.add(rpcError);
                    RestRpcResult rpcResult = new RestRpcResult(false, null, errors);
                    return (RpcResult)Optional.of((Object)rpcResult);
                }
                DataObject dataObject = RestconfUtils.dataObjectFromInputStream((InstanceIdentifier)path, (InputStream)clientResponse.getEntityInputStream(), (SchemaContext)schemaContext, (BindingIndependentMappingService)mappingService, (DataSchemaNode)((DataSchemaNode)restconfEntry.getValue()));
                RestRpcResult rpcResult = new RestRpcResult(true, dataObject, null);
                return (RpcResult)Optional.of((Object)rpcResult);
            }
        });
    }

    public ListenableFuture<RpcResult<Boolean>> putData(final InstanceIdentifier<?> path) {
        final SchemaContext schemaContext = this.getClient().getSchemaContext();
        final BindingIndependentMappingService mappingService = this.getClient().getMappingService();
        Map.Entry pathWithSchema = RestconfUtils.toRestconfIdentifier(path, (BindingIndependentMappingService)mappingService, (SchemaContext)schemaContext);
        String restconfPath = this.getStorePrefix() + (String)pathWithSchema.getKey();
        return this.getClient().put(restconfPath, "application/xml", new Function<ClientResponse, RpcResult<Boolean>>(){

            public RpcResult<Boolean> apply(ClientResponse clientResponse) {
                Map.Entry restconfEntry = RestconfUtils.toRestconfIdentifier((YangInstanceIdentifier)mappingService.toDataDom(path), (SchemaContext)schemaContext);
                if (clientResponse.getStatus() != 200) {
                    RestRpcError rpcError = new RestRpcError(RpcError.ErrorSeverity.ERROR, RpcError.ErrorType.RPC, null, null, "HTTP status " + clientResponse.getStatus(), null, null);
                    ArrayList<RpcError> errors = new ArrayList<RpcError>();
                    errors.add(rpcError);
                    RestRpcResult rpcResult = new RestRpcResult(false, null, errors);
                    return (RpcResult)Optional.of((Object)rpcResult);
                }
                DataObject dataObject = RestconfUtils.dataObjectFromInputStream((InstanceIdentifier)path, (InputStream)clientResponse.getEntityInputStream(), (SchemaContext)schemaContext, (BindingIndependentMappingService)mappingService, (DataSchemaNode)((DataSchemaNode)restconfEntry.getValue()));
                RestRpcResult rpcResult = new RestRpcResult(true, dataObject);
                return (RpcResult)Optional.of((Object)rpcResult);
            }
        });
    }
}

