/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.opendaylight.yangtools.restconf.client.RestconfClientImpl;
import org.opendaylight.yangtools.restconf.client.to.RestRpcError;
import org.opendaylight.yangtools.restconf.client.to.RestRpcResult;
import org.opendaylight.yangtools.restconf.common.ResourceUri;
import org.opendaylight.yangtools.restconf.utils.XmlTools;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlCodecProvider;
import org.opendaylight.yangtools.yang.data.impl.codec.xml.XmlDocumentUtils;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class BindingToRestRpc
implements InvocationHandler {
    private final RestconfClientImpl client;
    private static final Logger logger = LoggerFactory.getLogger(BindingToRestRpc.class);
    private final BindingIndependentMappingService mappingService;
    private final SchemaContext schcemaContext;
    private final Module module;

    public BindingToRestRpc(Class<?> proxiedInterface, BindingIndependentMappingService mappingService, RestconfClientImpl client, SchemaContext schemaContext) throws Exception {
        this.mappingService = mappingService;
        this.client = client;
        this.schcemaContext = schemaContext;
        YangModuleInfo moduleInfo = BindingReflections.getModuleInfo(proxiedInterface);
        this.module = schemaContext.findModuleByName(moduleInfo.getName(), QName.parseRevision((String)moduleInfo.getRevision()));
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Exception {
        for (RpcDefinition rpcDef : this.module.getRpcs()) {
            if (!method.getName().equals(BindingMapping.getMethodName((QName)rpcDef.getQName()))) continue;
            String moduleName = BindingReflections.getModuleInfo(method.getDeclaringClass()).getName();
            String rpcMethodName = rpcDef.getQName().getLocalName();
            Document rpcInputDoc = null;
            for (Object component : objects) {
                CompositeNode rpcInput = this.mappingService.toDataDom((DataObject)component);
                rpcInputDoc = XmlDocumentUtils.toDocument((CompositeNode)rpcInput, (DataNodeContainer)rpcDef.getInput(), (XmlCodecProvider)XmlDocumentUtils.defaultValueCodecProvider());
            }
            DOMImplementationLS lsImpl = (DOMImplementationLS)rpcInputDoc.getImplementation().getFeature("LS", "3.0");
            LSSerializer serializer = lsImpl.createLSSerializer();
            serializer.getDomConfig().setParameter("xml-declaration", false);
            String payloadString = serializer.writeToString(rpcInputDoc);
            Class desiredOutputClass = (Class)BindingReflections.resolveRpcOutputClass((Method)method).get();
            ContainerSchemaNode rpcOutputSchema = rpcDef.getOutput();
            return this.client.post(ResourceUri.OPERATIONS.getPath() + "/" + moduleName + ":" + rpcMethodName, payloadString, new Function<ClientResponse, Object>((DataSchemaNode)rpcOutputSchema, desiredOutputClass){
                final /* synthetic */ DataSchemaNode val$rpcOutputSchema;
                final /* synthetic */ Class val$desiredOutputClass;
                {
                    this.val$rpcOutputSchema = dataSchemaNode;
                    this.val$desiredOutputClass = clazz;
                }

                public Object apply(ClientResponse clientResponse) {
                    if (clientResponse.getStatus() != 200) {
                        throw new IllegalStateException("Can't get data from restconf. " + clientResponse.getClientResponseStatus());
                    }
                    ArrayList errors = new ArrayList();
                    try {
                        Document rpcOutputDocument = XmlTools.fromXml((InputStream)clientResponse.getEntityInputStream());
                        CompositeNode cn = (CompositeNode)XmlDocumentUtils.toDomNode((Element)rpcOutputDocument.getDocumentElement(), (Optional)Optional.of((Object)this.val$rpcOutputSchema), (Optional)Optional.of((Object)XmlDocumentUtils.defaultValueCodecProvider()));
                        DataContainer rpcOutputDataObject = BindingToRestRpc.this.mappingService.dataObjectFromDataDom(this.val$desiredOutputClass, cn);
                        return new RestRpcResult(true, rpcOutputDataObject);
                    }
                    catch (Exception e) {
                        logger.trace("Error while extracting rpc output in proxy method {}", (Throwable)e);
                        RestRpcError error = new RestRpcError(RpcError.ErrorSeverity.ERROR, RpcError.ErrorType.APPLICATION, "Error while extracting rpc output in proxy method.", e);
                        return new RestRpcResult(false, errors);
                    }
                }
            });
        }
        throw new IllegalStateException("Unexpected state of proxy method.");
    }

    public static <T> T getProxy(Class<T> proxiedInterface, BindingIndependentMappingService mappingService, RestconfClientImpl restconfClient, SchemaContext schemaContext) {
        Object proxiedType = null;
        try {
            proxiedType = Proxy.newProxyInstance(BindingToRestRpc.class.getClassLoader(), new Class[]{proxiedInterface}, (InvocationHandler)new BindingToRestRpc(proxiedInterface, mappingService, restconfClient, schemaContext));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        return (T)proxiedType;
    }
}

