/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.restconf.client;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import java.util.Map;
import org.opendaylight.yangtools.restconf.client.RestconfClientImpl;
import org.opendaylight.yangtools.restconf.client.api.data.Datastore;
import org.opendaylight.yangtools.restconf.client.api.data.DefaultRetrievalStrategy;
import org.opendaylight.yangtools.restconf.client.api.data.RetrievalStrategy;
import org.opendaylight.yangtools.restconf.utils.RestconfUtils;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.BindingIndependentMappingService;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

public abstract class AbstractDataStore
implements Datastore {
    private final RestconfClientImpl client;

    public AbstractDataStore(RestconfClientImpl client) {
        this.client = client;
    }

    protected RestconfClientImpl getClient() {
        return this.client;
    }

    public <T extends DataObject> ListenableFuture<Optional<T>> readData(InstanceIdentifier<T> path) {
        return this.readData(path, (RetrievalStrategy)DefaultRetrievalStrategy.getInstance());
    }

    public <T extends DataObject> ListenableFuture<Optional<T>> readData(final InstanceIdentifier<T> path, RetrievalStrategy strategy) {
        final SchemaContext schemaContext = this.client.getSchemaContext();
        final BindingIndependentMappingService mappingService = this.client.getMappingService();
        final Map.Entry pathWithSchema = RestconfUtils.toRestconfIdentifier(path, (BindingIndependentMappingService)mappingService, (SchemaContext)schemaContext);
        String restconfPath = this.getStorePrefix() + (String)pathWithSchema.getKey();
        return this.client.get(restconfPath, "application/xml", new Function<ClientResponse, Optional<T>>(){

            public Optional<T> apply(ClientResponse response) {
                switch (response.getStatus()) {
                    case 200: {
                        DataObject dataObject = RestconfUtils.dataObjectFromInputStream((InstanceIdentifier)path, (InputStream)response.getEntityInputStream(), (SchemaContext)schemaContext, (BindingIndependentMappingService)mappingService, (DataSchemaNode)((DataSchemaNode)pathWithSchema.getValue()));
                        return Optional.of((Object)dataObject);
                    }
                    case 404: {
                        return Optional.absent();
                    }
                }
                throw new IllegalStateException("Failed : HTTP error code : " + response.getStatus());
            }
        });
    }

    protected abstract String getStorePrefix();
}

