package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * Copyright (c) 2014 Cisco Systems, Inc. and others. All rights reserved. This 
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;test-bug466-base&lt;/b&gt;
 * &lt;br&gt;Source path: &lt;i&gt;META-INF/yang/test-bug466-base.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * module test-bug466-base {
 *     yang-version 1;
 *     namespace "urn:opendaylight:yang:test:regression:bug466:base";
 *     prefix "bug466-base";
 *
 *     revision 2014-02-26 {
 *         description "Copyright (c) 2014 Cisco Systems, Inc. and others. All rights reserved. This 
 *                     program and the accompanying materials are made available under the terms of the
 *                     Eclipse Public License v1.0 which accompanies this distribution, and is 
 *                     available at http://www.eclipse.org/legal/epl-v10.html
 *         ";
 *     }
 *
 *     container bug-466 {
 *         leaf condition {
 *             type string;
 *         }
 *         container data {
 *         }
 *         container child {
 *         }
 *         augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *             description
 *                 "Empty augmentation without conditions.";
 *             status CURRENT;
 *         }
 *         augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *             description
 *                 "augmentation with data.";
 *             status CURRENT;
 *             container data {
 *             }
 *         }
 *         augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *             when "./base:condition='renamed-augment'";
 *             status CURRENT;
 *         }
 *         augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *             status CURRENT;
 *             container child {
 *             }
 *         }
 *     }
 *
 *     identity bug-466-identity {
 *         description
 *             "Testing identity.";
 *         status CURRENT;
 *     }
 * }
 * &lt;/pre&gt;
 *
 */
public interface TestBug466BaseData
    extends
    DataRoot
{




    /**
     * Empty Container which could be used by augmentation tests. This container is 
     * used for regression tests of Bug 466.
     *
     */
    Bug466 getBug466();

}

