package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466
 *
 */
public class Bug466Builder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466> {

    private java.lang.String _condition;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> augmentation = Collections.emptyMap();

    public Bug466Builder() {
    }

    public Bug466Builder(Bug466 base) {
        this._condition = base.getCondition();
        if (base instanceof Bug466Impl) {
            Bug466Impl impl = (Bug466Impl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.String getCondition() {
        return _condition;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public Bug466Builder setCondition(java.lang.String value) {
        this._condition = value;
        return this;
    }
    
    public Bug466Builder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public Bug466Builder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Bug466 build() {
        return new Bug466Impl(this);
    }

    private static final class Bug466Impl implements Bug466 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466.class;
        }

        private final java.lang.String _condition;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> augmentation = Collections.emptyMap();

        private Bug466Impl(Bug466Builder base) {
            this._condition = base.getCondition();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.String getCondition() {
            return _condition;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_condition == null) ? 0 : _condition.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466)obj;
            if (_condition == null) {
                if (other.getCondition() != null) {
                    return false;
                }
            } else if(!_condition.equals(other.getCondition())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                Bug466Impl otherImpl = (Bug466Impl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Bug466 [");
            boolean first = true;
        
            if (_condition != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_condition=");
                builder.append(_condition);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
