package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 *  Empty Container which could be used by augmentation tests. This container is 
 * used for regression tests of Bug 466. 
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;test-bug466-base&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/test-bug466-base.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container bug-466 {
 *     leaf condition {
 *         type string;
 *     }
 *     container data {
 *     }
 *     container child {
 *     }
 *     augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *         description
 *             "Empty augmentation without conditions.";
 *         status CURRENT;
 *     }
 *     augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *         description
 *             "augmentation with data.";
 *         status CURRENT;
 *         container data {
 *         }
 *     }
 *     augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *         when "./base:condition='renamed-augment'";
 *         status CURRENT;
 *     }
 *     augment \(urn:opendaylight:yang:test:regression:bug466:base)bug-466 {
 *         status CURRENT;
 *         container child {
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;test-bug466-base/bug-466&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466Builder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466Builder
 *
 */
public interface Bug466
    extends
    ChildOf<TestBug466BaseData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.bug466.base.rev140226.Bug466>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:yang:test:regression:bug466:base","2014-02-26","bug-466"));

    java.lang.String getCondition();

}

