package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424;
import org.opendaylight.yangtools.yang.binding.DataRoot;


/**
 * Copyright (c) 2014 Cisco Systems, Inc. and others. All rights reserved. This 
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is 
 * available at http://www.eclipse.org/legal/epl-v10.html
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;test-augmentation-base&lt;/b&gt;
 * &lt;br&gt;Source path: &lt;i&gt;META-INF/yang/test-augmentation-base.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * module test-augmentation-base {
 *     yang-version 1;
 *     namespace "urn:opendaylight:yang:test:regression:augmentation:base";
 *     prefix "aug-base";
 *
 *     revision 2014-04-24 {
 *         description "Copyright (c) 2014 Cisco Systems, Inc. and others. All rights reserved. This 
 *                     program and the accompanying materials are made available under the terms of the
 *                     Eclipse Public License v1.0 which accompanies this distribution, and is 
 *                     available at http://www.eclipse.org/legal/epl-v10.html
 *         ";
 *     }
 *
 *     container choices {
 *         choice augmentable-choice {
 *             case ext-not-augmented {
 *                 container ext-not-augmented {
 *                     container grouping-data {
 *                     }
 *                     uses grouping;
 *                 }
 *             }
 *             case ext-with-augmented-grouping {
 *                 container ext-with-augmented-grouping {
 *                     container grouping-data {
 *                         leaf augmented-leaf {
 *                             type string;
 *                         }
 *                         augment \(urn:opendaylight:yang:test:regression:augmentation:base)grouping-data {
 *                             status CURRENT;
 *                             leaf augmented-leaf {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                     uses augmented-grouping;
 *                 }
 *             }
 *             case ext-with-grouping-augmentations {
 *                 container ext-with-grouping-augmentations {
 *                     container grouping-data {
 *                         leaf ext-aumentation {
 *                             type string;
 *                         }
 *                         augment \(urn:opendaylight:yang:test:regression:augmentation:ext)grouping-data {
 *                             status CURRENT;
 *                             leaf ext-aumentation {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                     uses grouping;
 *                 }
 *             }
 *             case not-augmented {
 *                 container not-augmented {
 *                     container grouping-data {
 *                     }
 *                     uses grouping;
 *                 }
 *             }
 *             case with-augmented-grouping {
 *                 container with-augmented-grouping {
 *                     container grouping-data {
 *                         leaf augmented-leaf {
 *                             type string;
 *                         }
 *                         augment \(urn:opendaylight:yang:test:regression:augmentation:base)grouping-data {
 *                             status CURRENT;
 *                             leaf augmented-leaf {
 *                                 type string;
 *                             }
 *                         }
 *                     }
 *                     uses augmented-grouping;
 *                 }
 *             }
 *         }
 *     }
 *
 *     grouping augmented-grouping {
 *         container grouping-data {
 *             leaf augmented-leaf {
 *                 type string;
 *             }
 *             augment \(urn:opendaylight:yang:test:regression:augmentation:base)grouping-data {
 *                 status CURRENT;
 *                 leaf augmented-leaf {
 *                     type string;
 *                 }
 *             }
 *         }
 *     }
 *     grouping grouping {
 *         container grouping-data {
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 *
 */
public interface TestAugmentationBaseData
    extends
    DataRoot
{




    /**
     * Empty Container which could be used by augmentation tests. This container is 
     * used for regression tests of Bug 466.
     *
     */
    Choices getChoices();

}

