package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.choices.AugmentableChoice;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices
 *
 */
public class ChoicesBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices> {

    private AugmentableChoice _augmentableChoice;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> augmentation = Collections.emptyMap();

    public ChoicesBuilder() {
    }

    public ChoicesBuilder(Choices base) {
        this._augmentableChoice = base.getAugmentableChoice();
        if (base instanceof ChoicesImpl) {
            ChoicesImpl impl = (ChoicesImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public AugmentableChoice getAugmentableChoice() {
        return _augmentableChoice;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public ChoicesBuilder setAugmentableChoice(AugmentableChoice value) {
        this._augmentableChoice = value;
        return this;
    }
    
    public ChoicesBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public ChoicesBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Choices build() {
        return new ChoicesImpl(this);
    }

    private static final class ChoicesImpl implements Choices {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices.class;
        }

        private final AugmentableChoice _augmentableChoice;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> augmentation = Collections.emptyMap();

        private ChoicesImpl(ChoicesBuilder base) {
            this._augmentableChoice = base.getAugmentableChoice();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public AugmentableChoice getAugmentableChoice() {
            return _augmentableChoice;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_augmentableChoice == null) ? 0 : _augmentableChoice.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices other = (org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices)obj;
            if (_augmentableChoice == null) {
                if (other.getAugmentableChoice() != null) {
                    return false;
                }
            } else if(!_augmentableChoice.equals(other.getAugmentableChoice())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChoicesImpl otherImpl = (ChoicesImpl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Choices [");
            boolean first = true;
        
            if (_augmentableChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_augmentableChoice=");
                builder.append(_augmentableChoice);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
