package org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.choices.AugmentableChoice;


/**
 *  Empty Container which could be used by augmentation tests. This container is 
 * used for regression tests of Bug 466. 
 *
 * &lt;p&gt;This class represents the following YANG schema fragment defined in module &lt;b&gt;test-augmentation-base&lt;/b&gt;
 * &lt;br&gt;(Source path: &lt;i&gt;META-INF/yang/test-augmentation-base.yang&lt;/i&gt;):
 * &lt;pre&gt;
 * container choices {
 *     choice augmentable-choice {
 *         case ext-not-augmented {
 *             container ext-not-augmented {
 *                 container grouping-data {
 *                 }
 *                 uses grouping;
 *             }
 *         }
 *         case ext-with-augmented-grouping {
 *             container ext-with-augmented-grouping {
 *                 container grouping-data {
 *                     leaf augmented-leaf {
 *                         type string;
 *                     }
 *                     augment \(urn:opendaylight:yang:test:regression:augmentation:base)grouping-data {
 *                         status CURRENT;
 *                         leaf augmented-leaf {
 *                             type string;
 *                         }
 *                     }
 *                 }
 *                 uses augmented-grouping;
 *             }
 *         }
 *         case ext-with-grouping-augmentations {
 *             container ext-with-grouping-augmentations {
 *                 container grouping-data {
 *                     leaf ext-aumentation {
 *                         type string;
 *                     }
 *                     augment \(urn:opendaylight:yang:test:regression:augmentation:ext)grouping-data {
 *                         status CURRENT;
 *                         leaf ext-aumentation {
 *                             type string;
 *                         }
 *                     }
 *                 }
 *                 uses grouping;
 *             }
 *         }
 *         case not-augmented {
 *             container not-augmented {
 *                 container grouping-data {
 *                 }
 *                 uses grouping;
 *             }
 *         }
 *         case with-augmented-grouping {
 *             container with-augmented-grouping {
 *                 container grouping-data {
 *                     leaf augmented-leaf {
 *                         type string;
 *                     }
 *                     augment \(urn:opendaylight:yang:test:regression:augmentation:base)grouping-data {
 *                         status CURRENT;
 *                         leaf augmented-leaf {
 *                             type string;
 *                         }
 *                     }
 *                 }
 *                 uses augmented-grouping;
 *             }
 *         }
 *     }
 * }
 * &lt;/pre&gt;
 * The schema path to identify an instance is
 * &lt;i&gt;test-augmentation-base/choices&lt;/i&gt;
 *
 * &lt;p&gt;To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.ChoicesBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.ChoicesBuilder
 *
 */
public interface Choices
    extends
    ChildOf<TestAugmentationBaseData>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.yang.test.regression.augmentation.base.rev140424.Choices>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.cachedReference(org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:yang:test:regression:augmentation:base","2014-04-24","choices"));

    AugmentableChoice getAugmentableChoice();

}

