/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.configuration;

import java.util.List;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class ArgumentsExtractorVerifier
implements VerificationMode {
    private Object[] arguments;

    public void verify(VerificationData data) {
        InvocationsFinder finder = new InvocationsFinder();
        List actualInvocations = finder.findInvocations(data.getAllInvocations(), data.getWanted());
        if (actualInvocations.size() != 1) {
            throw new MockitoException("This verifier can only be used with 1 invocation, got " + actualInvocations.size());
        }
        Invocation invocation = (Invocation)actualInvocations.get(0);
        this.arguments = invocation.getArguments();
        invocation.markVerified();
    }

    public Object[] getArguments() {
        return this.arguments;
    }
}

