/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.wadl.generator;

import com.google.common.base.Objects;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public class WadlRestconfGenerator {
    private File path;
    private static final BuildContext CTX = new DefaultBuildContext();
    private static final String PATH_DELIMETER = "/";
    private SchemaContext context;
    private List<DataSchemaNode> configData;
    private List<DataSchemaNode> operationalData;
    private Module module;
    private List<LeafSchemaNode> pathListParams;

    public WadlRestconfGenerator(File targetPath) {
        boolean _not;
        boolean _exists = targetPath.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            targetPath.mkdirs();
        }
        this.path = targetPath;
    }

    public HashSet<File> generate(SchemaContext context, Set<Module> modules) {
        try {
            HashSet<File> result = new HashSet<File>();
            this.context = context;
            for (Module module : modules) {
                Set _rpcs;
                boolean _isNullOrEmpty;
                boolean _not_1;
                boolean _not;
                Collection _childNodes = module.getChildNodes();
                Functions.Function1<DataSchemaNode, Boolean> _function = new Functions.Function1<DataSchemaNode, Boolean>(){

                    public Boolean apply(DataSchemaNode it) {
                        return WadlRestconfGenerator.this.isListOrContainer(it);
                    }
                };
                Iterable dataContainers = IterableExtensions.filter((Iterable)_childNodes, (Functions.Function1)_function);
                boolean _or = false;
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)dataContainers);
                boolean bl = _not = !_isEmpty;
                _or = _not ? true : (_not_1 = !(_isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)(_rpcs = module.getRpcs()))));
                if (!_or) continue;
                ArrayList<DataSchemaNode> _arrayList = new ArrayList<DataSchemaNode>();
                this.configData = _arrayList;
                ArrayList<DataSchemaNode> _arrayList_1 = new ArrayList<DataSchemaNode>();
                this.operationalData = _arrayList_1;
                for (DataSchemaNode data : dataContainers) {
                    boolean _isConfiguration = data.isConfiguration();
                    if (_isConfiguration) {
                        this.configData.add(data);
                        continue;
                    }
                    this.operationalData.add(data);
                }
                this.module = module;
                StringConcatenation _builder = new StringConcatenation();
                String _name = module.getName();
                _builder.append((Object)_name, "");
                _builder.append((Object)".wadl");
                File destination = new File(this.path, _builder.toString());
                OutputStream _newFileOutputStream = CTX.newFileOutputStream(destination);
                OutputStreamWriter fw = new OutputStreamWriter(_newFileOutputStream);
                BufferedWriter bw = new BufferedWriter(fw);
                CharSequence _application = this.application();
                bw.append(_application);
                bw.close();
                fw.close();
                result.add(destination);
            }
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence application() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\"?>");
        _builder.newLine();
        _builder.append((Object)"<application xmlns=\"http://wadl.dev.java.net/2009/02\" ");
        CharSequence _importsAsNamespaces = this.importsAsNamespaces(this.module);
        _builder.append((Object)_importsAsNamespaces, "");
        _builder.append((Object)" xmlns:");
        String _prefix = this.module.getPrefix();
        _builder.append((Object)_prefix, "");
        _builder.append((Object)"=\"");
        URI _namespace = this.module.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _grammars = this.grammars();
        _builder.append((Object)_grammars, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _resources = this.resources();
        _builder.append((Object)_resources, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</application>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence importsAsNamespaces(Module module) {
        StringConcatenation _builder = new StringConcatenation();
        Set _imports = module.getImports();
        for (ModuleImport imprt : _imports) {
            _builder.append((Object)"xmlns:");
            String _prefix = imprt.getPrefix();
            _builder.append((Object)_prefix, "");
            _builder.append((Object)"=\"");
            String _moduleName = imprt.getModuleName();
            Date _revision = imprt.getRevision();
            Module _findModuleByName = this.context.findModuleByName(_moduleName, _revision);
            URI _namespace = _findModuleByName.getNamespace();
            _builder.append((Object)_namespace, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence grammars() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<grammars>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<include href=\"");
        String _name = this.module.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)".yang\"/>");
        _builder.newLineIfNotEmpty();
        Set _imports = this.module.getImports();
        for (ModuleImport imprt : _imports) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<include href=\"");
            String _moduleName = imprt.getModuleName();
            _builder.append((Object)_moduleName, "\t");
            _builder.append((Object)".yang\"/>");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"</grammars>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence resources() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<resources base=\"http://localhost:9998/restconf\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _resourceOperational = this.resourceOperational();
        _builder.append((Object)_resourceOperational, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _resourceConfig = this.resourceConfig();
        _builder.append((Object)_resourceConfig, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        CharSequence _resourceOperations = this.resourceOperations();
        _builder.append((Object)_resourceOperations, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</resources>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence resourceOperational() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.operationalData);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)"<resource path=\"operational\">");
            _builder.newLine();
            for (DataSchemaNode schemaNode : this.operationalData) {
                _builder.append((Object)"\t");
                String _firstResource = this.firstResource(schemaNode, false);
                _builder.append((Object)_firstResource, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</resource>");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence resourceConfig() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.configData);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)"<resource path=\"config\">");
            _builder.newLine();
            for (DataSchemaNode schemaNode : this.configData) {
                _builder.append((Object)"\t");
                CharSequence _mehodPost = this.mehodPost(schemaNode);
                _builder.append((Object)_mehodPost, "\t");
                _builder.newLineIfNotEmpty();
            }
            for (DataSchemaNode schemaNode_1 : this.configData) {
                _builder.append((Object)"\t");
                String _firstResource = this.firstResource(schemaNode_1, true);
                _builder.append((Object)_firstResource, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</resource>");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence resourceOperations() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Set _rpcs = this.module.getRpcs();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)_rpcs);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)"<resource path=\"operations\">");
            _builder.newLine();
            Set _rpcs_1 = this.module.getRpcs();
            for (RpcDefinition rpc : _rpcs_1) {
                _builder.append((Object)"\t");
                _builder.append((Object)"<resource path=\"");
                String _name = this.module.getName();
                _builder.append((Object)_name, "\t");
                _builder.append((Object)":");
                QName _qName = rpc.getQName();
                String _localName = _qName.getLocalName();
                _builder.append((Object)_localName, "\t");
                _builder.append((Object)"\">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                ContainerSchemaNode _input = rpc.getInput();
                boolean _notEquals = !Objects.equal((Object)_input, null);
                ContainerSchemaNode _output = rpc.getOutput();
                boolean _tripleNotEquals = _output != null;
                CharSequence _methodPostRpc = this.methodPostRpc(_notEquals, _tripleNotEquals);
                _builder.append((Object)_methodPostRpc, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"</resource>");
                _builder.newLine();
            }
            _builder.append((Object)"</resource>");
            _builder.newLine();
        }
        return _builder;
    }

    private String firstResource(DataSchemaNode schemaNode, boolean config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<resource path=\"");
        String _name = this.module.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)":");
        String _createPath = this.createPath(schemaNode);
        _builder.append((Object)_createPath, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _resourceBody = this.resourceBody(schemaNode, config);
        _builder.append((Object)_resourceBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</resource>");
        _builder.newLine();
        return _builder.toString();
    }

    private String resource(DataSchemaNode schemaNode, boolean config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<resource path=\"");
        String _createPath = this.createPath(schemaNode);
        _builder.append((Object)_createPath, "");
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _resourceBody = this.resourceBody(schemaNode, config);
        _builder.append((Object)_resourceBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</resource>");
        _builder.newLine();
        return _builder.toString();
    }

    private String createPath(DataSchemaNode schemaNode) {
        ArrayList<LeafSchemaNode> _arrayList = new ArrayList<LeafSchemaNode>();
        this.pathListParams = _arrayList;
        StringBuilder path = new StringBuilder();
        QName _qName = schemaNode.getQName();
        String _localName = _qName.getLocalName();
        path.append(_localName);
        if (schemaNode instanceof ListSchemaNode) {
            List _keyDefinition = ((ListSchemaNode)schemaNode).getKeyDefinition();
            for (QName listKey : _keyDefinition) {
                DataSchemaNode _dataChildByName = ((DataNodeContainer)schemaNode).getDataChildByName(listKey);
                this.pathListParams.add((LeafSchemaNode)_dataChildByName);
                path.append(PATH_DELIMETER);
                path.append("{");
                String _localName_1 = listKey.getLocalName();
                path.append(_localName_1);
                path.append("}");
            }
        }
        return path.toString();
    }

    private String resourceBody(DataSchemaNode schemaNode, boolean config) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.pathListParams);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            CharSequence _resourceParams = this.resourceParams();
            _builder.append((Object)_resourceParams, "");
            _builder.newLineIfNotEmpty();
        }
        CharSequence _methodGet = this.methodGet(schemaNode);
        _builder.append((Object)_methodGet, "");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = ((DataNodeContainer)schemaNode).getChildNodes();
        Functions.Function1<DataSchemaNode, Boolean> _function = new Functions.Function1<DataSchemaNode, Boolean>(){

            public Boolean apply(DataSchemaNode it) {
                return WadlRestconfGenerator.this.isListOrContainer(it);
            }
        };
        Iterable children = IterableExtensions.filter((Iterable)_childNodes, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        if (config) {
            CharSequence _methodDelete = this.methodDelete(schemaNode);
            _builder.append((Object)_methodDelete, "");
            _builder.newLineIfNotEmpty();
            CharSequence _mehodPut = this.mehodPut(schemaNode);
            _builder.append((Object)_mehodPut, "");
            _builder.newLineIfNotEmpty();
            for (DataSchemaNode child : children) {
                CharSequence _mehodPost = this.mehodPost(child);
                _builder.append((Object)_mehodPost, "");
                _builder.newLineIfNotEmpty();
            }
        }
        for (DataSchemaNode child_1 : children) {
            String _resource = this.resource(child_1, config);
            _builder.append((Object)_resource, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    private CharSequence resourceParams() {
        StringConcatenation _builder = new StringConcatenation();
        for (LeafSchemaNode pathParam : this.pathListParams) {
            boolean _notEquals = !Objects.equal((Object)pathParam, null);
            if (!_notEquals) continue;
            TypeDefinition _type = pathParam.getType();
            QName _qName = _type.getQName();
            String type = _qName.getLocalName();
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"<param required=\"true\" style=\"template\" name=\"");
            QName _qName_1 = pathParam.getQName();
            String _localName = _qName_1.getLocalName();
            _builder.append((Object)_localName, "");
            _builder.append((Object)"\" type=\"");
            _builder.append((Object)type, "");
            _builder.append((Object)"\"/>");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence methodGet(DataSchemaNode schemaNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<method name=\"GET\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<response>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        QName _qName = schemaNode.getQName();
        URI _namespace = _qName.getNamespace();
        QName _qName_1 = schemaNode.getQName();
        String _localName = _qName_1.getLocalName();
        CharSequence _representation = this.representation(_namespace, _localName);
        _builder.append((Object)_representation, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"</response>");
        _builder.newLine();
        _builder.append((Object)"</method>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence mehodPut(DataSchemaNode schemaNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<method name=\"PUT\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<request>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        QName _qName = schemaNode.getQName();
        URI _namespace = _qName.getNamespace();
        QName _qName_1 = schemaNode.getQName();
        String _localName = _qName_1.getLocalName();
        CharSequence _representation = this.representation(_namespace, _localName);
        _builder.append((Object)_representation, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"</request>");
        _builder.newLine();
        _builder.append((Object)"</method>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence mehodPost(DataSchemaNode schemaNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<method name=\"POST\">");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<request>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        QName _qName = schemaNode.getQName();
        URI _namespace = _qName.getNamespace();
        QName _qName_1 = schemaNode.getQName();
        String _localName = _qName_1.getLocalName();
        CharSequence _representation = this.representation(_namespace, _localName);
        _builder.append((Object)_representation, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"</request>");
        _builder.newLine();
        _builder.append((Object)"</method>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence methodPostRpc(boolean input, boolean output) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<method name=\"POST\">");
        _builder.newLine();
        if (input) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<request>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _representation = this.representation(null, "input");
            _builder.append((Object)_representation, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</request>");
            _builder.newLine();
        }
        if (output) {
            _builder.append((Object)"\t");
            _builder.append((Object)"<response>");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _representation_1 = this.representation(null, "output");
            _builder.append((Object)_representation_1, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"</response>");
            _builder.newLine();
        }
        _builder.append((Object)"</method>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence methodDelete(DataSchemaNode schemaNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<method name=\"DELETE\" />");
        _builder.newLine();
        return _builder;
    }

    private CharSequence representation(URI prefix, String name) {
        StringConcatenation _builder = new StringConcatenation();
        String elementData = name;
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<representation mediaType=\"application/xml\" element=\"");
        _builder.append((Object)elementData, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<representation mediaType=\"text/xml\" element=\"");
        _builder.append((Object)elementData, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<representation mediaType=\"application/json\" element=\"");
        _builder.append((Object)elementData, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<representation mediaType=\"application/yang.data+xml\" element=\"");
        _builder.append((Object)elementData, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<representation mediaType=\"application/yang.data+json\" element=\"");
        _builder.append((Object)elementData, "");
        _builder.append((Object)"\"/>");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private boolean isListOrContainer(DataSchemaNode schemaNode) {
        boolean _or = false;
        _or = schemaNode instanceof ListSchemaNode ? true : schemaNode instanceof ContainerSchemaNode;
        return _or;
    }
}

