/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.unified.doc.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AnyXmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ConstraintDefinition;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnsignedIntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.ExtendedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

public class GeneratorImpl {
    private File path;
    private static final SimpleDateFormat REVISION_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorImpl.class);
    private static final BuildContext CTX = new DefaultBuildContext();
    private Module currentModule;
    private final Map<String, String> imports = new HashMap<String, String>();
    private SchemaContext ctx;
    private StringBuilder augmentChildNodesAsString;
    private DataSchemaNode lastNodeInTargetPath = null;

    public HashSet<File> generate(SchemaContext context, File targetPath, Set<Module> modulesToGen) throws IOException {
        this.path = targetPath;
        this.path.mkdirs();
        HashSet<File> it = new HashSet<File>();
        for (Module module : modulesToGen) {
            File _generateDocumentation = this.generateDocumentation(module, context);
            it.add(_generateDocumentation);
        }
        return it;
    }

    public File generateDocumentation(Module module, SchemaContext ctx) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = module.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".html");
        File destination = new File(this.path, _builder.toString());
        this.ctx = ctx;
        Set _imports = module.getImports();
        Procedures.Procedure1<ModuleImport> _function = new Procedures.Procedure1<ModuleImport>(){

            public void apply(ModuleImport importModule) {
                String _prefix = importModule.getPrefix();
                String _moduleName = importModule.getModuleName();
                GeneratorImpl.this.imports.put(_prefix, _moduleName);
            }
        };
        IterableExtensions.forEach((Iterable)_imports, (Procedures.Procedure1)_function);
        try {
            OutputStream _newFileOutputStream = CTX.newFileOutputStream(destination);
            OutputStreamWriter fw = new OutputStreamWriter(_newFileOutputStream);
            BufferedWriter bw = new BufferedWriter(fw);
            this.currentModule = module;
            CharSequence _generate = this.generate(module, ctx);
            bw.append(_generate);
            bw.close();
            fw.close();
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException e = (IOException)_t;
                String _message = e.getMessage();
                LOG.error(_message);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return destination;
    }

    public CharSequence generate(Module module, SchemaContext ctx) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<!DOCTYPE html>");
        _builder.newLine();
        _builder.append((Object)"<html lang=\"en\">");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<head>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<title>");
        String _name = module.getName();
        _builder.append((Object)_name, "    ");
        _builder.append((Object)"</title>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"</head>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<body>");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _body = this.body(module, ctx);
        _builder.append((Object)_body, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"</body>");
        _builder.newLine();
        _builder.append((Object)"</html>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence body(Module module, SchemaContext ctx) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _header = this.header(module);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeDefinitionsSummary = this.typeDefinitionsSummary(module);
        _builder.append((Object)_typeDefinitionsSummary, "");
        _builder.newLineIfNotEmpty();
        String _identitiesSummary = this.identitiesSummary(module);
        _builder.append((Object)_identitiesSummary, "");
        _builder.newLineIfNotEmpty();
        String _groupingsSummary = this.groupingsSummary(module);
        _builder.append((Object)_groupingsSummary, "");
        _builder.newLineIfNotEmpty();
        String _augmentationsSummary = this.augmentationsSummary(module, ctx);
        _builder.append((Object)_augmentationsSummary, "");
        _builder.newLineIfNotEmpty();
        String _objectsSummary = this.objectsSummary(module);
        _builder.append((Object)_objectsSummary, "");
        _builder.newLineIfNotEmpty();
        String _notificationsSummary = this.notificationsSummary(module);
        _builder.append((Object)_notificationsSummary, "");
        _builder.newLineIfNotEmpty();
        String _rpcsSummary = this.rpcsSummary(module);
        _builder.append((Object)_rpcsSummary, "");
        _builder.newLineIfNotEmpty();
        String _extensionsSummary = this.extensionsSummary(module);
        _builder.append((Object)_extensionsSummary, "");
        _builder.newLineIfNotEmpty();
        String _featuresSummary = this.featuresSummary(module);
        _builder.append((Object)_featuresSummary, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _typeDefinitions = this.typeDefinitions(module);
        _builder.append((Object)_typeDefinitions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _identities = this.identities(module);
        _builder.append((Object)_identities, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _groupings = this.groupings(module);
        _builder.append((Object)_groupings, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _dataStore = this.dataStore(module);
        _builder.append((Object)_dataStore, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _childNodes = this.childNodes(module);
        _builder.append((Object)_childNodes, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _notifications = this.notifications(module);
        _builder.append((Object)_notifications, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _augmentations = this.augmentations(module, ctx);
        _builder.append((Object)_augmentations, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _rpcs = this.rpcs(module);
        _builder.append((Object)_rpcs, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _extensions = this.extensions(module);
        _builder.append((Object)_extensions, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _features = this.features(module);
        _builder.append((Object)_features, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private String typeDefinitionsSummary(Module module) {
        Set typedefs = module.getTypeDefinitions();
        boolean _isEmpty = typedefs.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<div>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<h3>Type Definitions Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"            ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        for (TypeDefinition typedef : typedefs) {
            _builder.append((Object)"        ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            QName _qName = typedef.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = typedef.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "            ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            String _description = typedef.getDescription();
            _builder.append((Object)_description, "            ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"        ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"</table>");
        _builder.newLine();
        _builder.append((Object)"</div>");
        _builder.newLine();
        return _builder.toString();
    }

    public String typeDefinitions(Module module) {
        Set typedefs = module.getTypeDefinitions();
        boolean _isEmpty = typedefs.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Type Definitions</h2>");
        _builder.newLine();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        for (TypeDefinition typedef : typedefs) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            QName _qName = typedef.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "    ");
            _builder.append((Object)"\">");
            QName _qName_1 = typedef.getQName();
            String _localName_1 = _qName_1.getLocalName();
            _builder.append((Object)_localName_1, "    ");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"<ul>");
            _builder.newLine();
            _builder.append((Object)"    ");
            CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)typedef);
            _builder.append((Object)_descAndRefLi, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            CharSequence _restrictions = this.restrictions(typedef);
            _builder.append((Object)_restrictions, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String identities(Module module) {
        Set _identities = module.getIdentities();
        boolean _isEmpty = _identities.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Identities</h2>");
        _builder.newLine();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        Set _identities_1 = module.getIdentities();
        for (IdentitySchemaNode identity : _identities_1) {
            boolean _tripleNotEquals;
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            QName _qName = identity.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "    ");
            _builder.append((Object)"\">");
            QName _qName_1 = identity.getQName();
            String _localName_1 = _qName_1.getLocalName();
            _builder.append((Object)_localName_1, "    ");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"<ul>");
            _builder.newLine();
            _builder.append((Object)"    ");
            CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)identity);
            _builder.append((Object)_descAndRefLi, "    ");
            _builder.newLineIfNotEmpty();
            IdentitySchemaNode _baseIdentity = identity.getBaseIdentity();
            boolean bl = _tripleNotEquals = _baseIdentity != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"    ");
                IdentitySchemaNode _baseIdentity_1 = identity.getBaseIdentity();
                QName _qName_2 = _baseIdentity_1.getQName();
                String _localName_2 = _qName_2.getLocalName();
                CharSequence _listItem = this.listItem("base", _localName_2);
                _builder.append((Object)_listItem, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String identitiesSummary(Module module) {
        Set _identities = module.getIdentities();
        boolean _isEmpty = _identities.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Identities Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _identities_1 = module.getIdentities();
        for (IdentitySchemaNode identity : _identities_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = identity.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = identity.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = identity.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    private String groupings(Module module) {
        Set _groupings = module.getGroupings();
        boolean _isEmpty = _groupings.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Groupings</h2>");
        _builder.newLine();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        Set _groupings_1 = module.getGroupings();
        for (GroupingDefinition grouping : _groupings_1) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            QName _qName = grouping.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "    ");
            _builder.append((Object)"\">");
            QName _qName_1 = grouping.getQName();
            String _localName_1 = _qName_1.getLocalName();
            _builder.append((Object)_localName_1, "    ");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"<ul>");
            _builder.newLine();
            _builder.append((Object)"        ");
            CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)grouping);
            _builder.append((Object)_descAndRefLi, "        ");
            _builder.newLineIfNotEmpty();
            Collection _childNodes = grouping.getChildNodes();
            for (DataSchemaNode childNode : _childNodes) {
                _builder.append((Object)"        ");
                CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo(childNode);
                _builder.append((Object)_printSchemaNodeInfo, "        ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String groupingsSummary(Module module) {
        Set _groupings = module.getGroupings();
        boolean _isEmpty = _groupings.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Groupings Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _groupings_1 = module.getGroupings();
        for (GroupingDefinition grouping : _groupings_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = grouping.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = grouping.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = grouping.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public String dataStore(Module module) {
        Collection _childNodes = module.getChildNodes();
        boolean _isEmpty = _childNodes.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Datastore Structure</h2>");
        _builder.newLine();
        CharSequence _tree = this.tree(module);
        _builder.append((Object)_tree, "");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String augmentations(Module module, SchemaContext context) {
        Set _augmentations = module.getAugmentations();
        boolean _isEmpty = _augmentations.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Augmentations</h2>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        Set _augmentations_1 = module.getAugmentations();
        for (AugmentationSchema augment : _augmentations_1) {
            RevisionAwareXPath _whenCondition;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            SchemaPath _targetPath = augment.getTargetPath();
            String _schemaPathToString = this.schemaPathToString(module, _targetPath, context, (DataNodeContainer)augment);
            _builder.append((Object)_schemaPathToString, "    ");
            _builder.append((Object)"\">");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"Target [");
            SchemaPath _targetPath_1 = augment.getTargetPath();
            SchemaPath _targetPath_2 = augment.getTargetPath();
            String _schemaPathToString_1 = this.schemaPathToString(module, _targetPath_2, context, (DataNodeContainer)augment);
            String _typeAnchorLink = this.typeAnchorLink(_targetPath_1, _schemaPathToString_1);
            _builder.append((Object)_typeAnchorLink, "    ");
            _builder.append((Object)"]</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            String _description = augment.getDescription();
            _builder.append((Object)_description, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            _builder.append((Object)"Status: ");
            Status _status = augment.getStatus();
            String _valueOf = String.valueOf(_status);
            String _strong = this.strong(_valueOf);
            _builder.append((Object)_strong, "        ");
            _builder.newLineIfNotEmpty();
            String _reference = augment.getReference();
            boolean bl = _tripleNotEquals = _reference != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"    ");
                _builder.append((Object)"Reference ");
                String _reference_1 = augment.getReference();
                _builder.append((Object)_reference_1, "    ");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _tripleNotEquals_1 = (_whenCondition = augment.getWhenCondition()) != null;
            if (_tripleNotEquals_1) {
                _builder.append((Object)"    ");
                _builder.append((Object)"When ");
                RevisionAwareXPath _whenCondition_1 = augment.getWhenCondition();
                String _string = _whenCondition_1.toString();
                _builder.append((Object)_string, "    ");
                _builder.newLineIfNotEmpty();
            }
            Collection _childNodes = augment.getChildNodes();
            for (DataSchemaNode childNode : _childNodes) {
                _builder.append((Object)"    ");
                CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo(childNode);
                _builder.append((Object)_printSchemaNodeInfo, "    ");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"    ");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3>Example</h3>");
            _builder.newLine();
            _builder.append((Object)"    ");
            Collection _childNodes_1 = augment.getChildNodes();
            ArrayList<DataSchemaNode> _arrayList = new ArrayList<DataSchemaNode>(_childNodes_1);
            String _createAugmentChildNodesAsString = this.createAugmentChildNodesAsString(_arrayList);
            _builder.append((Object)_createAugmentChildNodesAsString, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            SchemaPath _targetPath_3 = augment.getTargetPath();
            List<DataSchemaNode> _parseTargetPath = this.parseTargetPath(_targetPath_3);
            String _printNodeChildren = this.printNodeChildren(_parseTargetPath);
            _builder.append((Object)_printNodeChildren, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String createAugmentChildNodesAsString(List<DataSchemaNode> childNodes) {
        StringBuilder _stringBuilder;
        this.augmentChildNodesAsString = _stringBuilder = new StringBuilder();
        String _printNodeChildren = this.printNodeChildren(childNodes);
        this.augmentChildNodesAsString.append(_printNodeChildren);
        return "";
    }

    private List<DataSchemaNode> parseTargetPath(SchemaPath path) {
        boolean _not;
        ArrayList<DataSchemaNode> nodes = new ArrayList<DataSchemaNode>();
        Iterable _pathFromRoot = path.getPathFromRoot();
        for (QName pathElement : _pathFromRoot) {
            boolean _notEquals;
            DataSchemaNode child;
            Date _revision;
            URI _namespace = pathElement.getNamespace();
            Module module = this.ctx.findModuleByNamespaceAndRevision(_namespace, _revision = pathElement.getRevision());
            boolean _tripleNotEquals = module != null;
            if (!_tripleNotEquals) continue;
            DataSchemaNode foundNode = module.getDataChildByName(pathElement);
            boolean _equals = Objects.equal((Object)foundNode, null);
            if (_equals && (child = (DataSchemaNode)IterableExtensions.last(nodes)) instanceof DataNodeContainer) {
                DataSchemaNode _findNodeInChildNodes;
                DataNodeContainer dataContNode = (DataNodeContainer)child;
                Collection _childNodes = dataContNode.getChildNodes();
                foundNode = _findNodeInChildNodes = this.findNodeInChildNodes(pathElement, _childNodes);
            }
            if (!(_notEquals = !Objects.equal((Object)foundNode, null))) continue;
            nodes.add(foundNode);
        }
        boolean _isEmpty = nodes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            DataSchemaNode _get;
            int _size = nodes.size();
            int _minus = _size - 1;
            this.lastNodeInTargetPath = _get = (DataSchemaNode)nodes.get(_minus);
        }
        ArrayList<DataSchemaNode> targetPathNodes = new ArrayList<DataSchemaNode>();
        targetPathNodes.add(this.lastNodeInTargetPath);
        return targetPathNodes;
    }

    private DataSchemaNode findNodeInChildNodes(QName findingNode, Iterable<DataSchemaNode> childNodes) {
        for (DataSchemaNode child : childNodes) {
            QName _qName = child.getQName();
            boolean _equals = _qName.equals((Object)findingNode);
            if (!_equals) continue;
            return child;
        }
        for (DataSchemaNode child_1 : childNodes) {
            Collection _childNodes_1;
            DataSchemaNode foundChild_1;
            boolean _notEquals_1;
            if (child_1 instanceof ContainerSchemaNode) {
                Collection _childNodes = ((ContainerSchemaNode)child_1).getChildNodes();
                DataSchemaNode foundChild = this.findNodeInChildNodes(findingNode, _childNodes);
                boolean _notEquals = !Objects.equal((Object)foundChild, null);
                if (!_notEquals) continue;
                return foundChild;
            }
            if (!(child_1 instanceof ListSchemaNode) || !(_notEquals_1 = !Objects.equal((Object)(foundChild_1 = this.findNodeInChildNodes(findingNode, _childNodes_1 = ((ListSchemaNode)child_1).getChildNodes())), null))) continue;
            return foundChild_1;
        }
        return null;
    }

    private String printNodeChildren(List<DataSchemaNode> childNodes) {
        boolean _isEmpty = childNodes.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<pre>");
        _builder.newLine();
        DataSchemaNode _get = childNodes.get(0);
        CharSequence _printAugmentedNode = this.printAugmentedNode(_get);
        _builder.append((Object)_printAugmentedNode, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</pre>");
        _builder.newLine();
        return _builder.toString();
    }

    private CharSequence printAugmentedNode(DataSchemaNode child) {
        if (child instanceof ChoiceCaseNode) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        if (child instanceof ContainerSchemaNode) {
            String _printContainerNode = this.printContainerNode((ContainerSchemaNode)child);
            _builder.append((Object)_printContainerNode, "");
            _builder.newLineIfNotEmpty();
        }
        if (child instanceof AnyXmlSchemaNode) {
            String _printAnyXmlNode = this.printAnyXmlNode((AnyXmlSchemaNode)child);
            _builder.append((Object)_printAnyXmlNode, "");
            _builder.newLineIfNotEmpty();
        }
        if (child instanceof LeafSchemaNode) {
            String _printLeafNode = this.printLeafNode((LeafSchemaNode)child);
            _builder.append((Object)_printLeafNode, "");
            _builder.newLineIfNotEmpty();
        }
        if (child instanceof LeafListSchemaNode) {
            String _printLeafListNode = this.printLeafListNode((LeafListSchemaNode)child);
            _builder.append((Object)_printLeafListNode, "");
            _builder.newLineIfNotEmpty();
        }
        if (child instanceof ListSchemaNode) {
            String _printListNode = this.printListNode((ListSchemaNode)child);
            _builder.append((Object)_printListNode, "");
            _builder.newLineIfNotEmpty();
        }
        if (child instanceof ChoiceSchemaNode) {
            this.printChoiceNode((ChoiceSchemaNode)child);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private void printChoiceNode(ChoiceSchemaNode child) {
        boolean _not;
        Set _cases = child.getCases();
        ArrayList cases = new ArrayList(_cases);
        boolean _isEmpty = cases.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            ChoiceCaseNode aCase = (ChoiceCaseNode)cases.get(0);
            Collection _childNodes = aCase.getChildNodes();
            for (DataSchemaNode caseChildNode : _childNodes) {
                this.printAugmentedNode(caseChildNode);
            }
        }
    }

    private String printListNode(ListSchemaNode listNode) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        QName _qName = listNode.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        QName _qName_1 = listNode.getQName();
        URI _namespace = _qName_1.getNamespace();
        URI _namespace_1 = this.currentModule.getNamespace();
        boolean _equals = _namespace.equals(_namespace_1);
        boolean bl = _not = !_equals;
        if (_not) {
            _builder.append((Object)" xmlns=\"");
            QName _qName_2 = listNode.getQName();
            URI _namespace_2 = _qName_2.getNamespace();
            _builder.append((Object)_namespace_2, "");
            _builder.append((Object)"\"");
        }
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = listNode.getChildNodes();
        for (DataSchemaNode child : _childNodes) {
            _builder.append((Object)"    ");
            CharSequence _printAugmentedNode = this.printAugmentedNode(child);
            _builder.append((Object)_printAugmentedNode, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"&lt;/");
        QName _qName_3 = listNode.getQName();
        String _localName_1 = _qName_3.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String printContainerNode(ContainerSchemaNode containerNode) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        QName _qName = containerNode.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        QName _qName_1 = containerNode.getQName();
        URI _namespace = _qName_1.getNamespace();
        URI _namespace_1 = this.currentModule.getNamespace();
        boolean _equals = _namespace.equals(_namespace_1);
        boolean bl = _not = !_equals;
        if (_not) {
            _builder.append((Object)" xmlns=\"");
            QName _qName_2 = containerNode.getQName();
            URI _namespace_2 = _qName_2.getNamespace();
            _builder.append((Object)_namespace_2, "");
            _builder.append((Object)"\"");
        }
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = containerNode.getChildNodes();
        for (DataSchemaNode child : _childNodes) {
            _builder.append((Object)"    ");
            CharSequence _printAugmentedNode = this.printAugmentedNode(child);
            _builder.append((Object)_printAugmentedNode, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"&lt;/");
        QName _qName_3 = containerNode.getQName();
        String _localName_1 = _qName_3.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String printLeafListNode(LeafListSchemaNode leafListNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        QName _qName = leafListNode.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"&gt;. . .&lt;/");
        QName _qName_1 = leafListNode.getQName();
        String _localName_1 = _qName_1.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"&lt;");
        QName _qName_2 = leafListNode.getQName();
        String _localName_2 = _qName_2.getLocalName();
        _builder.append((Object)_localName_2, "");
        _builder.append((Object)"&gt;. . .&lt;/");
        QName _qName_3 = leafListNode.getQName();
        String _localName_3 = _qName_3.getLocalName();
        _builder.append((Object)_localName_3, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"&lt;");
        QName _qName_4 = leafListNode.getQName();
        String _localName_4 = _qName_4.getLocalName();
        _builder.append((Object)_localName_4, "");
        _builder.append((Object)"&gt;. . .&lt;/");
        QName _qName_5 = leafListNode.getQName();
        String _localName_5 = _qName_5.getLocalName();
        _builder.append((Object)_localName_5, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String printAnyXmlNode(AnyXmlSchemaNode anyXmlNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        QName _qName = anyXmlNode.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"&gt;. . .&lt;/");
        QName _qName_1 = anyXmlNode.getQName();
        String _localName_1 = _qName_1.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String printLeafNode(LeafSchemaNode leafNode) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        QName _qName = leafNode.getQName();
        String _localName = _qName.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"&gt;. . .&lt;/");
        QName _qName_1 = leafNode.getQName();
        String _localName_1 = _qName_1.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String augmentationsSummary(Module module, SchemaContext context) {
        Set _augmentations = module.getAugmentations();
        boolean _isEmpty = _augmentations.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Augmentations Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Target</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _augmentations_1 = module.getAugmentations();
        for (AugmentationSchema augment : _augmentations_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            SchemaPath _targetPath = augment.getTargetPath();
            String _schemaPathToString = this.schemaPathToString(module, _targetPath, context, (DataNodeContainer)augment);
            SchemaPath _targetPath_1 = augment.getTargetPath();
            String _schemaPathToString_1 = this.schemaPathToString(module, _targetPath_1, context, (DataNodeContainer)augment);
            String _strong = this.strong(_schemaPathToString_1);
            CharSequence _anchorLink = this.anchorLink(_schemaPathToString, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = augment.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public String notifications(Module module) {
        Set notificationdefs = module.getNotifications();
        boolean _isEmpty = notificationdefs.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Notifications</h2>");
        _builder.newLine();
        for (NotificationDefinition notificationdef : notificationdefs) {
            _builder.newLine();
            _builder.append((Object)"<h3 id=\"");
            SchemaPath _path = notificationdef.getPath();
            CharSequence _schemaPathToId = this.schemaPathToId(_path);
            _builder.append((Object)_schemaPathToId, "");
            _builder.append((Object)"\">");
            CharSequence _nodeName = this.nodeName((SchemaNode)notificationdef);
            _builder.append((Object)_nodeName, "");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            CharSequence _descAndRef = this.descAndRef((SchemaNode)notificationdef);
            _builder.append((Object)_descAndRef, "    ");
            _builder.newLineIfNotEmpty();
            Collection _childNodes = notificationdef.getChildNodes();
            for (DataSchemaNode childNode : _childNodes) {
                _builder.append((Object)"    ");
                CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo(childNode);
                _builder.append((Object)_printSchemaNodeInfo, "    ");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    private String notificationsSummary(Module module) {
        Set _notifications = module.getNotifications();
        boolean _isEmpty = _notifications.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Notifications Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _notifications_1 = module.getNotifications();
        for (NotificationDefinition notification : _notifications_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            SchemaPath _path = notification.getPath();
            CharSequence _schemaPathToId = this.schemaPathToId(_path);
            QName _qName = notification.getQName();
            String _localName = _qName.getLocalName();
            String _strong = this.strong(_localName);
            CharSequence _anchorLink = this.anchorLink(_schemaPathToId, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = notification.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public String rpcs(Module module) {
        Set _rpcs = module.getRpcs();
        boolean _isEmpty = _rpcs.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>RPC Definitions</h2>");
        _builder.newLine();
        Set _rpcs_1 = module.getRpcs();
        for (RpcDefinition rpc : _rpcs_1) {
            _builder.append((Object)"<h3 id=\"");
            QName _qName = rpc.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "");
            _builder.append((Object)"\">");
            CharSequence _nodeName = this.nodeName((SchemaNode)rpc);
            _builder.append((Object)_nodeName, "");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"<ul>");
            _builder.newLine();
            _builder.append((Object)"        ");
            CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)rpc);
            _builder.append((Object)_descAndRefLi, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            ContainerSchemaNode _input = rpc.getInput();
            CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo((DataSchemaNode)_input);
            _builder.append((Object)_printSchemaNodeInfo, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"        ");
            ContainerSchemaNode _output = rpc.getOutput();
            CharSequence _printSchemaNodeInfo_1 = this.printSchemaNodeInfo((DataSchemaNode)_output);
            _builder.append((Object)_printSchemaNodeInfo_1, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String rpcsSummary(Module module) {
        Set _rpcs = module.getRpcs();
        boolean _isEmpty = _rpcs.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>RPCs Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _rpcs_1 = module.getRpcs();
        for (RpcDefinition rpc : _rpcs_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = rpc.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = rpc.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = rpc.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public String extensions(Module module) {
        List _extensionSchemaNodes = module.getExtensionSchemaNodes();
        boolean _isEmpty = _extensionSchemaNodes.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Extensions</h2>");
        _builder.newLine();
        List _extensionSchemaNodes_1 = module.getExtensionSchemaNodes();
        for (ExtensionDefinition ext : _extensionSchemaNodes_1) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            QName _qName = ext.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "    ");
            _builder.append((Object)"\">");
            CharSequence _nodeName = this.nodeName((SchemaNode)ext);
            _builder.append((Object)_nodeName, "    ");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</li>");
            _builder.newLine();
            CharSequence _extensionInfo = this.extensionInfo(ext);
            _builder.append((Object)_extensionInfo, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    private String extensionsSummary(Module module) {
        List _extensionSchemaNodes = module.getExtensionSchemaNodes();
        boolean _isEmpty = _extensionSchemaNodes.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Extensions Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        List _extensionSchemaNodes_1 = module.getExtensionSchemaNodes();
        for (ExtensionDefinition ext : _extensionSchemaNodes_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = ext.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = ext.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = ext.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public String features(Module module) {
        Set _features = module.getFeatures();
        boolean _isEmpty = _features.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h2>Features</h2>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        Set _features_1 = module.getFeatures();
        for (FeatureDefinition feature : _features_1) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"<h3 id=\"");
            QName _qName = feature.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "    ");
            _builder.append((Object)"\">");
            QName _qName_1 = feature.getQName();
            String _localName_1 = _qName_1.getLocalName();
            _builder.append((Object)_localName_1, "    ");
            _builder.append((Object)"</h3>");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"<ul>");
            _builder.newLine();
            _builder.append((Object)"        ");
            CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)feature);
            _builder.append((Object)_descAndRefLi, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder.toString();
    }

    private String featuresSummary(Module module) {
        Set _features = module.getFeatures();
        boolean _isEmpty = _features.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Features Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Set _features_1 = module.getFeatures();
        for (FeatureDefinition feature : _features_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = feature.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = feature.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = feature.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    private String objectsSummary(Module module) {
        Collection _childNodes = module.getChildNodes();
        boolean _isEmpty = _childNodes.isEmpty();
        if (_isEmpty) {
            return "";
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h3>Child Nodes Summary</h3>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Name</th>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<th>Description</th>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        Collection _childNodes_1 = module.getChildNodes();
        for (DataSchemaNode childNode : _childNodes_1) {
            _builder.append((Object)"    ");
            _builder.append((Object)"<tr>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            QName _qName = childNode.getQName();
            String _localName = _qName.getLocalName();
            QName _qName_1 = childNode.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong = this.strong(_localName_1);
            CharSequence _anchorLink = this.anchorLink(_localName, _strong);
            _builder.append((Object)_anchorLink, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"<td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            String _description = childNode.getDescription();
            _builder.append((Object)_description, "        ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            _builder.append((Object)"    ");
            _builder.append((Object)"</td>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)"</tr>");
            _builder.newLine();
        }
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder.toString();
    }

    public CharSequence header(Module module) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h1>");
        String _name = module.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"</h1>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"<h2>Base Information</h2>");
        _builder.newLine();
        _builder.append((Object)"<table>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _strong = this.strong("prefix");
        _builder.append((Object)_strong, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _prefix = module.getPrefix();
        _builder.append((Object)_prefix, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _strong_1 = this.strong("namespace");
        _builder.append((Object)_strong_1, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        URI _namespace = module.getNamespace();
        _builder.append((Object)_namespace, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _strong_2 = this.strong("revision");
        _builder.append((Object)_strong_2, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        Date _revision = module.getRevision();
        String _format = REVISION_FORMAT.format(_revision);
        _builder.append((Object)_format, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _strong_3 = this.strong("description");
        _builder.append((Object)_strong_3, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _description = module.getDescription();
        _builder.append((Object)_description, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _strong_4 = this.strong("yang-version");
        _builder.append((Object)_strong_4, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"        ");
        _builder.append((Object)"<td>");
        String _yangVersion = module.getYangVersion();
        _builder.append((Object)_yangVersion, "        ");
        _builder.append((Object)"</td>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<tr>");
        _builder.newLine();
        Set _imports = module.getImports();
        boolean _hasElements = false;
        for (ModuleImport imp : _imports) {
            boolean _tripleNotEquals;
            if (!_hasElements) {
                _hasElements = true;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)"<td>");
                String _strong_5 = this.strong("imports");
                _builder_1.append((Object)_strong_5, "");
                _builder_1.append((Object)"</td><td>");
                _builder.append((Object)_builder_1.toString(), "        ");
            }
            _builder.append((Object)"        ");
            String _prefix_1 = imp.getPrefix();
            _builder.append((Object)_prefix_1, "        ");
            _builder.append((Object)":");
            String _moduleName = imp.getModuleName();
            _builder.append((Object)_moduleName, "        ");
            Date _revision_1 = imp.getRevision();
            boolean bl = _tripleNotEquals = _revision_1 != null;
            if (_tripleNotEquals) {
                _builder.append((Object)" ");
                Date _revision_2 = imp.getRevision();
                String _format_1 = REVISION_FORMAT.format(_revision_2);
                _builder.append((Object)_format_1, "        ");
            }
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append((Object)"</td>");
            _builder.append((Object)_builder_2.toString(), "        ");
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"</tr>");
        _builder.newLine();
        _builder.append((Object)"</table>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence schemaPathToId(SchemaPath path) {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = path != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            List _path = path.getPath();
            boolean _hasElements = false;
            for (QName qName : _path) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"/", "");
                }
                String _localName = qName.getLocalName();
                _builder.append((Object)_localName, "");
            }
            return _builder;
        }
        return null;
    }

    public CharSequence code(String string) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<code>");
        _builder.append((Object)string, "");
        _builder.append((Object)"</code>");
        return _builder;
    }

    public void process(Module module) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CharSequence tree(Module module) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = module.getName();
        String _strong = this.strong(_name);
        _builder.append((Object)_strong, "");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = module.getChildNodes();
        YangInstanceIdentifier.InstanceIdentifierBuilder _builder_1 = YangInstanceIdentifier.builder();
        YangInstanceIdentifier _build = _builder_1.build();
        CharSequence _treeSet = this.treeSet(_childNodes, _build);
        _builder.append((Object)_treeSet, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _tree(ChoiceSchemaNode node, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _nodeName = this.nodeName((SchemaNode)node);
        _builder.append((Object)_nodeName, "");
        _builder.append((Object)" (choice)");
        _builder.newLineIfNotEmpty();
        Set _cases = node.getCases();
        CharSequence _casesTree = this.casesTree(_cases, path);
        _builder.append((Object)_casesTree, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence casesTree(Set<ChoiceCaseNode> nodes, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        for (ChoiceCaseNode node : nodes) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            CharSequence _nodeName = this.nodeName((SchemaNode)node);
            _builder.append((Object)_nodeName, "");
            _builder.newLineIfNotEmpty();
            Collection _childNodes = node.getChildNodes();
            CharSequence _treeSet = this.treeSet(_childNodes, path);
            _builder.append((Object)_treeSet, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _tree(DataSchemaNode node, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _nodeName = this.nodeName((SchemaNode)node);
        _builder.append((Object)_nodeName, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _tree(ListSchemaNode node, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        YangInstanceIdentifier newPath = this.append(path, node);
        _builder.newLineIfNotEmpty();
        CharSequence _nodeName = this.nodeName((SchemaNode)node);
        CharSequence _localLink = this.localLink(newPath, _nodeName);
        _builder.append((Object)_localLink, "");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = node.getChildNodes();
        CharSequence _treeSet = this.treeSet(_childNodes, newPath);
        _builder.append((Object)_treeSet, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _tree(ContainerSchemaNode node, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        YangInstanceIdentifier newPath = this.append(path, node);
        _builder.newLineIfNotEmpty();
        CharSequence _nodeName = this.nodeName((SchemaNode)node);
        CharSequence _localLink = this.localLink(newPath, _nodeName);
        _builder.append((Object)_localLink, "");
        _builder.newLineIfNotEmpty();
        Collection _childNodes = node.getChildNodes();
        CharSequence _treeSet = this.treeSet(_childNodes, newPath);
        _builder.append((Object)_treeSet, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence childNodes(Module module) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        Collection childNodes = module.getChildNodes();
        _builder.newLineIfNotEmpty();
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)childNodes);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append((Object)"<h2>Child nodes</h2>");
            _builder.newLine();
            _builder.newLine();
            YangInstanceIdentifier.InstanceIdentifierBuilder _builder_1 = YangInstanceIdentifier.builder();
            YangInstanceIdentifier _build = _builder_1.build();
            CharSequence _printChildren = this.printChildren(childNodes, 3, _build);
            _builder.append((Object)_printChildren, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence printSchemaNodeInfo(DataSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        CharSequence _printBaseInfo = this.printBaseInfo((SchemaNode)node);
        _builder.append((Object)_printBaseInfo, "");
        _builder.newLineIfNotEmpty();
        if (node instanceof DataNodeContainer) {
            DataNodeContainer dataNode = (DataNodeContainer)node;
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            Set _uses = dataNode.getUses();
            for (UsesNode usesNode : _uses) {
                CharSequence _printUses = this.printUses(usesNode);
                _builder.append((Object)_printUses, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            Set typeDefinitions = dataNode.getTypeDefinitions();
            _builder.newLineIfNotEmpty();
            for (TypeDefinition typeDef : typeDefinitions) {
                CharSequence _restrictions = this.restrictions(typeDef);
                _builder.append((Object)_restrictions, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            Set _groupings = dataNode.getGroupings();
            for (GroupingDefinition grouping : _groupings) {
                CharSequence _printGrouping = this.printGrouping(grouping);
                _builder.append((Object)_printGrouping, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            Collection _childNodes = dataNode.getChildNodes();
            for (DataSchemaNode child : _childNodes) {
                CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo(child);
                _builder.append((Object)_printSchemaNodeInfo, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder;
    }

    public String typeAnchorLink(SchemaPath path, CharSequence text) {
        boolean _tripleNotEquals;
        boolean bl = _tripleNotEquals = path != null;
        if (_tripleNotEquals) {
            URI _namespace;
            Iterable _pathFromRoot = path.getPathFromRoot();
            QName lastElement = (QName)Iterables.getLast((Iterable)_pathFromRoot);
            URI ns = lastElement.getNamespace();
            boolean _equals = Objects.equal((Object)ns, (Object)(_namespace = this.currentModule.getNamespace()));
            if (_equals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"<a href=\"#");
                CharSequence _schemaPathToId = this.schemaPathToId(path);
                _builder.append((Object)_schemaPathToId, "");
                _builder.append((Object)"\">");
                _builder.append((Object)text, "");
                _builder.append((Object)"</a>");
                return _builder.toString();
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"(");
            _builder_1.append((Object)ns, "");
            _builder_1.append((Object)")");
            _builder_1.append((Object)text, "");
            return _builder_1.toString();
        }
        return null;
    }

    public CharSequence printBaseInfo(SchemaNode node) {
        if (node instanceof LeafSchemaNode) {
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _printInfo = this.printInfo(node, "leaf");
            _builder.append((Object)_printInfo, "");
            _builder.newLineIfNotEmpty();
            TypeDefinition _type = ((LeafSchemaNode)node).getType();
            SchemaPath _path = null;
            if (_type != null) {
                _path = _type.getPath();
            }
            TypeDefinition _type_1 = ((LeafSchemaNode)node).getType();
            QName _qName = _type_1.getQName();
            String _localName = _qName.getLocalName();
            String _typeAnchorLink = this.typeAnchorLink(_path, _localName);
            CharSequence _listItem = this.listItem("type", _typeAnchorLink);
            _builder.append((Object)_listItem, "");
            _builder.newLineIfNotEmpty();
            String _units = ((LeafSchemaNode)node).getUnits();
            CharSequence _listItem_1 = this.listItem("units", _units);
            _builder.append((Object)_listItem_1, "");
            _builder.newLineIfNotEmpty();
            String _default = ((LeafSchemaNode)node).getDefault();
            CharSequence _listItem_2 = this.listItem("default", _default);
            _builder.append((Object)_listItem_2, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</ul>");
            _builder.newLine();
            return _builder;
        }
        if (node instanceof LeafListSchemaNode) {
            StringConcatenation _builder_1 = new StringConcatenation();
            CharSequence _printInfo_1 = this.printInfo(node, "leaf-list");
            _builder_1.append((Object)_printInfo_1, "");
            _builder_1.newLineIfNotEmpty();
            TypeDefinition _type_2 = ((LeafListSchemaNode)node).getType();
            QName _qName_1 = null;
            if (_type_2 != null) {
                _qName_1 = _type_2.getQName();
            }
            String _localName_1 = _qName_1.getLocalName();
            CharSequence _listItem_3 = this.listItem("type", _localName_1);
            _builder_1.append((Object)_listItem_3, "");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append((Object)"</ul>");
            _builder_1.newLine();
            return _builder_1;
        }
        if (node instanceof ListSchemaNode) {
            StringConcatenation _builder_2 = new StringConcatenation();
            CharSequence _printInfo_2 = this.printInfo(node, "list");
            _builder_2.append((Object)_printInfo_2, "");
            _builder_2.newLineIfNotEmpty();
            List _keyDefinition = ((ListSchemaNode)node).getKeyDefinition();
            for (QName keyDef : _keyDefinition) {
                String _localName_2 = keyDef.getLocalName();
                CharSequence _listItem_4 = this.listItem("key definition", _localName_2);
                _builder_2.append((Object)_listItem_4, "");
                _builder_2.newLineIfNotEmpty();
            }
            _builder_2.append((Object)"</ul>");
            _builder_2.newLine();
            return _builder_2;
        }
        if (node instanceof ChoiceSchemaNode) {
            StringConcatenation _builder_3 = new StringConcatenation();
            CharSequence _printInfo_3 = this.printInfo(node, "choice");
            _builder_3.append((Object)_printInfo_3, "");
            _builder_3.newLineIfNotEmpty();
            String _defaultCase = ((ChoiceSchemaNode)node).getDefaultCase();
            CharSequence _listItem_5 = this.listItem("default case", _defaultCase);
            _builder_3.append((Object)_listItem_5, "");
            _builder_3.newLineIfNotEmpty();
            Set _cases = ((ChoiceSchemaNode)node).getCases();
            for (ChoiceCaseNode caseNode : _cases) {
                CharSequence _printSchemaNodeInfo = this.printSchemaNodeInfo((DataSchemaNode)caseNode);
                _builder_3.append((Object)_printSchemaNodeInfo, "");
                _builder_3.newLineIfNotEmpty();
            }
            _builder_3.append((Object)"</ul>");
            _builder_3.newLine();
            return _builder_3;
        }
        if (node instanceof ChoiceCaseNode) {
            StringConcatenation _builder_4 = new StringConcatenation();
            CharSequence _printInfo_4 = this.printInfo(node, "case");
            _builder_4.append((Object)_printInfo_4, "");
            _builder_4.newLineIfNotEmpty();
            _builder_4.append((Object)"</ul>");
            _builder_4.newLine();
            return _builder_4;
        }
        if (node instanceof ContainerSchemaNode) {
            StringConcatenation _builder_5 = new StringConcatenation();
            CharSequence _printInfo_5 = this.printInfo(node, "container");
            _builder_5.append((Object)_printInfo_5, "");
            _builder_5.newLineIfNotEmpty();
            _builder_5.append((Object)"</ul>");
            _builder_5.newLine();
            return _builder_5;
        }
        if (node instanceof AnyXmlSchemaNode) {
            StringConcatenation _builder_6 = new StringConcatenation();
            CharSequence _printInfo_6 = this.printInfo(node, "anyxml");
            _builder_6.append((Object)_printInfo_6, "");
            _builder_6.newLineIfNotEmpty();
            _builder_6.append((Object)"</ul>");
            _builder_6.newLine();
            return _builder_6;
        }
        return null;
    }

    public CharSequence printInfo(SchemaNode node, String nodeType) {
        StringConcatenation _builder = new StringConcatenation();
        if (node instanceof AugmentationTarget) {
            boolean _tripleNotEquals;
            boolean bl = _tripleNotEquals = node != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"<strong>");
                _builder.newLine();
                _builder.append((Object)"<li id=\"");
                SchemaPath _path = node.getPath();
                CharSequence _schemaPathToId = this.schemaPathToId(_path);
                _builder.append((Object)_schemaPathToId, "");
                _builder.append((Object)"\">");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)nodeType, "    ");
                _builder.append((Object)": ");
                QName _qName = node.getQName();
                String _localName = _qName.getLocalName();
                _builder.append((Object)_localName, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</li>");
                _builder.newLine();
                _builder.append((Object)"</strong>");
                _builder.newLine();
            }
        } else {
            QName _qName_1 = node.getQName();
            String _localName_1 = _qName_1.getLocalName();
            CharSequence _listItem = this.listItem(nodeType, _localName_1);
            String _strong = this.strong(_listItem);
            _builder.append((Object)_strong, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"<ul>");
        _builder.newLine();
        String _description = node.getDescription();
        CharSequence _listItem_1 = this.listItem("description", _description);
        _builder.append((Object)_listItem_1, "");
        _builder.newLineIfNotEmpty();
        String _reference = node.getReference();
        CharSequence _listItem_2 = this.listItem("reference", _reference);
        _builder.append((Object)_listItem_2, "");
        _builder.newLineIfNotEmpty();
        if (node instanceof DataSchemaNode) {
            ConstraintDefinition _constraints = ((DataSchemaNode)node).getConstraints();
            RevisionAwareXPath _whenCondition = _constraints.getWhenCondition();
            String _string = null;
            if (_whenCondition != null) {
                _string = _whenCondition.toString();
            }
            CharSequence _listItem_3 = this.listItem("when condition", _string);
            _builder.append((Object)_listItem_3, "");
            _builder.newLineIfNotEmpty();
            ConstraintDefinition _constraints_1 = ((DataSchemaNode)node).getConstraints();
            Integer _minElements = _constraints_1.getMinElements();
            String _string_1 = null;
            if (_minElements != null) {
                _string_1 = _minElements.toString();
            }
            CharSequence _listItem_4 = this.listItem("min elements", _string_1);
            _builder.append((Object)_listItem_4, "");
            _builder.newLineIfNotEmpty();
            ConstraintDefinition _constraints_2 = ((DataSchemaNode)node).getConstraints();
            Integer _maxElements = _constraints_2.getMaxElements();
            String _string_2 = null;
            if (_maxElements != null) {
                _string_2 = _maxElements.toString();
            }
            CharSequence _listItem_5 = this.listItem("max elements", _string_2);
            _builder.append((Object)_listItem_5, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence printUses(UsesNode usesNode) {
        StringConcatenation _builder = new StringConcatenation();
        SchemaPath _groupingPath = usesNode.getGroupingPath();
        SchemaPath _groupingPath_1 = usesNode.getGroupingPath();
        Iterable _pathTowardsRoot = _groupingPath_1.getPathTowardsRoot();
        Iterator _iterator = _pathTowardsRoot.iterator();
        QName _next = (QName)_iterator.next();
        String _localName = _next.getLocalName();
        String _typeAnchorLink = this.typeAnchorLink(_groupingPath, _localName);
        CharSequence _listItem = this.listItem("uses", _typeAnchorLink);
        String _strong = this.strong(_listItem);
        _builder.append((Object)_strong, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"<li>refines:");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<ul>");
        _builder.newLine();
        Map _refines = usesNode.getRefines();
        Set _keySet = _refines.keySet();
        for (SchemaPath sp : _keySet) {
            _builder.append((Object)"    ");
            Map _refines_1 = usesNode.getRefines();
            SchemaNode _get = (SchemaNode)_refines_1.get(sp);
            QName _qName = _get.getQName();
            String _localName_1 = _qName.getLocalName();
            CharSequence _listItem_1 = this.listItem("node name", _localName_1);
            _builder.append((Object)_listItem_1, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"    ");
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        Set _augmentations = usesNode.getAugmentations();
        for (AugmentationSchema augment : _augmentations) {
            SchemaPath _targetPath = augment.getTargetPath();
            SchemaPath _targetPath_1 = augment.getTargetPath();
            String _schemaPathToString = this.schemaPathToString(this.currentModule, _targetPath_1, this.ctx, (DataNodeContainer)augment);
            String _typeAnchorLink_1 = this.typeAnchorLink(_targetPath, _schemaPathToString);
            _builder.append((Object)_typeAnchorLink_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printGrouping(GroupingDefinition grouping) {
        StringConcatenation _builder = new StringConcatenation();
        QName _qName = grouping.getQName();
        String _localName = _qName.getLocalName();
        CharSequence _listItem = this.listItem("grouping", _localName);
        String _strong = this.strong(_listItem);
        _builder.append((Object)_strong, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence printChildren(Iterable<DataSchemaNode> nodes, int level, YangInstanceIdentifier path) {
        boolean _greaterThan;
        int _size_4;
        int _size_3;
        int _size_2;
        int _size_1;
        Iterable anyxmlNodes = Iterables.filter(nodes, AnyXmlSchemaNode.class);
        Iterable leafNodes = Iterables.filter(nodes, LeafSchemaNode.class);
        Iterable leafListNodes = Iterables.filter(nodes, LeafListSchemaNode.class);
        Iterable choices = Iterables.filter(nodes, ChoiceSchemaNode.class);
        Iterable cases = Iterables.filter(nodes, ChoiceCaseNode.class);
        Iterable containers = Iterables.filter(nodes, ContainerSchemaNode.class);
        Iterable lists = Iterables.filter(nodes, ListSchemaNode.class);
        StringConcatenation _builder = new StringConcatenation();
        int _size = IterableExtensions.size((Iterable)anyxmlNodes);
        int _plus = _size + (_size_1 = IterableExtensions.size((Iterable)leafNodes));
        int _plus_1 = _plus + (_size_2 = IterableExtensions.size((Iterable)leafListNodes));
        int _plus_2 = _plus_1 + (_size_3 = IterableExtensions.size((Iterable)containers));
        int _plus_3 = _plus_2 + (_size_4 = IterableExtensions.size((Iterable)lists));
        boolean bl = _greaterThan = _plus_3 > 0;
        if (_greaterThan) {
            _builder.append((Object)"<h3>Direct children</h3>");
            _builder.newLine();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            for (AnyXmlSchemaNode childNode : anyxmlNodes) {
                CharSequence _printShortInfo = this.printShortInfo(childNode, level, path);
                _builder.append((Object)_printShortInfo, "");
                _builder.newLineIfNotEmpty();
            }
            for (LeafSchemaNode childNode_1 : leafNodes) {
                CharSequence _printShortInfo_1 = this.printShortInfo(childNode_1, level, path);
                _builder.append((Object)_printShortInfo_1, "");
                _builder.newLineIfNotEmpty();
            }
            for (LeafListSchemaNode childNode_2 : leafListNodes) {
                CharSequence _printShortInfo_2 = this.printShortInfo(childNode_2, level, path);
                _builder.append((Object)_printShortInfo_2, "");
                _builder.newLineIfNotEmpty();
            }
            for (ContainerSchemaNode childNode_3 : containers) {
                CharSequence _printShortInfo_3 = this.printShortInfo(childNode_3, level, path);
                _builder.append((Object)_printShortInfo_3, "");
                _builder.newLineIfNotEmpty();
            }
            for (ListSchemaNode childNode_4 : lists) {
                CharSequence _printShortInfo_4 = this.printShortInfo(childNode_4, level, path);
                _builder.append((Object)_printShortInfo_4, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        _builder.newLine();
        List _pathArguments = path.getPathArguments();
        Iterator _iterator = _pathArguments.iterator();
        boolean _hasNext = _iterator.hasNext();
        if (_hasNext) {
            _builder.append((Object)"<h3>XML example</h3>");
            _builder.newLine();
            List _pathArguments_1 = path.getPathArguments();
            YangInstanceIdentifier.PathArgument _last = (YangInstanceIdentifier.PathArgument)IterableExtensions.last((Iterable)_pathArguments_1);
            QName _nodeType = _last.getNodeType();
            CharSequence _xmlExample = this.xmlExample(nodes, _nodeType, path);
            _builder.append((Object)_xmlExample, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</h3>");
            _builder.newLine();
        }
        for (ContainerSchemaNode childNode_5 : containers) {
            CharSequence _printInfo = this.printInfo((DataSchemaNode)childNode_5, level, path);
            _builder.append((Object)_printInfo, "");
            _builder.newLineIfNotEmpty();
        }
        for (ListSchemaNode childNode_6 : lists) {
            CharSequence _printInfo_1 = this.printInfo((DataSchemaNode)childNode_6, level, path);
            _builder.append((Object)_printInfo_1, "");
            _builder.newLineIfNotEmpty();
        }
        for (ChoiceSchemaNode childNode_7 : choices) {
            CharSequence _printInfo_2 = this.printInfo((DataSchemaNode)childNode_7, level, path);
            _builder.append((Object)_printInfo_2, "");
            _builder.newLineIfNotEmpty();
        }
        for (ChoiceCaseNode childNode_8 : cases) {
            CharSequence _printInfo_3 = this.printInfo((DataSchemaNode)childNode_8, level, path);
            _builder.append((Object)_printInfo_3, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence xmlExample(Iterable<DataSchemaNode> nodes, QName name, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<pre>");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _xmplExampleTags = this.xmplExampleTags(nodes, path);
        String _xmlExampleTag = this.xmlExampleTag(name, _xmplExampleTags);
        _builder.append((Object)_xmlExampleTag, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</pre>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence xmplExampleTags(Iterable<DataSchemaNode> nodes, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<!-- Child nodes -->");
        _builder.newLine();
        for (DataSchemaNode node : nodes) {
            _builder.append((Object)"<!-- ");
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            _builder.append((Object)_localName, "");
            _builder.append((Object)" -->");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"    ");
            CharSequence _asXmlExampleTag = this.asXmlExampleTag(node, identifier);
            _builder.append((Object)_asXmlExampleTag, "    ");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        return _builder;
    }

    private CharSequence _asXmlExampleTag(LeafSchemaNode node, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        QName _qName = node.getQName();
        String _xmlExampleTag = this.xmlExampleTag(_qName, "...");
        _builder.append((Object)_xmlExampleTag, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _asXmlExampleTag(LeafListSchemaNode node, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt!-- This node could appear multiple times --&gt");
        _builder.newLine();
        QName _qName = node.getQName();
        String _xmlExampleTag = this.xmlExampleTag(_qName, "...");
        _builder.append((Object)_xmlExampleTag, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _asXmlExampleTag(ContainerSchemaNode node, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt!-- See ");
        YangInstanceIdentifier _append = this.append(identifier, node);
        CharSequence _localLink = this.localLink(_append, "definition");
        _builder.append((Object)_localLink, "");
        _builder.append((Object)" for child nodes.  --&gt");
        _builder.newLineIfNotEmpty();
        QName _qName = node.getQName();
        String _xmlExampleTag = this.xmlExampleTag(_qName, "...");
        _builder.append((Object)_xmlExampleTag, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _asXmlExampleTag(ListSchemaNode node, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt!-- See ");
        YangInstanceIdentifier _append = this.append(identifier, node);
        CharSequence _localLink = this.localLink(_append, "definition");
        _builder.append((Object)_localLink, "");
        _builder.append((Object)" for child nodes.  --&gt");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"&lt!-- This node could appear multiple times --&gt");
        _builder.newLine();
        QName _qName = node.getQName();
        String _xmlExampleTag = this.xmlExampleTag(_qName, "...");
        _builder.append((Object)_xmlExampleTag, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _asXmlExampleTag(DataSchemaNode node, YangInstanceIdentifier identifier) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<!-- noop -->");
        _builder.newLine();
        return _builder;
    }

    public String xmlExampleTag(QName name, CharSequence data) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"&lt;");
        String _localName = name.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)" xmlns=\"");
        URI _namespace = name.getNamespace();
        _builder.append((Object)_namespace, "");
        _builder.append((Object)"\"&gt;");
        _builder.append((Object)data, "");
        _builder.append((Object)"&lt;/");
        String _localName_1 = name.getLocalName();
        _builder.append((Object)_localName_1, "");
        _builder.append((Object)"&gt;");
        return _builder.toString();
    }

    public CharSequence header(int level, QName name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h");
        _builder.append((Object)level, "");
        _builder.append((Object)">");
        String _localName = name.getLocalName();
        _builder.append((Object)_localName, "");
        _builder.append((Object)"</h");
        _builder.append((Object)level, "");
        _builder.append((Object)">");
        return _builder;
    }

    public CharSequence header(int level, YangInstanceIdentifier name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<h");
        _builder.append((Object)level, "");
        _builder.append((Object)" id=\"");
        List _pathArguments = name.getPathArguments();
        boolean _hasElements = false;
        for (YangInstanceIdentifier.PathArgument cmp : _pathArguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"/", "");
            }
            QName _nodeType = cmp.getNodeType();
            String _localName = _nodeType.getLocalName();
            _builder.append((Object)_localName, "");
        }
        _builder.append((Object)"\">");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        List _pathArguments_1 = name.getPathArguments();
        boolean _hasElements_1 = false;
        for (YangInstanceIdentifier.PathArgument cmp_1 : _pathArguments_1) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder.appendImmediate((Object)"/", "    ");
            }
            QName _nodeType_1 = cmp_1.getNodeType();
            String _localName_1 = _nodeType_1.getLocalName();
            _builder.append((Object)_localName_1, "    ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</h");
        _builder.append((Object)level, "");
        _builder.append((Object)">");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _printInfo(DataSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        QName _qName = node.getQName();
        CharSequence _header = this.header(level + 1, _qName);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _printInfo(ContainerSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        YangInstanceIdentifier newPath = this.append(path, node);
        _builder.newLineIfNotEmpty();
        CharSequence _header = this.header(level, newPath);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<dl>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dt>XML Path</dt>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dd>");
        String _asXmlPath = this.asXmlPath(newPath);
        _builder.append((Object)_asXmlPath, "  ");
        _builder.append((Object)"</dd>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dt>Restconf path</dt>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dd>");
        String _asRestconfPath = this.asRestconfPath(newPath);
        CharSequence _code = this.code(_asRestconfPath);
        _builder.append((Object)_code, "  ");
        _builder.append((Object)"</dd>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</dl>");
        _builder.newLine();
        Collection _childNodes = node.getChildNodes();
        CharSequence _printChildren = this.printChildren(_childNodes, level, newPath);
        _builder.append((Object)_printChildren, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _printInfo(ListSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        YangInstanceIdentifier newPath = this.append(path, node);
        _builder.newLineIfNotEmpty();
        CharSequence _header = this.header(level, newPath);
        _builder.append((Object)_header, "");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<dl>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dt>XML Path</dt>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dd>");
        String _asXmlPath = this.asXmlPath(newPath);
        _builder.append((Object)_asXmlPath, "  ");
        _builder.append((Object)"</dd>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dt>Restconf path</dt>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<dd>");
        String _asRestconfPath = this.asRestconfPath(newPath);
        CharSequence _code = this.code(_asRestconfPath);
        _builder.append((Object)_code, "  ");
        _builder.append((Object)"</dd>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</dl>");
        _builder.newLine();
        Collection _childNodes = node.getChildNodes();
        CharSequence _printChildren = this.printChildren(_childNodes, level, newPath);
        _builder.append((Object)_printChildren, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _printInfo(ChoiceSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        Set _cases = node.getCases();
        HashSet<DataSchemaNode> choiceCases = new HashSet<DataSchemaNode>(_cases);
        _builder.newLineIfNotEmpty();
        CharSequence _printChildren = this.printChildren(choiceCases, level, path);
        _builder.append((Object)_printChildren, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _printInfo(ChoiceCaseNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        Collection _childNodes = node.getChildNodes();
        CharSequence _printChildren = this.printChildren(_childNodes, level, path);
        _builder.append((Object)_printChildren, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence printShortInfo(ContainerSchemaNode node, int level, YangInstanceIdentifier path) {
        YangInstanceIdentifier newPath = this.append(path, node);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<li>");
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        CharSequence _localLink = this.localLink(newPath, _localName);
        String _strong = this.strong(_localLink);
        _builder.append((Object)_strong, "");
        _builder.append((Object)" (container)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>configuration data: ");
        boolean _isConfiguration = node.isConfiguration();
        String _valueOf = String.valueOf(_isConfiguration);
        String _strong_1 = this.strong(_valueOf);
        _builder.append((Object)_strong_1, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printShortInfo(ListSchemaNode node, int level, YangInstanceIdentifier path) {
        YangInstanceIdentifier newPath = this.append(path, node);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<li>");
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        CharSequence _localLink = this.localLink(newPath, _localName);
        String _strong = this.strong(_localLink);
        _builder.append((Object)_strong, "");
        _builder.append((Object)" (list)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>configuration data: ");
        boolean _isConfiguration = node.isConfiguration();
        String _valueOf = String.valueOf(_isConfiguration);
        String _strong_1 = this.strong(_valueOf);
        _builder.append((Object)_strong_1, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printShortInfo(AnyXmlSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<li>");
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        String _strong = this.strong(_localName);
        _builder.append((Object)_strong, "");
        _builder.append((Object)" (anyxml)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>configuration data: ");
        boolean _isConfiguration = node.isConfiguration();
        String _valueOf = String.valueOf(_isConfiguration);
        String _strong_1 = this.strong(_valueOf);
        _builder.append((Object)_strong_1, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>mandatory: ");
        ConstraintDefinition _constraints = node.getConstraints();
        boolean _isMandatory = _constraints.isMandatory();
        String _valueOf_1 = String.valueOf(_isMandatory);
        String _strong_2 = this.strong(_valueOf_1);
        _builder.append((Object)_strong_2, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printShortInfo(LeafSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<li>");
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        String _strong = this.strong(_localName);
        _builder.append((Object)_strong, "");
        _builder.append((Object)" (leaf)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>configuration data: ");
        boolean _isConfiguration = node.isConfiguration();
        String _valueOf = String.valueOf(_isConfiguration);
        String _strong_1 = this.strong(_valueOf);
        _builder.append((Object)_strong_1, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>mandatory: ");
        ConstraintDefinition _constraints = node.getConstraints();
        boolean _isMandatory = _constraints.isMandatory();
        String _valueOf_1 = String.valueOf(_isMandatory);
        String _strong_2 = this.strong(_valueOf_1);
        _builder.append((Object)_strong_2, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence printShortInfo(LeafListSchemaNode node, int level, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<li>");
        QName _qName = node.getQName();
        String _localName = _qName.getLocalName();
        String _strong = this.strong(_localName);
        _builder.append((Object)_strong, "");
        _builder.append((Object)" (leaf-list)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<li>configuration data: ");
        boolean _isConfiguration = node.isConfiguration();
        String _valueOf = String.valueOf(_isConfiguration);
        String _strong_1 = this.strong(_valueOf);
        _builder.append((Object)_strong_1, "    ");
        _builder.append((Object)"</li>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        _builder.append((Object)"</li>");
        _builder.newLine();
        return _builder;
    }

    public CharSequence anchorLink(CharSequence anchor, CharSequence text) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<a href=\"#");
        _builder.append((Object)anchor, "");
        _builder.append((Object)"\">");
        _builder.append((Object)text, "");
        _builder.append((Object)"</a>");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence localLink(YangInstanceIdentifier identifier, CharSequence text) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<a href=\"#");
        List _pathArguments = identifier.getPathArguments();
        boolean _hasElements = false;
        for (YangInstanceIdentifier.PathArgument cmp : _pathArguments) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"/", "");
            }
            QName _nodeType = cmp.getNodeType();
            String _localName = _nodeType.getLocalName();
            _builder.append((Object)_localName, "");
        }
        _builder.append((Object)"\">");
        _builder.append((Object)text, "");
        _builder.append((Object)"</a>");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private YangInstanceIdentifier _append(YangInstanceIdentifier identifier, ContainerSchemaNode node) {
        QName _qName = node.getQName();
        return identifier.node(_qName);
    }

    private YangInstanceIdentifier _append(YangInstanceIdentifier identifier, ListSchemaNode node) {
        boolean _tripleNotEquals;
        LinkedHashMap<QName, Object> keyValues = new LinkedHashMap<QName, Object>();
        List _keyDefinition = node.getKeyDefinition();
        boolean bl = _tripleNotEquals = _keyDefinition != null;
        if (_tripleNotEquals) {
            List _keyDefinition_1 = node.getKeyDefinition();
            for (QName definition : _keyDefinition_1) {
                Object _object = new Object();
                keyValues.put(definition, _object);
            }
        }
        QName _qName = node.getQName();
        YangInstanceIdentifier.NodeIdentifierWithPredicates _nodeIdentifierWithPredicates = new YangInstanceIdentifier.NodeIdentifierWithPredicates(_qName, keyValues);
        return identifier.node((YangInstanceIdentifier.PathArgument)_nodeIdentifierWithPredicates);
    }

    public String asXmlPath(YangInstanceIdentifier identifier) {
        return "";
    }

    public String asRestconfPath(YangInstanceIdentifier identifier) {
        StringBuilder it = new StringBuilder();
        String _name = this.currentModule.getName();
        it.append(_name);
        it.append(":");
        boolean previous = false;
        List _pathArguments = identifier.getPathArguments();
        for (YangInstanceIdentifier.PathArgument arg : _pathArguments) {
            if (previous) {
                it.append("/");
            }
            QName _nodeType = arg.getNodeType();
            String _localName = _nodeType.getLocalName();
            it.append(_localName);
            previous = true;
            if (!(arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates)) continue;
            Map _keyValues = ((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg).getKeyValues();
            Set _keySet = _keyValues.keySet();
            for (QName qname : _keySet) {
                it.append("/{");
                String _localName_1 = qname.getLocalName();
                it.append(_localName_1);
                it.append("}");
            }
        }
        return it.toString();
    }

    private String schemaPathToString(Module module, SchemaPath schemaPath, SchemaContext ctx, DataNodeContainer dataNode) {
        List path = schemaPath.getPath();
        StringBuilder pathString = new StringBuilder();
        boolean _isAbsolute = schemaPath.isAbsolute();
        if (_isAbsolute) {
            pathString.append("/");
        }
        QName qname = (QName)path.get(0);
        URI _namespace = qname.getNamespace();
        Date _revision = qname.getRevision();
        Module parent = ctx.findModuleByNamespaceAndRevision(_namespace, _revision);
        for (QName name : path) {
            boolean _tripleNotEquals;
            if (!(parent instanceof DataNodeContainer)) continue;
            DataSchemaNode node = ((DataNodeContainer)parent).getDataChildByName(name);
            boolean _and = false;
            boolean _equals = Objects.equal((Object)node, null);
            _and = !_equals ? false : parent instanceof Module;
            if (_and) {
                Set notifications = parent.getNotifications();
                for (NotificationDefinition notification : notifications) {
                    QName _qName = notification.getQName();
                    boolean _equals_1 = _qName.equals((Object)name);
                    if (!_equals_1) continue;
                    node = notification;
                }
            }
            boolean _and_1 = false;
            boolean _equals_2 = Objects.equal((Object)node, null);
            _and_1 = !_equals_2 ? false : parent instanceof Module;
            if (_and_1) {
                Set rpcs = parent.getRpcs();
                for (RpcDefinition rpc : rpcs) {
                    QName _qName_1 = rpc.getQName();
                    boolean _equals_3 = _qName_1.equals((Object)name);
                    if (!_equals_3) continue;
                    node = rpc;
                }
            }
            URI _namespace_1 = name.getNamespace();
            Date _revision_1 = name.getRevision();
            Module pathElementModule = ctx.findModuleByNamespaceAndRevision(_namespace_1, _revision_1);
            String moduleName = pathElementModule.getName();
            pathString.append(moduleName);
            pathString.append(":");
            String _localName = name.getLocalName();
            pathString.append(_localName);
            pathString.append("/");
            boolean _and_2 = false;
            _and_2 = !(node instanceof ChoiceSchemaNode) ? false : (_tripleNotEquals = dataNode != null);
            if (_and_2) {
                boolean _tripleNotEquals_1;
                Functions.Function1<DataSchemaNode, Boolean> _function;
                Collection _childNodes = dataNode.getChildNodes();
                DataSchemaNode caseNode = (DataSchemaNode)IterableExtensions.findFirst((Iterable)_childNodes, (Functions.Function1)(_function = new Functions.Function1<DataSchemaNode, Boolean>(){

                    public Boolean apply(DataSchemaNode e) {
                        return e instanceof ChoiceCaseNode;
                    }
                }));
                boolean bl = _tripleNotEquals_1 = caseNode != null;
                if (_tripleNotEquals_1) {
                    pathString.append("(case)");
                    QName _qName_2 = caseNode.getQName();
                    String _localName_1 = _qName_2.getLocalName();
                    pathString.append(_localName_1);
                }
            }
            parent = node;
        }
        return pathString.toString();
    }

    public CharSequence childNodesInfoTree(Map<SchemaPath, DataSchemaNode> childNodes) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _tripleNotEquals = childNodes != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = childNodes.isEmpty()));
        if (_and) {
            Collection<DataSchemaNode> _values = childNodes.values();
            for (DataSchemaNode child : _values) {
                CharSequence _childInfo = this.childInfo(child, childNodes);
                _builder.append((Object)_childInfo, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence childInfo(DataSchemaNode node, Map<SchemaPath, DataSchemaNode> childNodes) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String path = this.nodeSchemaPathToPath(node, childNodes);
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)path, null);
        if (_notEquals) {
            boolean _tripleNotEquals;
            CharSequence _code = this.code(path);
            _builder.append((Object)_code, "");
            _builder.newLineIfNotEmpty();
            boolean bl2 = _tripleNotEquals = node != null;
            if (_tripleNotEquals) {
                _builder.append((Object)"    ");
                _builder.append((Object)"<ul>");
                _builder.newLine();
                _builder.append((Object)"    ");
                CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)node);
                _builder.append((Object)_descAndRefLi, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"    ");
                _builder.append((Object)"</ul>");
                _builder.newLine();
            }
        }
        return _builder;
    }

    private CharSequence treeSet(Collection<DataSchemaNode> childNodes, YangInstanceIdentifier path) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _tripleNotEquals = childNodes != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = childNodes.isEmpty()));
        if (_and) {
            _builder.append((Object)"<ul>");
            _builder.newLine();
            for (DataSchemaNode child : childNodes) {
                _builder.append((Object)"<li>");
                _builder.newLine();
                _builder.append((Object)"    ");
                CharSequence _tree = this.tree(child, path);
                _builder.append((Object)_tree, "    ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"</li>");
                _builder.newLine();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence listKeys(ListSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"[");
        List _keyDefinition = node.getKeyDefinition();
        boolean _hasElements = false;
        for (QName key : _keyDefinition) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)" ", "");
            }
            String _localName = key.getLocalName();
            _builder.append((Object)_localName, "");
        }
        _builder.append((Object)"]");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence extensionInfo(ExtensionDefinition ext) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ul>");
        _builder.newLine();
        _builder.append((Object)"    ");
        CharSequence _descAndRefLi = this.descAndRefLi((SchemaNode)ext);
        _builder.append((Object)_descAndRefLi, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        String _argument = ext.getArgument();
        CharSequence _listItem = this.listItem("Argument", _argument);
        _builder.append((Object)_listItem, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ul>");
        _builder.newLine();
        return _builder;
    }

    private CharSequence _tree(Void obj, YangInstanceIdentifier path) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    private CharSequence restrictions(TypeDefinition<?> type) {
        StringConcatenation _builder = new StringConcatenation();
        TypeDefinition _baseType = type.getBaseType();
        CharSequence _baseStmt = this.toBaseStmt(_baseType);
        _builder.append((Object)_baseStmt, "");
        _builder.newLineIfNotEmpty();
        CharSequence _length = this.toLength(type);
        _builder.append((Object)_length, "");
        _builder.newLineIfNotEmpty();
        CharSequence _range = this.toRange(type);
        _builder.append((Object)_range, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toLength(TypeDefinition<?> type) {
        return null;
    }

    private CharSequence _toLength(BinaryTypeDefinition type) {
        StringConcatenation _builder = new StringConcatenation();
        List _lengthConstraints = type.getLengthConstraints();
        CharSequence _lengthStmt = this.toLengthStmt(_lengthConstraints);
        _builder.append((Object)_lengthStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toLength(StringTypeDefinition type) {
        StringConcatenation _builder = new StringConcatenation();
        List _lengthConstraints = type.getLengthConstraints();
        CharSequence _lengthStmt = this.toLengthStmt(_lengthConstraints);
        _builder.append((Object)_lengthStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toLength(ExtendedType type) {
        StringConcatenation _builder = new StringConcatenation();
        List _lengthConstraints = type.getLengthConstraints();
        CharSequence _lengthStmt = this.toLengthStmt(_lengthConstraints);
        _builder.append((Object)_lengthStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toRange(TypeDefinition<?> type) {
        return null;
    }

    private CharSequence _toRange(DecimalTypeDefinition type) {
        StringConcatenation _builder = new StringConcatenation();
        List _rangeConstraints = type.getRangeConstraints();
        CharSequence _rangeStmt = this.toRangeStmt(_rangeConstraints);
        _builder.append((Object)_rangeStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toRange(IntegerTypeDefinition type) {
        StringConcatenation _builder = new StringConcatenation();
        List _rangeConstraints = type.getRangeConstraints();
        CharSequence _rangeStmt = this.toRangeStmt(_rangeConstraints);
        _builder.append((Object)_rangeStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toRange(UnsignedIntegerTypeDefinition type) {
        StringConcatenation _builder = new StringConcatenation();
        List _rangeConstraints = type.getRangeConstraints();
        CharSequence _rangeStmt = this.toRangeStmt(_rangeConstraints);
        _builder.append((Object)_rangeStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence _toRange(ExtendedType type) {
        StringConcatenation _builder = new StringConcatenation();
        List _rangeConstraints = type.getRangeConstraints();
        CharSequence _rangeStmt = this.toRangeStmt(_rangeConstraints);
        _builder.append((Object)_rangeStmt, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence toLengthStmt(Collection<LengthConstraint> lengths) {
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal(lengths, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = lengths.isEmpty()));
        if (_and) {
            CharSequence _listItem = this.listItem("Length restrictions:");
            _builder.append((Object)_listItem, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            for (LengthConstraint length : lengths) {
                _builder.append((Object)"<li>");
                _builder.newLine();
                Number _min = length.getMin();
                Number _max = length.getMax();
                boolean _equals = Objects.equal((Object)_min, (Object)_max);
                if (_equals) {
                    Number _min_1 = length.getMin();
                    _builder.append((Object)_min_1, "");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"&lt;");
                    Number _min_2 = length.getMin();
                    _builder.append((Object)_min_2, "");
                    _builder.append((Object)", ");
                    Number _max_1 = length.getMax();
                    _builder.append((Object)_max_1, "");
                    _builder.append((Object)"&gt;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"</li>");
                _builder.newLine();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence toRangeStmt(Collection<RangeConstraint> ranges) {
        boolean _isEmpty;
        boolean _not;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _notEquals = !Objects.equal(ranges, null);
        _and = !_notEquals ? false : (_not = !(_isEmpty = ranges.isEmpty()));
        if (_and) {
            CharSequence _listItem = this.listItem("Range restrictions:");
            _builder.append((Object)_listItem, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"<ul>");
            _builder.newLine();
            for (RangeConstraint range : ranges) {
                _builder.append((Object)"<li>");
                _builder.newLine();
                Number _min = range.getMin();
                Number _max = range.getMax();
                boolean _equals = Objects.equal((Object)_min, (Object)_max);
                if (_equals) {
                    Number _min_1 = range.getMin();
                    _builder.append((Object)_min_1, "");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"&lt;");
                    Number _min_2 = range.getMin();
                    _builder.append((Object)_min_2, "");
                    _builder.append((Object)", ");
                    Number _max_1 = range.getMax();
                    _builder.append((Object)_max_1, "");
                    _builder.append((Object)"&gt;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"</li>");
                _builder.newLine();
            }
            _builder.append((Object)"</ul>");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence toBaseStmt(TypeDefinition<?> baseType) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean bl = _notEquals = !Objects.equal(baseType, null);
        if (_notEquals) {
            SchemaPath _path = null;
            if (baseType != null) {
                _path = baseType.getPath();
            }
            QName _qName = baseType.getQName();
            String _localName = _qName.getLocalName();
            String _typeAnchorLink = this.typeAnchorLink(_path, _localName);
            CharSequence _listItem = this.listItem("Base type", _typeAnchorLink);
            _builder.append((Object)_listItem, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String strong(CharSequence str) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<strong>");
        _builder.append((Object)str, "");
        _builder.append((Object)"</strong>");
        return _builder.toString();
    }

    private CharSequence italic(CharSequence str) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<i>");
        _builder.append((Object)str, "");
        _builder.append((Object)"</i>");
        return _builder;
    }

    public CharSequence descAndRefLi(SchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        String _description = node.getDescription();
        CharSequence _listItem = this.listItem("Description", _description);
        _builder.append((Object)_listItem, "");
        _builder.newLineIfNotEmpty();
        String _reference = node.getReference();
        CharSequence _listItem_1 = this.listItem("Reference", _reference);
        _builder.append((Object)_listItem_1, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence descAndRef(SchemaNode node) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _description = node.getDescription();
        _builder.append((Object)_description, "");
        _builder.newLineIfNotEmpty();
        String _reference = node.getReference();
        boolean bl = _tripleNotEquals = _reference != null;
        if (_tripleNotEquals) {
            _builder.append((Object)"Reference ");
            String _reference_1 = node.getReference();
            _builder.append((Object)_reference_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence listItem(String value) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _tripleNotEquals = value != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = value.isEmpty()));
        if (_and) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)value, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence listItem(String name, String value) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        boolean bl = _tripleNotEquals = value != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = value.isEmpty()));
        if (_and) {
            _builder.append((Object)"<li>");
            _builder.newLine();
            _builder.append((Object)"    ");
            _builder.append((Object)name, "    ");
            _builder.append((Object)": ");
            _builder.append((Object)value, "    ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"</li>");
            _builder.newLine();
        }
        return _builder;
    }

    private String nodeSchemaPathToPath(DataSchemaNode node, Map<SchemaPath, DataSchemaNode> childNodes) {
        boolean _isEmpty;
        boolean _not;
        boolean _tripleNotEquals;
        boolean _or = false;
        _or = node instanceof ChoiceSchemaNode ? true : node instanceof ChoiceCaseNode;
        if (_or) {
            return null;
        }
        SchemaPath _path = node.getPath();
        List path = _path.getPath();
        SchemaPath _path_1 = node.getPath();
        boolean absolute = _path_1.isAbsolute();
        StringBuilder result = new StringBuilder();
        if (absolute) {
            result.append("/");
        }
        boolean _and = false;
        boolean bl = _tripleNotEquals = path != null;
        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = path.isEmpty()));
        if (_and) {
            ArrayList<QName> actual = new ArrayList<QName>();
            int i = 0;
            for (QName pathElement : path) {
                actual.add(pathElement);
                SchemaPath _create = SchemaPath.create(actual, (boolean)absolute);
                DataSchemaNode nodeByPath = childNodes.get(_create);
                if (!(nodeByPath instanceof ChoiceSchemaNode) && !(nodeByPath instanceof ChoiceCaseNode)) {
                    boolean _notEquals;
                    String _localName = pathElement.getLocalName();
                    result.append(_localName);
                    int _size = path.size();
                    int _minus = _size - 1;
                    boolean bl2 = _notEquals = i != _minus;
                    if (_notEquals) {
                        result.append("/");
                    }
                }
                ++i;
            }
        }
        return result.toString();
    }

    private void collectChildNodes(Collection<DataSchemaNode> source, Map<SchemaPath, DataSchemaNode> destination) {
        for (DataSchemaNode node : source) {
            SchemaPath _path = node.getPath();
            destination.put(_path, node);
            if (node instanceof DataNodeContainer) {
                Collection _childNodes = ((DataNodeContainer)node).getChildNodes();
                this.collectChildNodes(_childNodes, destination);
            }
            if (!(node instanceof ChoiceSchemaNode)) continue;
            ArrayList<DataSchemaNode> choiceCases = new ArrayList<DataSchemaNode>();
            Set _cases = ((ChoiceSchemaNode)node).getCases();
            for (ChoiceCaseNode caseNode : _cases) {
                choiceCases.add((DataSchemaNode)caseNode);
            }
            this.collectChildNodes(choiceCases, destination);
        }
    }

    private CharSequence _addedByInfo(SchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    private CharSequence _addedByInfo(DataSchemaNode node) {
        boolean _isAddedByUses;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAugmenting = node.isAugmenting();
        if (_isAugmenting) {
            _builder.append((Object)"(A)");
        }
        if (_isAddedByUses = node.isAddedByUses()) {
            _builder.append((Object)"(U)");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private boolean _isAddedBy(SchemaNode node) {
        return false;
    }

    private boolean _isAddedBy(DataSchemaNode node) {
        boolean _isAddedByUses;
        boolean _or = false;
        boolean _isAugmenting = node.isAugmenting();
        _or = _isAugmenting ? true : (_isAddedByUses = node.isAddedByUses());
        return _or;
    }

    private CharSequence _nodeName(SchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAddedBy = this.isAddedBy(node);
        if (_isAddedBy) {
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            CharSequence _italic = this.italic(_localName);
            _builder.append((Object)_italic, "");
            CharSequence _addedByInfo = this.addedByInfo(node);
            _builder.append((Object)_addedByInfo, "");
            _builder.newLineIfNotEmpty();
        } else {
            QName _qName_1 = node.getQName();
            String _localName_1 = _qName_1.getLocalName();
            _builder.append((Object)_localName_1, "");
            CharSequence _addedByInfo_1 = this.addedByInfo(node);
            _builder.append((Object)_addedByInfo_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence _nodeName(ContainerSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAddedBy = this.isAddedBy((SchemaNode)node);
        if (_isAddedBy) {
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            CharSequence _italic = this.italic(_localName);
            String _strong = this.strong(_italic);
            _builder.append((Object)_strong, "");
            CharSequence _addedByInfo = this.addedByInfo((SchemaNode)node);
            _builder.append((Object)_addedByInfo, "");
            _builder.newLineIfNotEmpty();
        } else {
            QName _qName_1 = node.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong_1 = this.strong(_localName_1);
            _builder.append((Object)_strong_1, "");
            CharSequence _addedByInfo_1 = this.addedByInfo((SchemaNode)node);
            _builder.append((Object)_addedByInfo_1, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence _nodeName(ListSchemaNode node) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isAddedBy = this.isAddedBy((SchemaNode)node);
        if (_isAddedBy) {
            List _keyDefinition_1;
            boolean _isEmpty;
            boolean _not;
            boolean _tripleNotEquals;
            QName _qName = node.getQName();
            String _localName = _qName.getLocalName();
            CharSequence _italic = this.italic(_localName);
            String _strong = this.strong(_italic);
            _builder.append((Object)_strong, "");
            _builder.append((Object)" ");
            boolean _and = false;
            List _keyDefinition = node.getKeyDefinition();
            boolean bl = _tripleNotEquals = _keyDefinition != null;
            _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = (_keyDefinition_1 = node.getKeyDefinition()).isEmpty()));
            if (_and) {
                CharSequence _listKeys = this.listKeys(node);
                _builder.append((Object)_listKeys, "");
            }
            CharSequence _addedByInfo = this.addedByInfo((SchemaNode)node);
            _builder.append((Object)_addedByInfo, "");
            _builder.newLineIfNotEmpty();
        } else {
            List _keyDefinition_3;
            boolean _isEmpty_1;
            boolean _not_1;
            boolean _tripleNotEquals_1;
            QName _qName_1 = node.getQName();
            String _localName_1 = _qName_1.getLocalName();
            String _strong_1 = this.strong(_localName_1);
            _builder.append((Object)_strong_1, "");
            _builder.append((Object)" ");
            boolean _and_1 = false;
            List _keyDefinition_2 = node.getKeyDefinition();
            boolean bl = _tripleNotEquals_1 = _keyDefinition_2 != null;
            _and_1 = !_tripleNotEquals_1 ? false : (_not_1 = !(_isEmpty_1 = (_keyDefinition_3 = node.getKeyDefinition()).isEmpty()));
            if (_and_1) {
                CharSequence _listKeys_1 = this.listKeys(node);
                _builder.append((Object)_listKeys_1, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence tree(DataSchemaNode node, YangInstanceIdentifier path) {
        if (node instanceof ChoiceSchemaNode) {
            return this._tree((ChoiceSchemaNode)node, path);
        }
        if (node instanceof ContainerSchemaNode) {
            return this._tree((ContainerSchemaNode)node, path);
        }
        if (node instanceof ListSchemaNode) {
            return this._tree((ListSchemaNode)node, path);
        }
        if (node != null) {
            return this._tree(node, path);
        }
        if (node == null) {
            return this._tree((Void)null, path);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, path).toString());
    }

    private CharSequence asXmlExampleTag(DataSchemaNode node, YangInstanceIdentifier identifier) {
        if (node instanceof ContainerSchemaNode) {
            return this._asXmlExampleTag((ContainerSchemaNode)node, identifier);
        }
        if (node instanceof LeafListSchemaNode) {
            return this._asXmlExampleTag((LeafListSchemaNode)node, identifier);
        }
        if (node instanceof LeafSchemaNode) {
            return this._asXmlExampleTag((LeafSchemaNode)node, identifier);
        }
        if (node instanceof ListSchemaNode) {
            return this._asXmlExampleTag((ListSchemaNode)node, identifier);
        }
        if (node != null) {
            return this._asXmlExampleTag(node, identifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, identifier).toString());
    }

    private CharSequence printInfo(DataSchemaNode node, int level, YangInstanceIdentifier path) {
        if (node instanceof ChoiceCaseNode) {
            return this._printInfo((ChoiceCaseNode)node, level, path);
        }
        if (node instanceof ChoiceSchemaNode) {
            return this._printInfo((ChoiceSchemaNode)node, level, path);
        }
        if (node instanceof ContainerSchemaNode) {
            return this._printInfo((ContainerSchemaNode)node, level, path);
        }
        if (node instanceof ListSchemaNode) {
            return this._printInfo((ListSchemaNode)node, level, path);
        }
        if (node != null) {
            return this._printInfo(node, level, path);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node, level, path).toString());
    }

    private YangInstanceIdentifier append(YangInstanceIdentifier identifier, Object node) {
        if (node instanceof ContainerSchemaNode) {
            return this._append(identifier, (ContainerSchemaNode)node);
        }
        if (node instanceof ListSchemaNode) {
            return this._append(identifier, (ListSchemaNode)node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(identifier, node).toString());
    }

    private CharSequence toLength(TypeDefinition<?> type) {
        if (type instanceof BinaryTypeDefinition) {
            return this._toLength((BinaryTypeDefinition)type);
        }
        if (type instanceof StringTypeDefinition) {
            return this._toLength((StringTypeDefinition)type);
        }
        if (type instanceof ExtendedType) {
            return this._toLength((ExtendedType)type);
        }
        if (type != null) {
            return this._toLength(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    private CharSequence toRange(TypeDefinition<?> type) {
        if (type instanceof DecimalTypeDefinition) {
            return this._toRange((DecimalTypeDefinition)type);
        }
        if (type instanceof IntegerTypeDefinition) {
            return this._toRange((IntegerTypeDefinition)type);
        }
        if (type instanceof UnsignedIntegerTypeDefinition) {
            return this._toRange((UnsignedIntegerTypeDefinition)type);
        }
        if (type instanceof ExtendedType) {
            return this._toRange((ExtendedType)type);
        }
        if (type != null) {
            return this._toRange(type);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(type).toString());
    }

    private CharSequence addedByInfo(SchemaNode node) {
        if (node instanceof DataSchemaNode) {
            return this._addedByInfo((DataSchemaNode)node);
        }
        if (node != null) {
            return this._addedByInfo(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    private boolean isAddedBy(SchemaNode node) {
        if (node instanceof DataSchemaNode) {
            return this._isAddedBy((DataSchemaNode)node);
        }
        if (node != null) {
            return this._isAddedBy(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    private CharSequence nodeName(SchemaNode node) {
        if (node instanceof ContainerSchemaNode) {
            return this._nodeName((ContainerSchemaNode)node);
        }
        if (node instanceof ListSchemaNode) {
            return this._nodeName((ListSchemaNode)node);
        }
        if (node != null) {
            return this._nodeName(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }
}

